/*
 * Decompiled with CFR 0.152.
 */
package jrdesktop.utilities;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

public class ImageUtility {
    public static BufferedImage read(InputStream in) throws IOException {
        BufferedImage image = null;
        image = ImageIO.read(in);
        if (image == null) {
            throw new IOException("Read fails");
        }
        return image;
    }

    public static BufferedImage read(byte[] bytes) {
        try {
            return ImageUtility.read(new ByteArrayInputStream(bytes));
        }
        catch (IOException e) {
            e.getStackTrace();
            return null;
        }
    }

    public static byte[] toByteArray(BufferedImage image) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "jpeg", out);
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        ImageIO.setUseCache(false);
    }
}

