/*
 * Decompiled with CFR 0.152.
 */
package jrdesktop.server;

import java.awt.AWTException;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import jrdesktop.utilities.ImageUtility;

public class robot {
    private Robot rt;
    private Toolkit tk = Toolkit.getDefaultToolkit();
    private Rectangle screenRect = new Rectangle(this.tk.getScreenSize());

    public robot() {
        try {
            this.rt = new Robot();
        }
        catch (AWTException awte) {
            awte.getStackTrace();
        }
    }

    public BufferedImage captureScreen() {
        this.screenRect = new Rectangle(this.tk.getScreenSize());
        return this.rt.createScreenCapture(this.screenRect);
    }

    public byte[] CaptureScreenByteArray() {
        return ImageUtility.toByteArray(this.captureScreen());
    }

    public Rectangle getScreenRect() {
        return this.screenRect;
    }

    public void updateData(Object object) {
        ArrayList Objects = (ArrayList)object;
        for (int i = 0; i < Objects.size(); ++i) {
            Object obj = Objects.get(i);
            if (obj instanceof MouseEvent) {
                this.applyMouseEvent((MouseEvent)obj);
                continue;
            }
            if (!(obj instanceof KeyEvent)) continue;
            this.applyKeyEvent((KeyEvent)obj);
        }
    }

    public void applyMouseEvent(MouseEvent evt) {
        this.rt.mouseMove(evt.getX(), evt.getY());
        int buttonMask = 0;
        int buttons = evt.getButton();
        if (buttons == 1) {
            buttonMask = 16;
        }
        if (buttons == 2) {
            buttonMask |= 8;
        }
        if (buttons == 3) {
            buttonMask |= 4;
        }
        switch (evt.getID()) {
            case 501: {
                this.rt.mousePress(buttonMask);
                break;
            }
            case 502: {
                this.rt.mouseRelease(buttonMask);
                break;
            }
            case 507: {
                this.rt.mouseWheel(((MouseWheelEvent)evt).getUnitsToScroll());
            }
        }
    }

    public void applyKeyEvent(KeyEvent evt) {
        switch (evt.getID()) {
            case 401: {
                this.rt.keyPress(evt.getKeyCode());
                break;
            }
            case 402: {
                this.rt.keyRelease(evt.getKeyCode());
            }
        }
    }
}

