/*
 * Decompiled with CFR 0.152.
 */
package jrdesktop.viewer;

import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Hashtable;
import jrdesktop.Commons;
import jrdesktop.ConnectionInfos;
import jrdesktop.utilities.screenCaptureCompressor.ScreenCapture;

public class ViewerOptions {
    private boolean changed = false;
    private InetAddress inetAddress;
    private float imageQuality = -1.0f;
    private float screenScale = 1.0f;
    private int colorQuality = 1;
    private boolean clipboardTransfer = true;
    private Rectangle screenRect = Commons.emptyRect;
    private Hashtable properties = new Hashtable();
    public ConnectionInfos connectionInfos;
    public BufferedImage screenImage = null;
    public ScreenCapture capture = null;
    public int blocks = 20;
    public boolean screenCompression = true;
    public int refreshRate = 500;

    public int getRefreshRate() {
        return this.refreshRate;
    }

    public boolean isScreenCompressionEnabled() {
        return this.screenCompression;
    }

    public void setRefreshRate(int rate) {
        this.refreshRate = rate;
    }

    public void setScreenCompression(boolean bool) {
        this.screenCompression = bool;
    }

    public ScreenCapture getCapture() {
        return this.capture;
    }

    public void setScreenImage(BufferedImage screenImage) {
        this.screenImage = screenImage;
    }

    public BufferedImage getScreenImage() {
        return this.screenImage;
    }

    public ViewerOptions(InetAddress inetAddress, Hashtable props) {
        this.inetAddress = inetAddress;
        this.properties = props;
        this.capture = new ScreenCapture(this.imageQuality, this.blocks, this.blocks);
        this.setNewScreenImage(new Rectangle(Toolkit.getDefaultToolkit().getScreenSize()), this.colorQuality);
    }

    public ViewerOptions(InetAddress inetAddress) {
        this.screenRect = new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
        this.inetAddress = inetAddress;
        this.connectionInfos = new ConnectionInfos(true);
        this.capture = new ScreenCapture(this.imageQuality, this.blocks, this.blocks);
        this.setNewScreenImage(new Rectangle(Toolkit.getDefaultToolkit().getScreenSize()), this.colorQuality);
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean bool) {
        this.changed = bool;
    }

    public InetAddress getInetAddress() {
        return this.inetAddress;
    }

    public void setInetAddress(InetAddress inetAddress) {
        this.inetAddress = inetAddress;
    }

    public void setImageQuality(float cq) {
        this.imageQuality = cq;
    }

    public float getImageQuality() {
        return this.imageQuality;
    }

    public void setColorQuality(int clQuality) {
        this.colorQuality = clQuality;
    }

    public int getColorQuality() {
        return this.colorQuality;
    }

    public void setScreenScale(float screenScale) {
        this.screenScale = screenScale;
    }

    public float getScreenScale() {
        return this.screenScale;
    }

    public void setScreenRect(Rectangle rect) {
        this.screenRect = rect;
    }

    public Rectangle getScreenRect() {
        return this.screenRect;
    }

    public void setClipboardTransfer(boolean clipboardTransfer) {
        this.clipboardTransfer = clipboardTransfer;
    }

    public boolean getClipboardTransfer() {
        return this.clipboardTransfer;
    }

    public Hashtable getProperties() {
        return this.properties;
    }

    public void setProperties(Hashtable props) {
        this.properties = props;
    }

    public ArrayList getOptions() {
        ArrayList<Serializable> data = new ArrayList<Serializable>();
        data.add(this.screenRect);
        data.add(Float.valueOf(this.imageQuality));
        data.add(Integer.valueOf(this.colorQuality));
        data.add(Boolean.valueOf(this.clipboardTransfer));
        return data;
    }

    public void setOptions(Object data) {
        ArrayList Options = (ArrayList)data;
        this.screenRect = (Rectangle)Options.get(0);
        this.imageQuality = ((Float)Options.get(1)).floatValue();
        this.colorQuality = (Integer)Options.get(2);
        this.clipboardTransfer = (Boolean)Options.get(3);
    }

    public Object getOption(int option) {
        Serializable data = null;
        switch (option) {
            case 0: {
                data = this.screenRect;
                break;
            }
            case 1: {
                data = Float.valueOf(this.imageQuality);
                break;
            }
            case 2: {
                data = Integer.valueOf(this.colorQuality);
                break;
            }
            case 3: {
                data = Boolean.valueOf(this.clipboardTransfer);
            }
        }
        return data;
    }

    public void setOption(Object data, int option) {
        switch (option) {
            case 0: {
                this.screenRect = (Rectangle)data;
                break;
            }
            case 1: {
                this.imageQuality = ((Float)data).floatValue();
                break;
            }
            case 2: {
                this.colorQuality = (Integer)data;
                break;
            }
            case 3: {
                this.clipboardTransfer = (Boolean)data;
            }
        }
    }

    public void setNewScreenImage(Rectangle rectangle, int colorQuality) {
        this.screenImage = new BufferedImage(rectangle.width, rectangle.height, colorQuality);
    }

    public void setNewScreenRect() {
        this.screenRect = new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
    }
}

