/*
 * Decompiled with CFR 0.152.
 */
package jrdesktop.viewer;

import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import jrdesktop.Commons;
import jrdesktop.HostProperties;
import jrdesktop.main;
import jrdesktop.viewer.Recorder;
import org.jdesktop.layout.GroupLayout;

public class ViewerGUI
extends JFrame {
    private boolean fullScreenMode = false;
    private Recorder recorder;
    private JButton jBtnClose;
    private JButton jBtnFileTransfer;
    private JButton jBtnFullNormal;
    private JButton jBtnHelp;
    public JButton jBtnPartialComplete;
    private JButton jBtnStartStop;
    private JButton jBtnViewCtrl;
    private JCheckBox jCheckBoxClipTrans;
    private JCheckBox jCheckBoxImageQuality;
    private JCheckBox jCheckBoxScreenCompress;
    private JComboBox jComboBoxColorQuality;
    private JComboBox jComboBoxImageQuality;
    private JComboBox jComboBoxRefreshRate;
    private JComboBox jComboBoxScreenZoom;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JMenuItem jMenuItemAbout;
    private JMenuItem jMenuItemConnectInfo;
    private JMenuItem jMenuItemHostProps;
    private JMenuItem jMenuItemReceiveFilesFromClipbrd;
    private JMenuItem jMenuItemSendFilesFromClipbrd;
    private JPopupMenu jPopupMenuFileTranfer;
    private JPopupMenu jPopupMenuHelp;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator10;
    private JToolBar.Separator jSeparator11;
    private JToolBar.Separator jSeparator12;
    private JToolBar.Separator jSeparator13;
    private JToolBar.Separator jSeparator14;
    private JToolBar.Separator jSeparator15;
    private JToolBar.Separator jSeparator4;
    private JToolBar.Separator jSeparator5;
    private JToolBar.Separator jSeparator6;
    private JToolBar.Separator jSeparator9;
    private JToggleButton jToggleBtnPauseResume;
    private JToolBar jToolBar1;

    public ViewerGUI(Recorder recorder) {
        this.recorder = recorder;
        this.initComponents();
        this.jScrollPane1.setViewportView(recorder.screenPlayer);
        this.setVisible(true);
        ++main.activeConnection;
    }

    public void Start() {
        this.jBtnStartStopActionPerformed(null);
    }

    private void initComponents() {
        this.jPopupMenuFileTranfer = new JPopupMenu();
        this.jMenuItemSendFilesFromClipbrd = new JMenuItem();
        this.jMenuItemReceiveFilesFromClipbrd = new JMenuItem();
        this.jPopupMenuHelp = new JPopupMenu();
        this.jMenuItemConnectInfo = new JMenuItem();
        this.jMenuItemHostProps = new JMenuItem();
        this.jMenuItemAbout = new JMenuItem();
        this.jToolBar1 = new JToolBar();
        this.jBtnStartStop = new JButton();
        this.jToggleBtnPauseResume = new JToggleButton();
        this.jBtnViewCtrl = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.jBtnFullNormal = new JButton();
        this.jBtnPartialComplete = new JButton();
        this.jSeparator9 = new JToolBar.Separator();
        this.jLabel2 = new JLabel();
        this.jComboBoxScreenZoom = new JComboBox();
        this.jSeparator4 = new JToolBar.Separator();
        this.jLabel3 = new JLabel();
        this.jCheckBoxScreenCompress = new JCheckBox();
        this.jSeparator15 = new JToolBar.Separator();
        this.jLabel4 = new JLabel();
        this.jCheckBoxImageQuality = new JCheckBox();
        this.jComboBoxImageQuality = new JComboBox();
        this.jSeparator11 = new JToolBar.Separator();
        this.jLabel1 = new JLabel();
        this.jComboBoxColorQuality = new JComboBox();
        this.jSeparator14 = new JToolBar.Separator();
        this.jLabel6 = new JLabel();
        this.jComboBoxRefreshRate = new JComboBox();
        this.jSeparator5 = new JToolBar.Separator();
        this.jLabel5 = new JLabel();
        this.jCheckBoxClipTrans = new JCheckBox();
        this.jSeparator13 = new JToolBar.Separator();
        this.jBtnFileTransfer = new JButton();
        this.jSeparator6 = new JToolBar.Separator();
        this.jBtnHelp = new JButton();
        this.jSeparator12 = new JToolBar.Separator();
        this.jBtnClose = new JButton();
        this.jSeparator10 = new JToolBar.Separator();
        this.jScrollPane1 = new JScrollPane();
        this.jMenuItemSendFilesFromClipbrd.setText("Send files from clipborad");
        this.jMenuItemSendFilesFromClipbrd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ViewerGUI.this.jMenuItemSendFilesFromClipbrdActionPerformed(evt);
            }
        });
        this.jPopupMenuFileTranfer.add(this.jMenuItemSendFilesFromClipbrd);
        this.jMenuItemReceiveFilesFromClipbrd.setText("Receive files from clipboard");
        this.jMenuItemReceiveFilesFromClipbrd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ViewerGUI.this.jMenuItemReceiveFilesFromClipbrdActionPerformed(evt);
            }
        });
        this.jPopupMenuFileTranfer.add(this.jMenuItemReceiveFilesFromClipbrd);
        this.jMenuItemConnectInfo.setIcon(new ImageIcon(this.getClass().getResource("/jrdesktop/images/info.png")));
        this.jMenuItemConnectInfo.setText("Connection infos");
        this.jMenuItemConnectInfo.setToolTipText("");
        this.jMenuItemConnectInfo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ViewerGUI.this.jMenuItemConnectInfoActionPerformed(evt);
            }
        });
        this.jPopupMenuHelp.add(this.jMenuItemConnectInfo);
        this.jMenuItemHostProps.setIcon(new ImageIcon(this.getClass().getResource("/jrdesktop/images/props.png")));
        this.jMenuItemHostProps.setText("Remote host properties");
        this.jMenuItemHostProps.setToolTipText("");
        this.jMenuItemHostProps.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ViewerGUI.this.jMenuItemHostPropsActionPerformed(evt);
            }
        });
        this.jPopupMenuHelp.add(this.jMenuItemHostProps);
        this.jMenuItemAbout.setIcon(new ImageIcon(this.getClass().getResource("/jrdesktop/images/about.png")));
        this.jMenuItemAbout.setText("About jrdesktop");
        this.jMenuItemAbout.setToolTipText("");
        this.jMenuItemAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ViewerGUI.this.jMenuItemAboutActionPerformed(evt);
            }
        });
        this.jPopupMenuHelp.add(this.jMenuItemAbout);
        this.setDefaultCloseOperation(0);
        this.setTitle(" jrdesktop Viewer");
        this.setIconImage(new ImageIcon(Commons.WAIT_ICON).getImage());
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent evt) {
                ViewerGUI.this.formWindowActivated(evt);
            }

            public void windowClosing(WindowEvent evt) {
                ViewerGUI.this.formWindowClosing(evt);
            }

            public void windowDeactivated(WindowEvent evt) {
                ViewerGUI.this.formWindowDeactivated(evt);
            }

            public void windowDeiconified(WindowEvent evt) {
                ViewerGUI.this.formWindowDeiconified(evt);
            }

            public void windowIconified(WindowEvent evt) {
                ViewerGUI.this.formWindowIconified(evt);
            }
        });
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setFocusable(false);
        this.jToolBar1.setMaximumSize(new Dimension(713, 35));
        this.jBtnStartStop.setIcon(new ImageIcon(this.getClass().getResource("/jrdesktop/images/player_stop.png")));
        this.jBtnStartStop.setToolTipText("Start/Stop recording");
        this.jBtnStartStop.setFocusable(false);
        this.jBtnStartStop.setHorizontalTextPosition(0);
        this.jBtnStartStop.setVerticalTextPosition(3);
        this.jBtnStartStop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ViewerGUI.this.jBtnStartStopActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jBtnStartStop);
        this.jToggleBtnPauseResume.setIcon(new ImageIcon(this.getClass().getResource("/jrdesktop/images/player_pause.png")));
        this.jToggleBtnPauseResume.setToolTipText("Pause/Resume recording");
        this.jToggleBtnPauseResume.setFocusable(false);
        this.jToggleBtnPauseResume.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ViewerGUI.this.jToggleBtnPauseResumeActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jToggleBtnPauseResume);
        this.jBtnViewCtrl.setIcon(new ImageIcon(this.getClass().getResource("/jrdesktop/images/locked_inputs.png")));
        this.jBtnViewCtrl.setToolTipText("View only / Full control");
        this.jBtnViewCtrl.setFocusable(false);
        this.jBtnViewCtrl.setHorizontalTextPosition(0);
        this.jBtnViewCtrl.setVerticalTextPosition(3);
        this.jBtnViewCtrl.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ViewerGUI.this.jBtnViewCtrlActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jBtnViewCtrl);
        this.jToolBar1.add(this.jSeparator1);
        this.jBtnFullNormal.setIcon(new ImageIcon(this.getClass().getResource("/jrdesktop/images/view_fullscreen.png")));
        this.jBtnFullNormal.setToolTipText("Full / Normal screen");
        this.jBtnFullNormal.setFocusable(false);
        this.jBtnFullNormal.setHorizontalTextPosition(0);
        this.jBtnFullNormal.setVerticalTextPosition(3);
        this.jBtnFullNormal.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ViewerGUI.this.jBtnFullNormalActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jBtnFullNormal);
        this.jBtnPartialComplete.setIcon(new ImageIcon(this.getClass().getResource("/jrdesktop/images/custom_screen.png")));
        this.jBtnPartialComplete.setToolTipText("Custom / Default screen");
        this.jBtnPartialComplete.setFocusable(false);
        this.jBtnPartialComplete.setHorizontalTextPosition(0);
        this.jBtnPartialComplete.setVerticalTextPosition(3);
        this.jBtnPartialComplete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ViewerGUI.this.jBtnPartialCompleteActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jBtnPartialComplete);
        this.jToolBar1.add(this.jSeparator9);
        this.jLabel2.setIcon(new ImageIcon(this.getClass().getResource("/jrdesktop/images/scale.png")));
        this.jLabel2.setText(" ");
        this.jLabel2.setToolTipText("Screen zoom (%)");
        this.jLabel2.setFocusable(false);
        this.jToolBar1.add(this.jLabel2);
        this.jComboBoxScreenZoom.setModel(new DefaultComboBoxModel<String>(new String[]{"25", "50", "75", "100", "125", "150", "200"}));
        this.jComboBoxScreenZoom.setSelectedIndex(3);
        this.jComboBoxScreenZoom.setToolTipText("Change screen zoom (%)");
        this.jComboBoxScreenZoom.setFocusable(false);
        this.jComboBoxScreenZoom.setMaximumSize(new Dimension(70, 20));
        this.jComboBoxScreenZoom.setMinimumSize(new Dimension(70, 20));
        this.jComboBoxScreenZoom.setPreferredSize(new Dimension(70, 20));
        this.jComboBoxScreenZoom.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                ViewerGUI.this.jComboBoxScreenZoomItemStateChanged(evt);
            }
        });
        this.jToolBar1.add(this.jComboBoxScreenZoom);
        this.jToolBar1.add(this.jSeparator4);
        this.jLabel3.setIcon(new ImageIcon(this.getClass().getResource("/jrdesktop/images/compress.png")));
        this.jLabel3.setToolTipText("Screen Compression");
        this.jToolBar1.add(this.jLabel3);
        this.jCheckBoxScreenCompress.setSelected(true);
        this.jCheckBoxScreenCompress.setToolTipText("Enable/Disable Screen Compression");
        this.jCheckBoxScreenCompress.setFocusable(false);
        this.jCheckBoxScreenCompress.setHorizontalTextPosition(0);
        this.jCheckBoxScreenCompress.setVerticalTextPosition(3);
        this.jCheckBoxScreenCompress.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ViewerGUI.this.jCheckBoxScreenCompressActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jCheckBoxScreenCompress);
        this.jToolBar1.add(this.jSeparator15);
        this.jLabel4.setIcon(new ImageIcon(this.getClass().getResource("/jrdesktop/images/jpeg.png")));
        this.jLabel4.setToolTipText("JPEG image quality");
        this.jLabel4.setFocusable(false);
        this.jToolBar1.add(this.jLabel4);
        this.jCheckBoxImageQuality.setToolTipText("Enable/Disable JPEG image quality");
        this.jCheckBoxImageQuality.setFocusable(false);
        this.jCheckBoxImageQuality.setHorizontalTextPosition(2);
        this.jCheckBoxImageQuality.setVerticalTextPosition(3);
        this.jCheckBoxImageQuality.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ViewerGUI.this.jCheckBoxImageQualityActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jCheckBoxImageQuality);
        this.jComboBoxImageQuality.setModel(new DefaultComboBoxModel<String>(new String[]{"0", "25", "33", "50", "66", "75", "100"}));
        this.jComboBoxImageQuality.setSelectedIndex(5);
        this.jComboBoxImageQuality.setToolTipText("Change image quality (%)");
        this.jComboBoxImageQuality.setEnabled(false);
        this.jComboBoxImageQuality.setFocusable(false);
        this.jComboBoxImageQuality.setMaximumSize(new Dimension(65, 20));
        this.jComboBoxImageQuality.setMinimumSize(new Dimension(65, 20));
        this.jComboBoxImageQuality.setPreferredSize(new Dimension(65, 20));
        this.jComboBoxImageQuality.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                ViewerGUI.this.jComboBoxImageQualityItemStateChanged(evt);
            }
        });
        this.jToolBar1.add(this.jComboBoxImageQuality);
        this.jToolBar1.add(this.jSeparator11);
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/jrdesktop/images/colors.png")));
        this.jLabel1.setText(" ");
        this.jLabel1.setToolTipText("Color quality");
        this.jLabel1.setFocusable(false);
        this.jToolBar1.add(this.jLabel1);
        this.jComboBoxColorQuality.setModel(new DefaultComboBoxModel<String>(new String[]{"High", "Medium", "Low", "Gray"}));
        this.jComboBoxColorQuality.setToolTipText("Change color quality");
        this.jComboBoxColorQuality.setFocusable(false);
        this.jComboBoxColorQuality.setLightWeightPopupEnabled(false);
        this.jComboBoxColorQuality.setMaximumSize(new Dimension(85, 20));
        this.jComboBoxColorQuality.setMinimumSize(new Dimension(85, 20));
        this.jComboBoxColorQuality.setPreferredSize(new Dimension(85, 20));
        this.jComboBoxColorQuality.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                ViewerGUI.this.jComboBoxColorQualityItemStateChanged(evt);
            }
        });
        this.jToolBar1.add(this.jComboBoxColorQuality);
        this.jToolBar1.add(this.jSeparator14);
        this.jLabel6.setIcon(new ImageIcon(this.getClass().getResource("/jrdesktop/images/delay.png")));
        this.jLabel6.setToolTipText("Refresh rate (ms)");
        this.jToolBar1.add(this.jLabel6);
        this.jComboBoxRefreshRate.setModel(new DefaultComboBoxModel<String>(new String[]{"0", "250", "500", "750", "1000", "3000", "6000", "9000"}));
        this.jComboBoxRefreshRate.setSelectedIndex(2);
        this.jComboBoxRefreshRate.setToolTipText("Change screen refresh rate");
        this.jComboBoxRefreshRate.setFocusable(false);
        this.jComboBoxRefreshRate.setMaximumSize(new Dimension(70, 20));
        this.jComboBoxRefreshRate.setMinimumSize(new Dimension(70, 20));
        this.jComboBoxRefreshRate.setPreferredSize(new Dimension(70, 20));
        this.jComboBoxRefreshRate.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                ViewerGUI.this.jComboBoxRefreshRateItemStateChanged(evt);
            }
        });
        this.jToolBar1.add(this.jComboBoxRefreshRate);
        this.jToolBar1.add(this.jSeparator5);
        this.jLabel5.setIcon(new ImageIcon(this.getClass().getResource("/jrdesktop/images/clip_trans.png")));
        this.jLabel5.setToolTipText("Clipboard tranfer");
        this.jLabel5.setFocusable(false);
        this.jToolBar1.add(this.jLabel5);
        this.jCheckBoxClipTrans.setSelected(true);
        this.jCheckBoxClipTrans.setToolTipText("Enable/Disable Clipboard transfer");
        this.jCheckBoxClipTrans.setFocusable(false);
        this.jCheckBoxClipTrans.setHorizontalTextPosition(2);
        this.jCheckBoxClipTrans.setVerticalTextPosition(3);
        this.jCheckBoxClipTrans.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ViewerGUI.this.jCheckBoxClipTransActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jCheckBoxClipTrans);
        this.jToolBar1.add(this.jSeparator13);
        this.jBtnFileTransfer.setIcon(new ImageIcon(this.getClass().getResource("/jrdesktop/images/file_trans.png")));
        this.jBtnFileTransfer.setToolTipText("File transfer");
        this.jBtnFileTransfer.setFocusable(false);
        this.jBtnFileTransfer.setHorizontalTextPosition(0);
        this.jBtnFileTransfer.setVerticalTextPosition(3);
        this.jBtnFileTransfer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ViewerGUI.this.jBtnFileTransferActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jBtnFileTransfer);
        this.jToolBar1.add(this.jSeparator6);
        this.jBtnHelp.setIcon(new ImageIcon(this.getClass().getResource("/jrdesktop/images/help.png")));
        this.jBtnHelp.setToolTipText("Help");
        this.jBtnHelp.setFocusable(false);
        this.jBtnHelp.setHorizontalTextPosition(0);
        this.jBtnHelp.setVerticalTextPosition(3);
        this.jBtnHelp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ViewerGUI.this.jBtnHelpActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jBtnHelp);
        this.jToolBar1.add(this.jSeparator12);
        this.jBtnClose.setIcon(new ImageIcon(this.getClass().getResource("/jrdesktop/images/exit.png")));
        this.jBtnClose.setToolTipText("Exit viewer");
        this.jBtnClose.setFocusable(false);
        this.jBtnClose.setHorizontalTextPosition(0);
        this.jBtnClose.setVerticalTextPosition(3);
        this.jBtnClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ViewerGUI.this.jBtnCloseActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jBtnClose);
        this.jToolBar1.add(this.jSeparator10);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(this.jScrollPane1, -1, 818, Short.MAX_VALUE).add(this.jToolBar1, -1, 818, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(this.jToolBar1, -2, 25, -2).addPreferredGap(0).add(this.jScrollPane1, -1, 389, Short.MAX_VALUE)));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 828) / 2, (screenSize.height - 450) / 2, 828, 450);
    }

    private void jBtnStartStopActionPerformed(ActionEvent evt) {
        if (this.recorder.isRecording()) {
            this.recorder.Stop();
        } else {
            this.recorder.Start();
        }
        if (this.recorder.isRecording()) {
            this.setIconImage(new ImageIcon(Commons.ALIVE_ICON).getImage());
            this.jBtnStartStop.setIcon(new ImageIcon(Commons.STOP_ICON));
            this.setTitle("jrdesktop Viewer [" + this.recorder.config.server_address + "]");
        } else {
            this.setTitle("jrdesktop Viewer");
            this.setIconImage(new ImageIcon(Commons.WAIT_ICON).getImage());
            this.jBtnStartStop.setIcon(new ImageIcon(Commons.START_ICON));
            this.jToggleBtnPauseResume.setSelected(false);
            this.jBtnViewCtrl.setIcon(new ImageIcon(Commons.LOCKED_INPUTS_ICON));
            this.jBtnFullNormal.setIcon(new ImageIcon(Commons.FULL_SCREEN_ICON));
            this.jBtnPartialComplete.setIcon(new ImageIcon(Commons.CUSTOM_SCREEN_ICON));
        }
    }

    private void jBtnViewCtrlActionPerformed(ActionEvent evt) {
        this.recorder.setViewOnly(!this.recorder.isViewOnly());
        if (this.recorder.isViewOnly()) {
            this.jBtnViewCtrl.setIcon(new ImageIcon(Commons.INPUTS_ICON));
        } else {
            this.jBtnViewCtrl.setIcon(new ImageIcon(Commons.LOCKED_INPUTS_ICON));
        }
    }

    private void jBtnFullNormalActionPerformed(ActionEvent evt) {
        this.changeFullScreenMode();
    }

    private void jBtnPartialCompleteActionPerformed(ActionEvent evt) {
        if (this.recorder.isRecording()) {
            if (this.recorder.screenPlayer.isPartialScreenMode()) {
                this.jBtnPartialComplete.setIcon(new ImageIcon(Commons.CUSTOM_SCREEN_ICON));
                this.recorder.screenPlayer.stopSelectingMode();
            } else {
                this.recorder.screenPlayer.startSelectingMode();
            }
        }
    }

    private void jCheckBoxImageQualityActionPerformed(ActionEvent evt) {
        this.jComboBoxImageQuality.setEnabled(this.jCheckBoxImageQuality.isSelected());
        if (!this.jCheckBoxImageQuality.isSelected()) {
            this.recorder.viewerOptions.setImageQuality(-1.0f);
        } else {
            this.recorder.viewerOptions.setImageQuality(Float.valueOf(this.jComboBoxImageQuality.getSelectedItem().toString()).floatValue() / 100.0f);
        }
        if (this.recorder.isRecording()) {
            if (this.recorder.config.reverseConnection) {
                this.recorder.viewerOptions.setChanged(true);
            } else {
                this.recorder.viewer.setOption(1);
            }
        }
    }

    private void jComboBoxColorQualityItemStateChanged(ItemEvent evt) {
        this.setColorQuality(this.jComboBoxColorQuality.getSelectedIndex());
    }

    private void formWindowClosing(WindowEvent evt) {
        if (evt.getID() == 201) {
            this.jBtnCloseActionPerformed(null);
        } else {
            super.processWindowEvent(evt);
        }
    }

    private void jCheckBoxClipTransActionPerformed(ActionEvent evt) {
        this.setClipboardTransfer(this.jCheckBoxClipTrans.isSelected());
    }

    private void jBtnFileTransferActionPerformed(ActionEvent evt) {
        this.jPopupMenuFileTranfer.show(this.jBtnFileTransfer, 15, 15);
    }

    private void jMenuItemSendFilesFromClipbrdActionPerformed(ActionEvent evt) {
        if (!this.recorder.isRecording()) {
            return;
        }
        File[] files = this.recorder.clipbrdUtility.getFiles();
        if (files.length == 0) {
            JOptionPane.showMessageDialog(this, "No file in clipboard !!", "Information", 1);
            return;
        }
        this.recorder.fileManager.setFiles(files);
        this.recorder.viewer.SendFiles();
    }

    private void jMenuItemReceiveFilesFromClipbrdActionPerformed(ActionEvent evt) {
        if (!this.recorder.isRecording()) {
            return;
        }
        this.recorder.viewer.ReceiveFiles();
    }

    private void jToggleBtnPauseResumeActionPerformed(ActionEvent evt) {
        if (this.recorder.isRecording()) {
            this.recorder.setPause(!this.recorder.isPaused());
            if (this.recorder.isPaused()) {
                this.jToggleBtnPauseResume.setSelected(true);
            } else {
                this.jToggleBtnPauseResume.setSelected(false);
            }
        }
    }

    private void jBtnCloseActionPerformed(ActionEvent evt) {
        if (JOptionPane.showConfirmDialog(null, "Exit Viewer ?", "Confirm Dialog", 2) == 0) {
            this.recorder.terminate();
            this.dispose();
            --main.activeConnection;
            main.displayTab(0);
        }
    }

    private void formWindowActivated(WindowEvent evt) {
        if (this.recorder.viewerOptions.getClipboardTransfer()) {
            this.recorder.clipbrdUtility.addFlavorListener();
        }
        if (this.recorder.isRecording() && !this.recorder.isPaused() && !this.recorder.isViewOnly()) {
            this.recorder.eventsListener.addAdapters();
        }
    }

    private void formWindowDeactivated(WindowEvent evt) {
        if (this.recorder.viewerOptions.getClipboardTransfer()) {
            this.recorder.clipbrdUtility.removeFlavorListener();
        }
        this.recorder.eventsListener.removeAdapters();
    }

    private void formWindowIconified(WindowEvent evt) {
        if (this.recorder.isRecording()) {
            this.recorder.setHold(true);
        }
    }

    private void formWindowDeiconified(WindowEvent evt) {
        if (this.recorder.isRecording()) {
            this.recorder.setHold(false);
        }
        this.recorder.Notify();
    }

    private void jCheckBoxScreenCompressActionPerformed(ActionEvent evt) {
        this.recorder.viewerOptions.setScreenCompression(this.jCheckBoxScreenCompress.isSelected());
    }

    private void jComboBoxRefreshRateItemStateChanged(ItemEvent evt) {
        this.recorder.viewerOptions.setRefreshRate(Integer.valueOf(this.jComboBoxRefreshRate.getSelectedItem().toString()));
    }

    private void jComboBoxImageQualityItemStateChanged(ItemEvent evt) {
        this.recorder.viewerOptions.setImageQuality(Float.valueOf(this.jComboBoxImageQuality.getSelectedItem().toString()).floatValue() / 100.0f);
        if (this.recorder.isRecording()) {
            if (this.recorder.config.reverseConnection) {
                this.recorder.viewerOptions.setChanged(true);
            } else {
                this.recorder.viewer.setOption(1);
            }
        }
    }

    private void jComboBoxScreenZoomItemStateChanged(ItemEvent evt) {
        this.recorder.viewerOptions.setScreenScale(Float.valueOf(this.jComboBoxScreenZoom.getSelectedItem().toString()).floatValue() / 100.0f);
    }

    private void jBtnHelpActionPerformed(ActionEvent evt) {
        this.jPopupMenuHelp.show(this.jBtnHelp, 15, 15);
    }

    private void jMenuItemConnectInfoActionPerformed(ActionEvent evt) {
        if (!this.recorder.isRecording()) {
            return;
        }
        if (this.recorder.config.reverseConnection) {
            this.recorder.viewerOptions.connectionInfos.display();
        } else {
            this.recorder.viewer.getConnectionInfos();
        }
    }

    private void jMenuItemHostPropsActionPerformed(ActionEvent evt) {
        if (!this.recorder.isRecording()) {
            return;
        }
        if (this.recorder.config.reverseConnection) {
            HostProperties.display(this.recorder.viewerOptions.getProperties());
        } else {
            this.recorder.viewer.getHostProperties();
        }
    }

    private void jMenuItemAboutActionPerformed(ActionEvent evt) {
        main.displayTab(4);
    }

    public boolean isFullScreenMode() {
        return this.fullScreenMode;
    }

    public void changeFullScreenMode() {
        GraphicsDevice device = this.getGraphicsConfiguration().getDevice();
        if (!device.isFullScreenSupported()) {
            return;
        }
        this.fullScreenMode = !this.fullScreenMode;
        this.dispose();
        if (this.fullScreenMode) {
            this.setUndecorated(true);
            device.setFullScreenWindow(this);
            this.jBtnFullNormal.setIcon(new ImageIcon(Commons.NORMAL_SCREEN_ICON));
        } else {
            this.setUndecorated(false);
            device.setFullScreenWindow(null);
            this.jBtnFullNormal.setIcon(new ImageIcon(Commons.FULL_SCREEN_ICON));
        }
        this.setVisible(true);
    }

    public void setColorQuality(int index) {
        int colorQuality = 1;
        switch (index) {
            case 0: {
                colorQuality = 1;
                break;
            }
            case 1: {
                colorQuality = 9;
                break;
            }
            case 2: {
                colorQuality = 13;
                break;
            }
            case 3: {
                colorQuality = 10;
            }
        }
        this.recorder.viewerOptions.setColorQuality(colorQuality);
        if (this.recorder.isRecording()) {
            if (this.recorder.config.reverseConnection) {
                this.recorder.viewerOptions.setChanged(true);
            } else {
                this.recorder.viewer.setOption(2);
            }
        }
    }

    public void setClipboardTransfer(boolean bool) {
        this.recorder.viewerOptions.setClipboardTransfer(bool);
        if (bool) {
            this.recorder.clipbrdUtility.addFlavorListener();
        } else {
            this.recorder.clipbrdUtility.removeFlavorListener();
        }
        if (this.recorder.isRecording()) {
            if (this.recorder.config.reverseConnection) {
                this.recorder.viewerOptions.setChanged(true);
            } else {
                this.recorder.viewer.setOption(3);
            }
        }
    }
}

