/*
 * Decompiled with CFR 0.152.
 */
package jrdesktop.viewer;

import java.net.InetAddress;
import jrdesktop.Config;
import jrdesktop.HostProperties;
import jrdesktop.rmi.server.RMIServer;
import jrdesktop.server.Server;
import jrdesktop.utilities.ClipbrdUtility;
import jrdesktop.utilities.InetAdrUtility;
import jrdesktop.viewer.EventsListener;
import jrdesktop.viewer.FileMng.FileManager;
import jrdesktop.viewer.ScreenPlayer;
import jrdesktop.viewer.Viewer;
import jrdesktop.viewer.ViewerGUI;
import jrdesktop.viewer.ViewerOptions;

public class Recorder
extends Thread {
    private boolean recording = false;
    private boolean viewOnly = false;
    private boolean pause = false;
    private boolean hold = false;
    private boolean side = false;
    public Config config;
    public Server server;
    public Viewer viewer;
    public ViewerGUI viewerGUI;
    public ScreenPlayer screenPlayer;
    public EventsListener eventsListener;
    public ClipbrdUtility clipbrdUtility;
    public ViewerOptions viewerOptions;
    public FileManager fileManager;

    public Recorder(InetAddress inetAddress) {
        this.config = RMIServer.serverConfig;
        this.init();
        this.viewerOptions = new ViewerOptions(inetAddress);
        this.screenPlayer = new ScreenPlayer(this);
        this.eventsListener = new EventsListener(this);
        this.viewerGUI = new ViewerGUI(this);
        this.viewerGUI.Start();
    }

    public Recorder(Viewer viewer, Config config) {
        this.viewer = viewer;
        this.config = config;
        this.side = false;
        this.init();
        this.viewerOptions = new ViewerOptions(InetAdrUtility.getLocalHost(), HostProperties.getLocalProperties());
        this.start();
        this.screenPlayer = new ScreenPlayer(this);
        this.eventsListener = new EventsListener(this);
        this.viewerGUI = new ViewerGUI(this);
    }

    public Recorder(Server server, Config config) {
        this.server = server;
        this.config = config;
        this.side = true;
        this.init();
        this.viewerOptions = new ViewerOptions(InetAdrUtility.getLocalHost(), HostProperties.getLocalProperties());
        this.Start();
    }

    public void init() {
        this.clipbrdUtility = new ClipbrdUtility();
        this.fileManager = new FileManager(this);
    }

    public void run() {
        block0: while (true) {
            this.Wait();
            while (true) {
                if (!this.recording || this.pause || this.hold) continue block0;
                this.viewer.sendData();
                this.viewer.receiveData();
                this.Sleep();
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Wait() {
        try {
            Recorder recorder = this;
            synchronized (recorder) {
                this.wait();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Notify() {
        try {
            Recorder recorder = this;
            synchronized (recorder) {
                this.notify();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Sleep() {
        Recorder recorder = this;
        synchronized (recorder) {
            try {
                Recorder.sleep(this.viewerOptions.getRefreshRate());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void Stop() {
        this.recording = false;
        this.pause = true;
        this.hold = true;
        this.viewOnly = false;
        this.clipbrdUtility.removeFlavorListener();
        if (this.viewerGUI.isFullScreenMode()) {
            this.viewerGUI.changeFullScreenMode();
        }
        if (this.config.reverseConnection && !this.side || !this.config.reverseConnection) {
            this.eventsListener.removeAdapters(true);
        }
        if (this.config.reverseConnection && !this.side) {
            Viewer.removeViewer(this);
        }
    }

    public void terminate() {
        this.Stop();
        if (this.viewer != null) {
            this.viewer.disconnect();
            this.viewer.interrupt();
        }
        this.interrupt();
    }

    public void Start() {
        if (this.config.reverseConnection && this.side && !this.server.isConnected() && this.server.connect() == -1) {
            return;
        }
        if (!this.config.reverseConnection && !this.viewer.isConnected() && this.viewer.connect() == -1) {
            return;
        }
        if (this.config.reverseConnection && !this.side || !this.config.reverseConnection) {
            this.eventsListener.addAdapters(true);
        }
        this.clipbrdUtility.addFlavorListener();
        this.recording = true;
        this.pause = false;
        this.hold = false;
        this.viewOnly = false;
        if (!this.config.reverseConnection) {
            this.viewer.setOptions(this.viewerOptions.getOptions());
            this.Notify();
        }
    }

    public boolean isRecording() {
        return this.recording;
    }

    public boolean isPaused() {
        return this.pause;
    }

    public void setPause(boolean bool) {
        if (this.config.reverseConnection && !this.side) {
            Viewer.setPause(this, bool);
        } else {
            this.pause = bool;
            if (this.pause) {
                this.eventsListener.removeAdapters(true);
            } else {
                if (this.recording && !this.viewOnly) {
                    this.eventsListener.addAdapters(true);
                }
                if (this.recording) {
                    this.Notify();
                }
            }
        }
    }

    public void setViewOnly(boolean bool) {
        this.viewOnly = bool;
        if (this.viewOnly) {
            this.eventsListener.removeAdapters();
        } else if (this.recording && !this.pause) {
            this.eventsListener.addAdapters();
        }
    }

    public void setHold(boolean bool) {
        this.hold = bool;
    }

    public boolean isViewOnly() {
        return this.viewOnly;
    }
}

