/*
 * Decompiled with CFR 0.152.
 */
package jrdesktop.viewer.FileMng;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import jrdesktop.Commons;
import jrdesktop.utilities.FileUtility;
import jrdesktop.viewer.Recorder;
import org.jdesktop.layout.GroupLayout;
import org.jdesktop.swingworker.SwingWorker;

public class FileTransGUI
extends JFrame {
    private Recorder recorder;
    private boolean canceled = false;
    private boolean done = false;
    private File[] files;
    private long index = 0L;
    private long count = 0L;
    private long size = 0L;
    private long startedAt = 0L;
    private long duration = 0L;
    private long speed = 0L;
    private float leftEstim = 0.0f;
    private float totalEstim = 0.0f;
    private SwingWorker sendingWorker = new SwingWorker(){

        protected Object doInBackground() throws Exception {
            ((FileTransGUI)FileTransGUI.this).recorder.fileManager.SendFiles(FileTransGUI.this, FileTransGUI.this.files);
            throw new UnsupportedOperationException("Not supported yet.");
        }

        protected void done() {
            FileTransGUI.this.Done();
        }
    };
    private SwingWorker receivingWorker = new SwingWorker(){

        protected Object doInBackground() throws Exception {
            ((FileTransGUI)FileTransGUI.this).recorder.fileManager.ReceiveFiles(FileTransGUI.this, FileTransGUI.this.files);
            throw new UnsupportedOperationException("Not supported yet.");
        }

        protected void done() {
            FileTransGUI.this.Done();
        }
    };
    private JButton jButtonClose;
    private JLabel jLabel1;
    private JLabel jLabelCurrentFile;
    private JLabel jLabelDuration;
    private JLabel jLabelFileCount;
    private JLabel jLabelSpeed;
    private JLabel jLabelTotalSize;
    private JPanel jPanel1;
    private JProgressBar jProgressBar1;

    public FileTransGUI(Recorder recorder) {
        this.recorder = recorder;
        this.initComponents();
        this.setVisible(true);
        this.startedAt = System.currentTimeMillis();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jProgressBar1 = new JProgressBar();
        this.jLabel1 = new JLabel();
        this.jLabelCurrentFile = new JLabel();
        this.jLabelFileCount = new JLabel();
        this.jLabelTotalSize = new JLabel();
        this.jLabelSpeed = new JLabel();
        this.jLabelDuration = new JLabel();
        this.jButtonClose = new JButton();
        this.setDefaultCloseOperation(0);
        this.setTitle("File Transmission");
        this.setIconImage(new ImageIcon(Commons.IDLE_ICON).getImage());
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                FileTransGUI.this.formWindowClosing(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(""));
        this.jProgressBar1.setMaximumSize(new Dimension(150, 20));
        this.jProgressBar1.setMinimumSize(new Dimension(150, 20));
        this.jProgressBar1.setPreferredSize(new Dimension(150, 20));
        this.jProgressBar1.setStringPainted(true);
        this.jLabel1.setText("Current file:");
        this.jLabelFileCount.setText("0 file(s)");
        this.jLabelTotalSize.setText("0 KB");
        this.jLabelSpeed.setText("0 KB/S");
        this.jLabelDuration.setText("0 Seconds");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().add(jPanel1Layout.createParallelGroup(1).add(this.jLabelDuration).add(this.jLabel1)).add(jPanel1Layout.createParallelGroup(1, false).add(jPanel1Layout.createSequentialGroup().addPreferredGap(0).add(this.jLabelCurrentFile, -2, 314, -2)).add(2, jPanel1Layout.createSequentialGroup().addPreferredGap(0, -1, Short.MAX_VALUE).add(this.jLabelSpeed).add(105, 105, 105))).addPreferredGap(0, 65, Short.MAX_VALUE).add(jPanel1Layout.createParallelGroup(2).add(this.jLabelFileCount).add(this.jLabelTotalSize)).addContainerGap()).add(jPanel1Layout.createSequentialGroup().add(18, 18, 18).add(this.jProgressBar1, -2, 471, -2)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().add(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createParallelGroup(2, false).add(1, this.jLabel1, -1, -1, Short.MAX_VALUE).add(1, this.jLabelCurrentFile, -1, 14, Short.MAX_VALUE)).add(this.jLabelFileCount, -1, 14, Short.MAX_VALUE)).addPreferredGap(0).add(this.jProgressBar1, -2, -1, -2).addPreferredGap(0).add(jPanel1Layout.createParallelGroup(3).add(this.jLabelDuration).add(this.jLabelSpeed).add(this.jLabelTotalSize)).addContainerGap()));
        this.jButtonClose.setIcon(new ImageIcon(this.getClass().getResource("/jrdesktop/images/no.png")));
        this.jButtonClose.setText("Cancel");
        this.jButtonClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileTransGUI.this.jButtonCloseActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(2).add(this.jButtonClose).add(this.jPanel1, -2, 521, -2)).addContainerGap(65, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(this.jPanel1, -2, 75, -2).addPreferredGap(0, 7, Short.MAX_VALUE).add(this.jButtonClose).addContainerGap()));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 608) / 2, (screenSize.height - 162) / 2, 608, 162);
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        if (this.done) {
            this.dispose();
        } else if (JOptionPane.showConfirmDialog(this, "Stop file transmission ?", "Confirm Dialog", 0, 2) == 0) {
            this.canceled = true;
            this.dispose();
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        if (evt.getID() == 201) {
            this.jButtonCloseActionPerformed(null);
        } else {
            super.processWindowEvent(evt);
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void Done() {
        this.done = true;
        this.jButtonClose.setText("Close");
        this.jButtonClose.setIcon(new ImageIcon(this.getClass().getResource("/jrdesktop/images/exit.png")));
        this.setTitle("File Transmission [Done !! ]");
    }

    public void ReceiveFiles(ArrayList arrayList) {
        this.setTitle("File Transmission [Receiving ...]");
        this.recorder.fileManager.setDownloadingFolder(arrayList.get(0).toString());
        this.files = (File[])arrayList.get(1);
        this.count = this.files.length;
        this.receivingWorker.execute();
    }

    public void SendFiles(File[] files) {
        this.setTitle("File Transmission [Sending ...]");
        this.recorder.fileManager.setUploadingFolder(files[0].getParent());
        this.files = FileUtility.getAllFiles(files);
        this.count = this.files.length;
        this.sendingWorker.execute();
    }

    public void setCurrentFile(String filename) {
        this.jLabelCurrentFile.setText(filename);
    }

    public void updateData(long size) {
        this.size = size;
        ++this.index;
        this.duration = System.currentTimeMillis() - this.startedAt;
        this.speed = size / (this.duration + 1L);
        this.leftEstim = (float)this.duration / (float)this.index;
        this.totalEstim = this.leftEstim * (float)this.count;
        this.jLabelFileCount.setText(String.valueOf(this.index) + "/" + String.valueOf(this.count) + " file(s)");
        this.jLabelTotalSize.setText(String.valueOf(size / 1000L) + " KB");
        this.jLabelDuration.setText(String.valueOf(this.duration / 1000L) + " Seconds");
        this.jLabelSpeed.setText(String.valueOf(this.speed) + " KB/S");
        this.jProgressBar1.setMaximum((int)this.totalEstim);
        this.jProgressBar1.setValue((int)(this.leftEstim * (float)this.index));
    }
}

