/*
 * Decompiled with CFR 0.152.
 */
package jrdesktop.viewer.FileMng;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import jrdesktop.Settings;
import jrdesktop.viewer.FileMng.FileTransGUI;
import jrdesktop.viewer.Recorder;

public class FileManager {
    private File[] files;
    private String downloadingFolder;
    private String uploadingFolder;
    private Recorder recorder;

    public FileManager(Recorder recorder) {
        this.recorder = recorder;
    }

    public File[] getFiles() {
        return this.files;
    }

    public void setFiles(File[] files) {
        this.files = files;
    }

    public void ReceiveFiles(FileTransGUI fileTransGui, File[] files) {
        long size = 0L;
        for (int i = 0; i < files.length; ++i) {
            if (fileTransGui.isCanceled()) {
                return;
            }
            fileTransGui.setCurrentFile(files[i].getName());
            String filename = files[i].toString();
            String viewerFilename = filename.substring(this.downloadingFolder.length());
            viewerFilename = Settings.downloadsDir + viewerFilename;
            fileTransGui.updateData(size += this.ReceiveFile(filename, viewerFilename));
        }
    }

    public void SendFiles(FileTransGUI fileTransGui, File[] files) {
        long size = 0L;
        for (int i = 0; i < files.length; ++i) {
            if (fileTransGui.isCanceled()) {
                return;
            }
            fileTransGui.setCurrentFile(files[i].getName());
            fileTransGui.updateData(size += this.SendFile(files[i]));
        }
    }

    public long ReceiveFile(String filename, String viewerFilename) {
        try {
            byte[] filedata = this.recorder.viewer.ReceiveFile(filename);
            new File(new File(viewerFilename).getParent()).mkdirs();
            File file = new File(viewerFilename);
            BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(file));
            output.write(filedata, 0, filedata.length);
            output.flush();
            output.close();
            return filedata.length;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public long SendFile(File file) {
        try {
            byte[] buffer = new byte[(int)file.length()];
            BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));
            input.read(buffer, 0, buffer.length);
            input.close();
            String filename = file.toString().substring(this.uploadingFolder.length());
            this.recorder.viewer.SendFile(buffer, filename);
            return file.length();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public void setUploadingFolder(String folder) {
        this.uploadingFolder = folder;
    }

    public void setDownloadingFolder(String folder) {
        this.downloadingFolder = folder;
    }
}

