/*
 * Decompiled with CFR 0.152.
 */
package jrdesktop.viewer;

import java.awt.dnd.DropTarget;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import jrdesktop.viewer.FileMng.FilesDropTargetListener;
import jrdesktop.viewer.Recorder;
import jrdesktop.viewer.ScreenPlayer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventsListener {
    private final ScreenPlayer player;
    private boolean isActive = false;
    private KeyAdapter keyAdapter;
    private MouseAdapter mouseAdapter;
    private MouseWheelListener mouseWheelListener;
    private MouseMotionAdapter mouseMotionAdapter;
    private FilesDropTargetListener filesDropTargetListener;
    private DropTarget dropTarget;
    private ArrayList<KeyEvent> keyEvents = new ArrayList();
    private ArrayList<MouseEvent> mouseEvents = new ArrayList();

    public EventsListener(Recorder recorder) {
        this.player = recorder.screenPlayer;
        this.keyAdapter = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                EventsListener.this.keyEvents.add(e);
            }

            public void keyReleased(KeyEvent e) {
                EventsListener.this.keyEvents.add(e);
            }
        };
        this.mouseWheelListener = new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent e) {
                EventsListener.this.mouseEvents.add(e);
            }
        };
        this.mouseMotionAdapter = new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent e) {
                EventsListener.this.mouseEvents.add(e);
            }

            public void mouseDragged(MouseEvent e) {
                if (((EventsListener)EventsListener.this).player.isSelecting) {
                    ((EventsListener)EventsListener.this).player.destx = e.getX();
                    ((EventsListener)EventsListener.this).player.desty = e.getY();
                } else {
                    EventsListener.this.mouseEvents.add(e);
                }
            }
        };
        this.mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (((EventsListener)EventsListener.this).player.isSelecting) {
                    ((EventsListener)EventsListener.this).player.destx = ((EventsListener)EventsListener.this).player.srcx = e.getX();
                    ((EventsListener)EventsListener.this).player.desty = ((EventsListener)EventsListener.this).player.srcy = e.getY();
                } else {
                    EventsListener.this.mouseEvents.add(e);
                }
            }

            public void mouseReleased(MouseEvent e) {
                EventsListener.this.player.doneSelecting();
                EventsListener.this.mouseEvents.add(e);
            }
        };
        this.filesDropTargetListener = new FilesDropTargetListener(recorder);
        this.dropTarget = new DropTarget();
        this.dropTarget.setComponent(this.player);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<MouseEvent> getMouseEvents() {
        ArrayList<MouseEvent> _mouseEvents = new ArrayList();
        ArrayList<MouseEvent> arrayList = this.mouseEvents;
        synchronized (arrayList) {
            _mouseEvents = this.mouseEvents;
            this.mouseEvents = new ArrayList();
        }
        return _mouseEvents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<KeyEvent> getKeyEvents() {
        ArrayList<KeyEvent> _keyEvents = new ArrayList();
        ArrayList<KeyEvent> arrayList = this.keyEvents;
        synchronized (arrayList) {
            _keyEvents = this.keyEvents;
            this.keyEvents = new ArrayList();
        }
        return _keyEvents;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void addAdapters() {
        this.addAdapters(false);
    }

    public void addAdapters(boolean all) {
        if (this.isActive) {
            return;
        }
        this.player.addKeyListener(this.keyAdapter);
        this.player.addMouseWheelListener(this.mouseWheelListener);
        this.player.addMouseMotionListener(this.mouseMotionAdapter);
        this.player.addMouseListener(this.mouseAdapter);
        if (all) {
            try {
                this.dropTarget.addDropTargetListener(this.filesDropTargetListener);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.isActive = true;
    }

    public void removeAdapters() {
        this.removeAdapters(false);
    }

    public void removeAdapters(boolean all) {
        if (!this.isActive) {
            return;
        }
        this.player.removeKeyListener(this.keyAdapter);
        this.player.removeMouseWheelListener(this.mouseWheelListener);
        this.player.removeMouseMotionListener(this.mouseMotionAdapter);
        this.player.removeMouseListener(this.mouseAdapter);
        if (all) {
            this.dropTarget.removeDropTargetListener(this.filesDropTargetListener);
        }
        this.isActive = false;
    }
}

