/*
 * Decompiled with CFR 0.152.
 */
package jrdesktop.viewer;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import jrdesktop.Commons;
import jrdesktop.Config;
import jrdesktop.main;
import jrdesktop.utilities.FileUtility;
import org.jdesktop.layout.GroupLayout;

public class ConnectionDialog
extends JFrame {
    private static ConnectionDialog frame;
    private static boolean visible;
    private static int lastConfigIndex;
    private static Config viewerConfig;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JCheckBox jCheckBoxReverseConnection;
    private JCheckBox jCheckBoxSSLEnabled;
    private JComboBox jComboBoxConfig;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPasswordField jPasswordField;
    private JTextField jTextFieldIPAdr;
    private JTextField jTextFieldPort;
    private JTextField jTextFieldUsername;

    public ConnectionDialog() {
        viewerConfig = new Config(false, "");
        this.initComponents();
        this.jComboBoxConfig.setSelectedIndex(lastConfigIndex);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jTextFieldUsername = new JTextField();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jPasswordField = new JPasswordField();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jTextFieldIPAdr = new JTextField();
        this.jTextFieldPort = new JTextField();
        this.jPanel3 = new JPanel();
        this.jCheckBoxSSLEnabled = new JCheckBox();
        this.jCheckBoxReverseConnection = new JCheckBox();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jComboBoxConfig = new JComboBox<String>(FileUtility.getSideConfigFiles(false));
        this.jLabel5 = new JLabel();
        this.setDefaultCloseOperation(0);
        this.setTitle("Connection details");
        this.setIconImage(new ImageIcon(Commons.IDLE_ICON).getImage());
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ConnectionDialog.this.formWindowClosing(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Authentication"));
        this.jTextFieldUsername.setText(ConnectionDialog.viewerConfig.username);
        this.jLabel3.setText("Username:");
        this.jLabel4.setText("Password:");
        this.jPasswordField.setText(ConnectionDialog.viewerConfig.password);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().addContainerGap().add(jPanel1Layout.createParallelGroup(1).add(this.jLabel3).add(this.jLabel4)).addPreferredGap(0).add(jPanel1Layout.createParallelGroup(1).add(this.jPasswordField, -1, 216, Short.MAX_VALUE).add(this.jTextFieldUsername, -1, 216, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().add(jPanel1Layout.createParallelGroup(3).add(this.jLabel3).add(this.jTextFieldUsername, -2, -1, -2)).add(6, 6, 6).add(jPanel1Layout.createParallelGroup(3).add(this.jLabel4).add(this.jPasswordField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Server location"));
        this.jLabel1.setText(" Address:");
        this.jLabel2.setText(" Port:");
        this.jTextFieldIPAdr.setText(ConnectionDialog.viewerConfig.server_address);
        this.jTextFieldPort.setText(String.valueOf(ConnectionDialog.viewerConfig.server_port));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(1).add(2, jPanel2Layout.createSequentialGroup().addContainerGap().add(jPanel2Layout.createParallelGroup(1).add(this.jLabel1).add(this.jLabel2)).addPreferredGap(0).add(jPanel2Layout.createParallelGroup(1).add(this.jTextFieldPort, -1, 227, Short.MAX_VALUE).add(this.jTextFieldIPAdr, -1, 227, Short.MAX_VALUE)).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(1).add(jPanel2Layout.createSequentialGroup().add(jPanel2Layout.createParallelGroup(3).add(this.jLabel1).add(this.jTextFieldIPAdr, -2, -1, -2)).addPreferredGap(0).add(jPanel2Layout.createParallelGroup(3).add(this.jLabel2).add(this.jTextFieldPort, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Connection mode"));
        this.jCheckBoxSSLEnabled.setSelected(ConnectionDialog.viewerConfig.ssl_enabled);
        this.jCheckBoxSSLEnabled.setText("Secured connection ");
        this.jCheckBoxReverseConnection.setSelected(ConnectionDialog.viewerConfig.reverseConnection);
        this.jCheckBoxReverseConnection.setText("Reverse connection");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(1).add(jPanel3Layout.createSequentialGroup().add(this.jCheckBoxSSLEnabled).addPreferredGap(0).add(this.jCheckBoxReverseConnection)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(1).add(jPanel3Layout.createParallelGroup(3).add(this.jCheckBoxSSLEnabled).add(this.jCheckBoxReverseConnection)));
        this.jButtonCancel.setIcon(new ImageIcon(this.getClass().getResource("/jrdesktop/images/no.png")));
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConnectionDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setIcon(new ImageIcon(this.getClass().getResource("/jrdesktop/images/ok.png")));
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConnectionDialog.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jComboBoxConfig.setEditable(true);
        this.jComboBoxConfig.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConnectionDialog.this.jComboBoxConfigActionPerformed(evt);
            }
        });
        this.jLabel5.setText("Configuration:");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(1).add(this.jPanel3, -1, 335, Short.MAX_VALUE).add(this.jPanel2, -1, -1, Short.MAX_VALUE).add(this.jPanel1, -1, -1, Short.MAX_VALUE).add(layout.createSequentialGroup().add(this.jLabel5).addPreferredGap(0).add(this.jComboBoxConfig, 0, 234, Short.MAX_VALUE)).add(2, layout.createSequentialGroup().add(this.jButtonCancel).addPreferredGap(0).add(this.jButtonOK))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(3).add(this.jLabel5).add(this.jComboBoxConfig, -2, 22, -2)).addPreferredGap(0).add(this.jPanel2, -2, -1, -2).addPreferredGap(0).add(this.jPanel1, -2, -1, -2).addPreferredGap(0).add(this.jPanel3, -2, -1, -2).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.jButtonCancel).add(this.jButtonOK)).addContainerGap(13, Short.MAX_VALUE)));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 369) / 2, (screenSize.height - 374) / 2, 369, 374);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        ConnectionDialog.close();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        String config_name = "";
        Object item = this.jComboBoxConfig.getSelectedItem();
        if (item != null && !(config_name = item.toString()).equals("<default config>") && !Pattern.matches("[^\\/:*?\"<>|]*", config_name)) {
            JOptionPane.showMessageDialog(this, "A configuration name cannot contain any of the following characters \\ / : * ? \" < > | ", "Error", 0);
            this.jComboBoxConfig.setFocusable(true);
            return;
        }
        lastConfigIndex = this.jComboBoxConfig.getSelectedIndex();
        ConnectionDialog.close();
        main.viewerConfig = new Config(false, config_name, this.jTextFieldIPAdr.getText(), Integer.parseInt(this.jTextFieldPort.getText()), this.jTextFieldUsername.getText(), String.copyValueOf(this.jPasswordField.getPassword()), this.jCheckBoxSSLEnabled.isSelected(), this.jCheckBoxReverseConnection.isSelected());
        main.startViewer();
    }

    private void formWindowClosing(WindowEvent evt) {
        ConnectionDialog.close();
    }

    private void jComboBoxConfigActionPerformed(ActionEvent evt) {
        Object item = this.jComboBoxConfig.getSelectedItem();
        if (item == null) {
            return;
        }
        String name = item.toString();
        viewerConfig.loadConfiguration(false, name);
        this.jTextFieldIPAdr.setText(ConnectionDialog.viewerConfig.server_address);
        this.jTextFieldPort.setText(Integer.toString(ConnectionDialog.viewerConfig.server_port));
        this.jTextFieldUsername.setText(ConnectionDialog.viewerConfig.username);
        this.jPasswordField.setText(ConnectionDialog.viewerConfig.password);
        this.jCheckBoxSSLEnabled.setSelected(ConnectionDialog.viewerConfig.ssl_enabled);
        this.jCheckBoxReverseConnection.setSelected(ConnectionDialog.viewerConfig.reverseConnection);
    }

    public static void main(String[] args) {
        if (visible) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                frame = new ConnectionDialog();
                frame.setVisible(true);
                visible = true;
            }
        });
    }

    public static void close() {
        if (visible) {
            visible = false;
            frame.dispose();
        }
    }

    static {
        visible = false;
        lastConfigIndex = 0;
    }
}

