/*
 * Decompiled with CFR 0.152.
 */
package jrdesktop.utilities;

import java.awt.Frame;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import jrdesktop.mainFrame;

public class LookAndFeelUtility {
    public static String getCurrentLAF() {
        return UIManager.getLookAndFeel().getName();
    }

    public static void setLAF(String laf) {
        String lookAndFeel = null;
        if (laf != null) {
            lookAndFeel = laf.equals("System") ? UIManager.getSystemLookAndFeelClassName() : (laf.equals("Windows") ? "com.sun.java.swing.plaf.windows.WindowsLookAndFeel" : (laf.equals("Windows Classic") ? "com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel" : (laf.equals("GTK+") ? "com.sun.java.swing.plaf.gtk.GTKLookAndFeel" : (laf.startsWith("Metal") ? "javax.swing.plaf.metal.MetalLookAndFeel" : (laf.equals("CDE/Motif") ? "com.sun.java.swing.plaf.motif.MotifLookAndFeel" : (laf.equals("Mac OS X") ? "apple.laf.AquaLookAndFeel" : UIManager.getCrossPlatformLookAndFeelClassName()))))));
            try {
                UIManager.setLookAndFeel(lookAndFeel);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static String[] getLAFs() {
        ArrayList<String> LookAndFeels = new ArrayList<String>();
        for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
            LookAndFeels.add(info.getName());
        }
        return LookAndFeels.toArray(new String[LookAndFeels.size()]);
    }

    public static void update() {
        for (Frame window : mainFrame.getFrames()) {
            SwingUtilities.updateComponentTreeUI(window);
        }
    }
}

