/*
 * Decompiled with CFR 0.152.
 */
package jrdesktop.server;

import java.awt.AWTException;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import jrdesktop.Commons;
import jrdesktop.server.Server;
import jrdesktop.utilities.ImageUtility;
import jrdesktop.viewer.ViewerOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class robot
extends Thread {
    private Robot rt;
    private Server server;
    public boolean running = false;
    Rectangle defaultScreenRect = new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
    private Rectangle screenRect = Commons.emptyRect;
    private Rectangle oldScreenRect = Commons.diffRect;

    public robot() {
        this.init();
    }

    public robot(Server server) {
        this.server = server;
        this.init();
        this.start();
    }

    public void init() {
        try {
            this.rt = new Robot();
        }
        catch (AWTException awte) {
            awte.printStackTrace();
        }
    }

    @Override
    public void run() {
        block0: while (true) {
            this.Wait();
            while (true) {
                if (!this.running) continue block0;
                this.server.sendData();
                this.server.receiveData();
                this.Sleep();
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Wait() {
        try {
            robot robot2 = this;
            synchronized (robot2) {
                this.wait();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Notify() {
        try {
            robot robot2 = this;
            synchronized (robot2) {
                this.notify();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void Sleep() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
    }

    public HashMap<String, byte[]> getChangedScreenBlocks(ViewerOptions viewerOptions, boolean isEmpty) {
        if (isEmpty) {
            viewerOptions.getCapture().clearScreen();
        }
        this.updateScreenRect(viewerOptions);
        if (!this.oldScreenRect.equals(this.screenRect)) {
            this.oldScreenRect = this.screenRect;
            viewerOptions.capture.updateScreenSize(this.screenRect);
            viewerOptions.setNewScreenImage(this.screenRect, viewerOptions.getColorQuality());
        }
        try {
            viewerOptions.getCapture().takeAndSaveImage(this.rt, viewerOptions.getImageQuality(), viewerOptions.getColorQuality(), 1.0, viewerOptions.getScreenRect());
            return viewerOptions.getCapture().getChangedBlocks();
        }
        catch (Exception e) {
            e.printStackTrace();
            return new HashMap<String, byte[]>();
        }
    }

    public void updateScreenRect(ViewerOptions viewerOptions) {
        this.screenRect = new Rectangle(viewerOptions.getScreenRect());
        if (this.screenRect.equals(Commons.emptyRect)) {
            this.screenRect = new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
        }
    }

    public BufferedImage captureScreen(ViewerOptions viewerOptions) {
        this.updateScreenRect(viewerOptions);
        this.oldScreenRect = this.screenRect;
        BufferedImage screen = this.rt.createScreenCapture(this.screenRect);
        BufferedImage bimage = new BufferedImage(this.screenRect.width, this.screenRect.height, viewerOptions.getColorQuality());
        Graphics2D g2d = bimage.createGraphics();
        g2d.drawImage(screen, 0, 0, this.screenRect.width, this.screenRect.height, null);
        return bimage;
    }

    public byte[] CaptureScreenByteArray(ViewerOptions viewerOptions) {
        return ImageUtility.toByteArray(this.captureScreen(viewerOptions), viewerOptions.getImageQuality());
    }

    public void setMouseEvents(ViewerOptions viewerOptions, ArrayList evts) {
        for (int i = 0; i < evts.size(); ++i) {
            this.setMouseEvent(viewerOptions, (MouseEvent)evts.get(i));
        }
    }

    public void setMouseEvent(ViewerOptions viewerOptions, MouseEvent evt) {
        int x = viewerOptions.getScreenRect().x + (int)((float)evt.getX() / viewerOptions.getScreenScale());
        int y = viewerOptions.getScreenRect().y + (int)((float)evt.getY() / viewerOptions.getScreenScale());
        this.rt.mouseMove(x, y);
        int buttonMask = 0;
        int buttons = evt.getButton();
        if (buttons == 1) {
            buttonMask = 16;
        }
        if (buttons == 2) {
            buttonMask |= 8;
        }
        if (buttons == 3) {
            buttonMask |= 4;
        }
        switch (evt.getID()) {
            case 501: {
                this.rt.mousePress(buttonMask);
                break;
            }
            case 502: {
                this.rt.mouseRelease(buttonMask);
                break;
            }
            case 507: {
                this.rt.mouseWheel(((MouseWheelEvent)evt).getUnitsToScroll());
            }
        }
    }

    public void setKeyEvents(ArrayList evts) {
        for (int i = 0; i < evts.size(); ++i) {
            this.setKeyEvent((KeyEvent)evts.get(i));
        }
    }

    public void setKeyEvent(KeyEvent evt) {
        switch (evt.getID()) {
            case 401: {
                this.rt.keyPress(evt.getKeyCode());
                break;
            }
            case 402: {
                this.rt.keyRelease(evt.getKeyCode());
            }
        }
    }
}

