/*
 * Decompiled with CFR 0.152.
 */
package jrdesktop.server;

import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import jrdesktop.Commons;
import jrdesktop.Config;
import jrdesktop.HostProperties;
import jrdesktop.Settings;
import jrdesktop.SysTray;
import jrdesktop.rmi.client.RMIClient;
import jrdesktop.rmi.server.RMIServer;
import jrdesktop.server.http.HttpServer;
import jrdesktop.server.robot;
import jrdesktop.utilities.ClipbrdUtility;
import jrdesktop.utilities.FileUtility;
import jrdesktop.utilities.screenCaptureCompressor.ScreenCapture;
import jrdesktop.viewer.Recorder;
import jrdesktop.viewer.ViewerOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Server
extends Thread {
    private static boolean running = false;
    private static robot rt;
    private static ClipbrdUtility clipbrdUtility;
    private static Hashtable<Integer, ViewerOptions> viewers;
    private int index = -1;
    private Recorder recorder;
    private static HttpServer httpServer;
    private RMIClient client;
    private boolean connected = false;

    public static void Start() {
        running = false;
        if (!RMIServer.Start()) {
            return;
        }
        Server.init();
    }

    public static void Start(Config config) {
        running = false;
        if (!RMIServer.Start(config)) {
            return;
        }
        Server.init();
    }

    public static void init() {
        running = true;
        httpServer = new HttpServer();
        rt = new robot();
        clipbrdUtility = new ClipbrdUtility();
        SysTray.updateServerStatus((byte)1);
    }

    public static void Stop() {
        if (running) {
            running = false;
            httpServer.disconnected();
            httpServer = null;
            Server.disconnectAllViewers();
            SysTray.updateServerStatus((byte)2);
        } else {
            SysTray.updateServerStatus((byte)3);
        }
        RMIServer.Stop();
    }

    public static boolean isRunning() {
        return running;
    }

    public static byte[] getScreenCapture(int index) {
        if (!viewers.containsKey(index)) {
            return new byte[0];
        }
        byte[] screenCapture = rt.CaptureScreenByteArray(viewers.get(index));
        if (viewers.containsKey(index)) {
            Server.viewers.get((Object)Integer.valueOf((int)index)).connectionInfos.incReceivedData(screenCapture.length);
        }
        return screenCapture;
    }

    public static HashMap<String, byte[]> getChangedScreenBlocks(int index, boolean isEmpty) {
        if (!viewers.containsKey(index)) {
            return new HashMap<String, byte[]>();
        }
        HashMap<String, byte[]> blocks = rt.getChangedScreenBlocks(viewers.get(index), isEmpty);
        if (viewers.containsKey(index)) {
            Server.viewers.get((Object)Integer.valueOf((int)index)).connectionInfos.incReceivedData(ScreenCapture.getChangedBlocksSize(blocks));
        }
        return blocks;
    }

    public static Rectangle getScreenRect(int index) {
        if (viewers.get(index).getScreenRect().equals(Commons.emptyRect)) {
            return new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
        }
        return viewers.get(index).getScreenRect();
    }

    public static void setKeyEvents(ArrayList events) {
        rt.setKeyEvents(events);
    }

    public static void setMouseEvents(int index, ArrayList events) {
        rt.setMouseEvents(viewers.get(index), events);
    }

    public static void setOptions(Object data, int index) {
        viewers.get(index).setOptions(data);
    }

    public static void setOption(Object data, int index, int option) {
        viewers.get(index).setOption(data, option);
    }

    public static int addViewer(InetAddress inetAddress) {
        int index = viewers.size();
        viewers.put(index, new ViewerOptions(inetAddress));
        SysTray.displayViewer(inetAddress.toString(), index, true);
        return index;
    }

    public static int removeViewer(int index) {
        String viewer = viewers.get(index).getInetAddress().toString();
        viewers.remove(index);
        SysTray.displayViewer(viewer, viewers.size(), false);
        return index;
    }

    public static void disconnectAllViewers() {
        Enumeration<Integer> viewerEnum = viewers.keys();
        while (viewerEnum.hasMoreElements()) {
            Server.removeViewer(viewerEnum.nextElement());
        }
    }

    public static byte[] ReceiveFile(String fileName, int index) {
        try {
            File file = new File(fileName);
            byte[] buffer = new byte[(int)file.length()];
            BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));
            input.read(buffer, 0, buffer.length);
            input.close();
            Server.viewers.get((Object)Integer.valueOf((int)index)).connectionInfos.incSentData(buffer.length);
            return buffer;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void SendFile(byte[] filedata, String fileName, int index) {
        try {
            fileName = Settings.downloadsDir + fileName;
            new File(new File(fileName).getParent()).mkdirs();
            File file = new File(fileName);
            BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(file));
            output.write(filedata, 0, filedata.length);
            output.flush();
            output.close();
            Server.viewers.get((Object)Integer.valueOf((int)index)).connectionInfos.incReceivedData(filedata.length);
            SysTray.updateServerStatus(SysTray.customMsg, file.getName() + "(" + FileUtility.getSizeHumanFormat(filedata.length, FileUtility.BYTES) + ")");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ArrayList getFileList() {
        File[] files = clipbrdUtility.getFiles();
        if (files.length == 0) {
            return null;
        }
        ArrayList<Object> FileSysInfos = new ArrayList<Object>();
        FileSysInfos.add(files[0].getParent());
        FileSysInfos.add(FileUtility.getAllFiles(files));
        return FileSysInfos;
    }

    public static Hashtable<Integer, InetAddress> getConnectedHosts() {
        Hashtable<Integer, InetAddress> hosts = new Hashtable<Integer, InetAddress>();
        Enumeration<Integer> viewerEnum = viewers.keys();
        while (viewerEnum.hasMoreElements()) {
            int key = viewerEnum.nextElement();
            hosts.put(key, viewers.get(key).getInetAddress());
        }
        return hosts;
    }

    public static int getViewersCount() {
        return viewers.size();
    }

    public static void setHostProperties(int index, Hashtable props) {
        viewers.get(index).setProperties(props);
    }

    public static void displayViewerProperties(int index) {
        HostProperties.display(viewers.get(index).getProperties());
    }

    public static ArrayList getConnectionInfos(int index) {
        return Server.viewers.get((Object)Integer.valueOf((int)index)).connectionInfos.getData();
    }

    public static void displayConnectionInfos(int index) {
        Server.viewers.get((Object)Integer.valueOf((int)index)).connectionInfos.display();
    }

    public static Hashtable getHostProperties() {
        return HostProperties.getLocalProperties();
    }

    public static void setClipboardContent(Object object) {
        clipbrdUtility.setContent(object);
    }

    public static Object getClipboardContent() {
        return clipbrdUtility.getContent();
    }

    public static String getStatus() {
        return RMIServer.getStatus();
    }

    public Server(Config viewerConfig) {
        this.client = new RMIClient(viewerConfig);
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void _Start() {
        this.connect();
        if (this.connected) {
            this.recorder = new Recorder(this, this.client.clientConfig);
            rt = new robot(this);
            this.getOptions();
            Server.rt.running = true;
            rt.Notify();
        } else {
            this._Stop();
        }
    }

    public void _Stop() {
        this.disconnect();
        this.interrupt();
    }

    public int connect() {
        this.connected = false;
        this.index = this.client.connect();
        if (this.index == -1) {
            return -1;
        }
        this.setHostProperties();
        this.connected = true;
        return this.index;
    }

    public void disconnect() {
        this.connected = false;
        this.client.disconnect();
    }

    public void getOption(int option) {
        try {
            this.recorder.viewerOptions.setOption(this.client.rmiServer.getOption(this.index, option), option);
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
    }

    public void getOptions() {
        try {
            this.recorder.viewerOptions.setOptions(this.client.rmiServer.getOptions(this.index));
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
    }

    public void setScreenRect() {
        try {
            this.client.rmiServer.setScreenRect(this.recorder.viewerOptions.getScreenRect(), this.index);
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
    }

    public void setScreenCapture() {
        try {
            if (this.recorder.viewerOptions.isScreenCompressionEnabled()) {
                this.client.rmiServer.setChangedScreenBlocks(rt.getChangedScreenBlocks(this.recorder.viewerOptions, true), this.index);
            } else {
                this.client.rmiServer.setScreenCapture(rt.CaptureScreenByteArray(this.recorder.viewerOptions), this.index);
            }
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
    }

    public void getKeyEvents() {
        try {
            rt.setKeyEvents(this.client.rmiServer.getKeyEvents(this.index));
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
    }

    public void getMouseEvents() {
        try {
            rt.setMouseEvents(this.recorder.viewerOptions, this.client.rmiServer.getMouseEvents(this.index));
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
    }

    public boolean isOptionsChanged() {
        try {
            return this.client.rmiServer.isOptionsChanged(this.index);
        }
        catch (RemoteException re) {
            re.printStackTrace();
            return false;
        }
    }

    public void setOptionsChanged(boolean bool) {
        try {
            this.client.rmiServer.setOptionsChanged(this.index, bool);
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
    }

    public void setHostProperties() {
        try {
            this.client.rmiServer.setHostProperties(this.index, HostProperties.getLocalProperties());
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
    }

    public void sendData() {
        if (this.isOptionsChanged()) {
            this.getOptions();
            this.setOptionsChanged(false);
        }
        this.setScreenRect();
        this.setScreenCapture();
    }

    public void receiveData() {
        this.getMouseEvents();
        this.getKeyEvents();
    }

    static {
        viewers = new Hashtable();
    }
}

