/*
 * Decompiled with CFR 0.152.
 */
package jrdesktop.server;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import jrdesktop.main;
import jrdesktop.rmi.server.RMIServer;
import jrdesktop.utilities.FileUtility;
import jrdesktop.utilities.InetAdrUtility;
import org.jdesktop.layout.GroupLayout;

public class ConfigJPanel
extends JPanel {
    private static int lastConfigIndex = 0;
    private JButton jButtonOK;
    private JButton jButtonRefresh;
    private JCheckBox jCheckBoxDefaultAdr;
    private JCheckBox jCheckBoxManualAdr;
    private JCheckBox jCheckBoxMultihomedEnabled;
    private JCheckBox jCheckBoxReverseConnection;
    private JCheckBox jCheckBoxSSLEnabled;
    private JComboBox jComboBoxConfig;
    private JComboBox jComboBoxLocalAdrs;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPasswordField jPasswordField;
    private JTextField jTextFieldHTTPPort;
    private JTextField jTextFieldPort;
    private JTextField jTextFieldUsername;

    public ConfigJPanel() {
        this.initComponents();
        this.jComboBoxConfig.setSelectedIndex(lastConfigIndex);
        if (this.jCheckBoxMultihomedEnabled.isSelected()) {
            this.jCheckBoxMultihomedEnabledActionPerformed(null);
        } else {
            this.jCheckBoxManualAdrActionPerformed(null);
        }
    }

    private void initComponents() {
        this.jButtonOK = new JButton();
        this.jPanel3 = new JPanel();
        this.jCheckBoxSSLEnabled = new JCheckBox();
        this.jCheckBoxReverseConnection = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jTextFieldUsername = new JTextField();
        this.jLabel4 = new JLabel();
        this.jPasswordField = new JPasswordField();
        this.jLabel5 = new JLabel();
        this.jComboBoxConfig = new JComboBox<String>(FileUtility.getSideConfigFiles(true));
        this.jPanel4 = new JPanel();
        this.jCheckBoxManualAdr = new JCheckBox();
        this.jCheckBoxMultihomedEnabled = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.jComboBoxLocalAdrs = new JComboBox<String>(InetAdrUtility.getLocalIPAdresses());
        this.jCheckBoxDefaultAdr = new JCheckBox();
        this.jButtonRefresh = new JButton();
        this.jPanel2 = new JPanel();
        this.jTextFieldPort = new JTextField();
        this.jLabel2 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jTextFieldHTTPPort = new JTextField();
        this.jButtonOK.setIcon(new ImageIcon(this.getClass().getResource("/jrdesktop/images/ok.png")));
        this.jButtonOK.setText("Apply");
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConfigJPanel.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Connection mode"));
        this.jCheckBoxSSLEnabled.setSelected(RMIServer.serverConfig.ssl_enabled);
        this.jCheckBoxSSLEnabled.setText("Secured connection");
        this.jCheckBoxReverseConnection.setSelected(RMIServer.serverConfig.reverseConnection);
        this.jCheckBoxReverseConnection.setText("Reverse connection");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(1).add(jPanel3Layout.createSequentialGroup().add(jPanel3Layout.createParallelGroup(1).add(this.jCheckBoxSSLEnabled).add(this.jCheckBoxReverseConnection)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(1).add(jPanel3Layout.createSequentialGroup().add(this.jCheckBoxSSLEnabled).addPreferredGap(0).add(this.jCheckBoxReverseConnection).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Authentication"));
        this.jLabel3.setText("Username:");
        this.jTextFieldUsername.setText(RMIServer.serverConfig.username);
        this.jTextFieldUsername.setMaximumSize(new Dimension(28, 20));
        this.jTextFieldUsername.setMinimumSize(new Dimension(4, 20));
        this.jTextFieldUsername.setPreferredSize(new Dimension(79, 20));
        this.jLabel4.setText("Password:");
        this.jPasswordField.setText(RMIServer.serverConfig.password);
        this.jPasswordField.setMaximumSize(new Dimension(28, 20));
        this.jPasswordField.setMinimumSize(new Dimension(4, 20));
        this.jPasswordField.setPreferredSize(new Dimension(70, 20));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().addContainerGap().add(jPanel1Layout.createParallelGroup(1).add(this.jLabel4).add(this.jLabel3)).addPreferredGap(0).add(jPanel1Layout.createParallelGroup(1).add(this.jTextFieldUsername, -1, 154, Short.MAX_VALUE).add(this.jPasswordField, -1, 154, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().add(jPanel1Layout.createParallelGroup(3).add(this.jLabel3).add(this.jTextFieldUsername, -2, -1, -2)).addPreferredGap(0).add(jPanel1Layout.createParallelGroup(3).add(this.jPasswordField, -2, -1, -2).add(this.jLabel4))));
        this.jLabel5.setText("Configuration:");
        this.jComboBoxConfig.setEditable(true);
        this.jComboBoxConfig.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConfigJPanel.this.jComboBoxConfigActionPerformed(evt);
            }
        });
        this.jPanel4.setBorder(BorderFactory.createTitledBorder("IP Address"));
        this.jCheckBoxManualAdr.setSelected(!RMIServer.serverConfig.multihomed_enabled);
        this.jCheckBoxManualAdr.setText("Manual ");
        this.jCheckBoxManualAdr.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConfigJPanel.this.jCheckBoxManualAdrActionPerformed(evt);
            }
        });
        this.jCheckBoxMultihomedEnabled.setSelected(RMIServer.serverConfig.multihomed_enabled);
        this.jCheckBoxMultihomedEnabled.setText("Automatic");
        this.jCheckBoxMultihomedEnabled.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConfigJPanel.this.jCheckBoxMultihomedEnabledActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Address:");
        this.jComboBoxLocalAdrs.setSelectedItem(RMIServer.serverConfig.server_address);
        this.jComboBoxLocalAdrs.setMaximumSize(new Dimension(28, 20));
        this.jComboBoxLocalAdrs.setMinimumSize(new Dimension(28, 20));
        this.jCheckBoxDefaultAdr.setSelected(RMIServer.serverConfig.default_address);
        this.jCheckBoxDefaultAdr.setText("Default");
        this.jCheckBoxDefaultAdr.setToolTipText("Set as the default Java Virtual Machine IP Adresse");
        this.jButtonRefresh.setIcon(new ImageIcon(this.getClass().getResource("/jrdesktop/images/reload.png")));
        this.jButtonRefresh.setMaximumSize(new Dimension(49, 20));
        this.jButtonRefresh.setMinimumSize(new Dimension(49, 20));
        this.jButtonRefresh.setPreferredSize(new Dimension(49, 20));
        this.jButtonRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConfigJPanel.this.jButtonRefreshActionPerformed(evt);
            }
        });
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(1).add(jPanel4Layout.createSequentialGroup().add(jPanel4Layout.createParallelGroup(1).add(jPanel4Layout.createSequentialGroup().add(this.jCheckBoxManualAdr).addPreferredGap(1).add(this.jCheckBoxMultihomedEnabled).addPreferredGap(1).add(this.jCheckBoxDefaultAdr)).add(jPanel4Layout.createSequentialGroup().add(this.jLabel1).addPreferredGap(0).add(this.jComboBoxLocalAdrs, -2, 128, -2).addPreferredGap(0).add(this.jButtonRefresh, -2, 39, -2))).add(10, 10, 10)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(1).add(jPanel4Layout.createSequentialGroup().add(jPanel4Layout.createParallelGroup(3).add(this.jCheckBoxManualAdr).add(this.jCheckBoxMultihomedEnabled).add(this.jCheckBoxDefaultAdr)).addPreferredGap(0).add(jPanel4Layout.createParallelGroup(2).add(jPanel4Layout.createParallelGroup(3).add(this.jLabel1).add(this.jComboBoxLocalAdrs, -1, -1, Short.MAX_VALUE)).add(this.jButtonRefresh, -1, 22, Short.MAX_VALUE)).addContainerGap()));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Ports"));
        this.jTextFieldPort.setText(String.valueOf(RMIServer.serverConfig.server_port));
        this.jTextFieldPort.setMaximumSize(new Dimension(28, 20));
        this.jTextFieldPort.setMinimumSize(new Dimension(28, 20));
        this.jTextFieldPort.setPreferredSize(new Dimension(28, 20));
        this.jLabel2.setText("Main:");
        this.jLabel6.setText("Http:");
        this.jTextFieldHTTPPort.setText(String.valueOf(RMIServer.serverConfig.http_port));
        this.jTextFieldHTTPPort.setMaximumSize(new Dimension(28, 20));
        this.jTextFieldHTTPPort.setMinimumSize(new Dimension(28, 20));
        this.jTextFieldHTTPPort.setPreferredSize(new Dimension(28, 20));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(1).add(jPanel2Layout.createSequentialGroup().addContainerGap().add(jPanel2Layout.createParallelGroup(2).add(jPanel2Layout.createSequentialGroup().add(this.jLabel6).addPreferredGap(0).add(this.jTextFieldHTTPPort, -2, 75, -2)).add(jPanel2Layout.createSequentialGroup().add(this.jLabel2).addPreferredGap(0).add(this.jTextFieldPort, -2, 75, -2))).addContainerGap(12, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(1).add(jPanel2Layout.createSequentialGroup().add(jPanel2Layout.createParallelGroup(3).add(this.jLabel2).add(this.jTextFieldPort, -2, -1, -2)).addPreferredGap(0).add(jPanel2Layout.createParallelGroup(3).add(this.jLabel6).add(this.jTextFieldHTTPPort, -2, -1, -2)).addContainerGap(12, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(1, false).add(layout.createSequentialGroup().add(this.jLabel5).addPreferredGap(0).add(this.jComboBoxConfig, 0, -1, Short.MAX_VALUE).addPreferredGap(0).add(this.jButtonOK)).add(layout.createSequentialGroup().add(layout.createParallelGroup(1, false).add(this.jPanel1, -1, -1, Short.MAX_VALUE).add(this.jPanel4, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add(layout.createParallelGroup(1, false).add(this.jPanel2, -1, -1, Short.MAX_VALUE).add(this.jPanel3, -1, -1, Short.MAX_VALUE)))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(3).add(this.jLabel5).add(this.jComboBoxConfig, -2, -1, -2).add(this.jButtonOK)).addPreferredGap(0).add(layout.createParallelGroup(1).add(this.jPanel2, -1, -1, Short.MAX_VALUE).add(this.jPanel4, -2, -1, -2)).addPreferredGap(0).add(layout.createParallelGroup(1).add(this.jPanel1, -1, 83, Short.MAX_VALUE).add(this.jPanel3, -1, -1, Short.MAX_VALUE)).addContainerGap()));
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        String config_name = "";
        Object item = this.jComboBoxConfig.getSelectedItem();
        if (item != null && !(config_name = item.toString()).equals("<default config>") && !Pattern.matches("[^\\/:*?\"<>|]*", config_name)) {
            JOptionPane.showMessageDialog(this, "A configuration name cannot contain any of the following characters \\ / : * ? \" < > | ", "Error", 0);
            this.jComboBoxConfig.setFocusable(true);
            return;
        }
        lastConfigIndex = this.jComboBoxConfig.getSelectedIndex();
        RMIServer.serverConfig.setConfiguration(true, config_name, this.jComboBoxLocalAdrs.getSelectedItem().toString(), this.jCheckBoxDefaultAdr.isSelected(), this.jCheckBoxMultihomedEnabled.isSelected(), Integer.valueOf(this.jTextFieldPort.getText()), Integer.valueOf(this.jTextFieldHTTPPort.getText()), this.jTextFieldUsername.getText(), String.copyValueOf(this.jPasswordField.getPassword()), this.jCheckBoxSSLEnabled.isSelected(), this.jCheckBoxReverseConnection.isSelected());
        main.displayTab(0);
    }

    private void jComboBoxConfigActionPerformed(ActionEvent evt) {
        Object item = this.jComboBoxConfig.getSelectedItem();
        if (item == null) {
            return;
        }
        String name = item.toString();
        RMIServer.serverConfig.loadConfiguration(true, name);
        this.jComboBoxLocalAdrs.setEnabled(!RMIServer.serverConfig.multihomed_enabled);
        this.jComboBoxLocalAdrs.setSelectedItem(RMIServer.serverConfig.server_address);
        this.jCheckBoxManualAdr.setSelected(!RMIServer.serverConfig.multihomed_enabled);
        this.jCheckBoxMultihomedEnabled.setSelected(RMIServer.serverConfig.multihomed_enabled);
        this.jCheckBoxDefaultAdr.setSelected(RMIServer.serverConfig.default_address);
        this.jTextFieldPort.setText(Integer.toString(RMIServer.serverConfig.server_port));
        this.jTextFieldHTTPPort.setText(Integer.toString(RMIServer.serverConfig.http_port));
        this.jTextFieldUsername.setText(RMIServer.serverConfig.username);
        this.jPasswordField.setText(RMIServer.serverConfig.password);
        this.jCheckBoxSSLEnabled.setSelected(RMIServer.serverConfig.ssl_enabled);
        this.jCheckBoxReverseConnection.setSelected(RMIServer.serverConfig.reverseConnection);
    }

    private void jCheckBoxManualAdrActionPerformed(ActionEvent evt) {
        this.jComboBoxLocalAdrs.setEnabled(this.jCheckBoxManualAdr.isSelected());
        this.jCheckBoxMultihomedEnabled.setSelected(!this.jCheckBoxManualAdr.isSelected());
    }

    private void jCheckBoxMultihomedEnabledActionPerformed(ActionEvent evt) {
        this.jCheckBoxManualAdr.setSelected(!this.jCheckBoxMultihomedEnabled.isSelected());
        this.jComboBoxLocalAdrs.setEnabled(!this.jCheckBoxMultihomedEnabled.isSelected());
    }

    private void jButtonRefreshActionPerformed(ActionEvent evt) {
        this.jComboBoxLocalAdrs.setModel(new DefaultComboBoxModel<String>(InetAdrUtility.getLocalIPAdresses()));
        this.jComboBoxLocalAdrs.setSelectedItem(RMIServer.serverConfig.server_address);
    }
}

