/*
 * Decompiled with CFR 0.152.
 */
package jrdesktop.server;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jrdesktop.rmi.server.RMIServer;
import jrdesktop.server.Server;
import jrdesktop.viewer.Viewer;
import org.jdesktop.layout.GroupLayout;

public class ActiveConnectionsJPanel
extends JPanel {
    DefaultListModel listModel = new DefaultListModel();
    Hashtable<Integer, Integer> viewerKeys;
    private JButton jButtonDetails;
    private JButton jButtonDisconnect;
    private JButton jButtonDisconnectAll;
    private JButton jButtonProperties;
    private JButton jButtonRefresh;
    private JList jList1;
    private JScrollPane jScrollPane1;

    public ActiveConnectionsJPanel() {
        this.initComponents();
        this.jList1.setModel(this.listModel);
        this.updateList();
    }

    private void initComponents() {
        this.jButtonDisconnectAll = new JButton();
        this.jButtonRefresh = new JButton();
        this.jButtonDisconnect = new JButton();
        this.jButtonProperties = new JButton();
        this.jButtonDetails = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jButtonDisconnectAll.setIcon(new ImageIcon(this.getClass().getResource("/jrdesktop/images/connect_no.png")));
        this.jButtonDisconnectAll.setText("Disconnect all");
        this.jButtonDisconnectAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ActiveConnectionsJPanel.this.jButtonDisconnectAllActionPerformed(evt);
            }
        });
        this.jButtonRefresh.setIcon(new ImageIcon(this.getClass().getResource("/jrdesktop/images/reload.png")));
        this.jButtonRefresh.setText("Refresh");
        this.jButtonRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ActiveConnectionsJPanel.this.jButtonRefreshActionPerformed(evt);
            }
        });
        this.jButtonDisconnect.setIcon(new ImageIcon(this.getClass().getResource("/jrdesktop/images/connect_no.png")));
        this.jButtonDisconnect.setText("Disconnect");
        this.jButtonDisconnect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ActiveConnectionsJPanel.this.jButtonDisconnectActionPerformed(evt);
            }
        });
        this.jButtonProperties.setIcon(new ImageIcon(this.getClass().getResource("/jrdesktop/images/props.png")));
        this.jButtonProperties.setText("Properties");
        this.jButtonProperties.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ActiveConnectionsJPanel.this.jButtonPropertiesActionPerformed(evt);
            }
        });
        this.jButtonDetails.setIcon(new ImageIcon(this.getClass().getResource("/jrdesktop/images/info.png")));
        this.jButtonDetails.setText("Details");
        this.jButtonDetails.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ActiveConnectionsJPanel.this.jButtonDetailsActionPerformed(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(this.jScrollPane1, -2, 218, -2).addPreferredGap(0).add(layout.createParallelGroup(1, false).add(this.jButtonDisconnectAll, -1, -1, Short.MAX_VALUE).add(this.jButtonRefresh, -1, -1, Short.MAX_VALUE).add(this.jButtonDetails, -1, -1, Short.MAX_VALUE).add(this.jButtonProperties, -1, -1, Short.MAX_VALUE).add(this.jButtonDisconnect, -1, 132, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(2, false).add(1, this.jScrollPane1).add(1, layout.createSequentialGroup().add(this.jButtonDisconnect).addPreferredGap(0).add(this.jButtonProperties).addPreferredGap(0).add(this.jButtonDetails).addPreferredGap(0).add(this.jButtonRefresh).addPreferredGap(0).add(this.jButtonDisconnectAll))).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void jButtonDisconnectAllActionPerformed(ActionEvent evt) {
        if (this.viewerKeys.size() == 0) {
            return;
        }
        if (JOptionPane.showConfirmDialog(null, "Disconnect viewers ? ", "Confirm Dialog", 2, 3) == 2) {
            return;
        }
        if (RMIServer.serverConfig.reverseConnection) {
            Viewer.disconnectAllViewers();
        } else {
            Server.disconnectAllViewers();
        }
        this.updateList();
    }

    private void jButtonRefreshActionPerformed(ActionEvent evt) {
        this.updateList();
    }

    private void jButtonDisconnectActionPerformed(ActionEvent evt) {
        int index = this.jList1.getSelectedIndex();
        if (index == -1) {
            return;
        }
        InetAddress inetAddress = (InetAddress)this.jList1.getSelectedValue();
        if (JOptionPane.showConfirmDialog(this, "Disconnect " + inetAddress.toString() + " ? ", "Confirm Dialog", 2, 3) == 2) {
            return;
        }
        if (RMIServer.serverConfig.reverseConnection) {
            Viewer.removeViewer(this.viewerKeys.get(index));
        } else {
            Server.removeViewer(this.viewerKeys.get(index));
        }
        this.updateList();
    }

    private void jButtonPropertiesActionPerformed(ActionEvent evt) {
        int index = this.jList1.getSelectedIndex();
        if (index == -1) {
            return;
        }
        if (RMIServer.serverConfig.reverseConnection) {
            Viewer.displayViewerProperties(this.viewerKeys.get(index));
        } else {
            Server.displayViewerProperties(this.viewerKeys.get(index));
        }
    }

    private void jButtonDetailsActionPerformed(ActionEvent evt) {
        int index = this.jList1.getSelectedIndex();
        if (index == -1) {
            return;
        }
        if (RMIServer.serverConfig.reverseConnection) {
            Viewer.displayConnectionInfos(this.viewerKeys.get(index));
        } else {
            Server.displayConnectionInfos(this.viewerKeys.get(index));
        }
    }

    public void updateList() {
        Hashtable<Integer, InetAddress> hosts = RMIServer.serverConfig.reverseConnection ? Viewer.getConnectedHosts() : Server.getConnectedHosts();
        Enumeration<Integer> viewersKeys = hosts.keys();
        this.viewerKeys = new Hashtable();
        int i = 0;
        this.listModel.clear();
        while (viewersKeys.hasMoreElements()) {
            int key = viewersKeys.nextElement();
            this.viewerKeys.put(i++, key);
            this.listModel.addElement(hosts.get(key));
        }
    }
}

