/*
 * Decompiled with CFR 0.152.
 */
package jrdesktop;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jrdesktop.AboutJPanel;
import jrdesktop.Commons;
import jrdesktop.HomeJPanel;
import jrdesktop.Settings;
import jrdesktop.SettingsJPanel;
import jrdesktop.SysTray;
import jrdesktop.main;
import jrdesktop.server.ActiveConnectionsJPanel;
import jrdesktop.server.ConfigJPanel;
import jrdesktop.server.Server;
import org.jdesktop.layout.GroupLayout;

public class mainFrame
extends JFrame {
    private static mainFrame frame;
    private static boolean visible;
    private static HomeJPanel hjp;
    private static ConfigJPanel cjp;
    private static ActiveConnectionsJPanel acjp;
    private static SettingsJPanel sjp;
    private static AboutJPanel ajp;
    private JTabbedPane jTabbedPane;

    public mainFrame() {
        this.initComponents();
    }

    private void initComponents() {
        this.jTabbedPane = new JTabbedPane();
        this.setDefaultCloseOperation(0);
        this.setTitle("Home - jrdesktop 0.3.1.0");
        this.setIconImage(new ImageIcon(Commons.IDLE_ICON).getImage());
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                mainFrame.this.formWindowClosing(evt);
            }
        });
        hjp = new HomeJPanel();
        cjp = new ConfigJPanel();
        acjp = new ActiveConnectionsJPanel();
        sjp = new SettingsJPanel();
        ajp = new AboutJPanel();
        this.jTabbedPane.addTab("Home", new ImageIcon(this.getClass().getResource("/jrdesktop/images/gohome.png")), hjp);
        this.jTabbedPane.addTab("Config", new ImageIcon(this.getClass().getResource("/jrdesktop/images/configure.png")), cjp);
        this.jTabbedPane.addTab("Connections", new ImageIcon(this.getClass().getResource("/jrdesktop/images/connect_established.png")), acjp);
        this.jTabbedPane.addTab("Settings", new ImageIcon(this.getClass().getResource("/jrdesktop/images/settings.png")), sjp);
        this.jTabbedPane.addTab("About", new ImageIcon(this.getClass().getResource("/jrdesktop/images/about.png")), ajp);
        this.jTabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                mainFrame.this.jTabbedPaneStateChanged(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(this.jTabbedPane, -1, 496, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(2, layout.createSequentialGroup().addContainerGap().add(this.jTabbedPane, -1, 290, Short.MAX_VALUE).addContainerGap()));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 530) / 2, (screenSize.height - 344) / 2, 530, 344);
    }

    private void formWindowClosing(WindowEvent evt) {
        if (evt.getID() == 201) {
            if (!(Server.isRunning() || SysTray.isEnabled() && SysTray.isSupported())) {
                main.quit();
            } else {
                mainFrame.close();
            }
        } else {
            super.processWindowEvent(evt);
        }
    }

    private void jTabbedPaneStateChanged(ChangeEvent evt) {
        switch (this.jTabbedPane.getSelectedIndex()) {
            case 0: {
                hjp.updateStatus();
                break;
            }
            case 2: {
                acjp.updateList();
            }
        }
        frame.setTitle(this.jTabbedPane.getTitleAt(this.jTabbedPane.getSelectedIndex()) + " - jrdesktop " + "0.3.1.0");
    }

    public static void main(String[] args) {
        if (Settings.displayMode == 1) {
            return;
        }
        if (visible) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                frame = new mainFrame();
                mainFrame.displayTab(0);
            }
        });
    }

    public static void displayTab(int index) {
        visible = true;
        frame.setVisible(true);
        mainFrame.frame.jTabbedPane.setSelectedIndex(index);
        frame.toFront();
    }

    public static void close() {
        visible = false;
        frame.dispose();
    }

    public static void updateStatus() {
        if (!visible) {
            return;
        }
        hjp.updateStatus();
    }

    public static boolean isDisplayed() {
        return visible;
    }

    static {
        visible = false;
    }
}

