/*
 * Decompiled with CFR 0.152.
 */
package jrdesktop;

import javax.swing.JOptionPane;
import jrdesktop.Commons;
import jrdesktop.Config;
import jrdesktop.DirDialog;
import jrdesktop.Settings;
import jrdesktop.SysTray;
import jrdesktop.SystemProperties;
import jrdesktop.mainApplet;
import jrdesktop.mainFrame;
import jrdesktop.server.Server;
import jrdesktop.utilities.InetAdrUtility;
import jrdesktop.utilities.PasswordUtility;
import jrdesktop.viewer.ConnectionDialog;
import jrdesktop.viewer.Viewer;

public class main {
    public static Config serverConfig;
    public static Config viewerConfig;
    public static int activeConnection;

    public static void main(String[] args) {
        Commons.init();
        if (!main.analyseCMDArgs(args)) {
            // empty if block
        }
        Settings.loadConfig();
        Settings.applyConfig(true);
    }

    public static void loadExtension(String[] args) {
        Commons.init();
        Settings.displayMode = (byte)2;
        if (!main.analyseCMDArgs(args)) {
            // empty if block
        }
        Settings.loadConfig();
        Settings.applyConfig(true);
    }

    public static boolean analyseCMDArgs(String[] args) {
        if (args == null) {
            return false;
        }
        if (args.length > 0) {
            String arg;
            String home = Settings.home;
            for (int i = 0; i < args.length; ++i) {
                arg = args[i];
                if (!arg.startsWith("--home:")) continue;
                home = arg.substring(7);
            }
            Settings.updateFilePaths(home);
            Settings.loadConfig();
            boolean hideMainWindow = Settings.guiDisabled;
            boolean noexit = Settings.exitDisabled;
            boolean noicon = Settings.systrayDisabled;
            String proxy_server = Settings.proxyServer;
            int proxy_port = Settings.proxyPort;
            String downloads = Settings.downloadsDir;
            String lookAndFeel = Settings.lookAndFeel;
            for (int i = 0; i < args.length; ++i) {
                arg = args[i];
                if (arg.startsWith("--hide")) {
                    hideMainWindow = true;
                    continue;
                }
                if (arg.startsWith("--noicon")) {
                    noicon = true;
                    continue;
                }
                if (arg.startsWith("--noexit")) {
                    noexit = true;
                    continue;
                }
                if (arg.startsWith("--pxport:")) {
                    proxy_port = Integer.valueOf(arg.substring(9));
                    continue;
                }
                if (arg.startsWith("--pxserver:")) {
                    proxy_server = arg.substring(11);
                    continue;
                }
                if (arg.startsWith("--downloads:")) {
                    downloads = arg.substring(12);
                    continue;
                }
                if (!arg.startsWith("--lookAndFeel:")) continue;
                lookAndFeel = arg.substring(14);
            }
            boolean proxy_manual = !proxy_server.equals("127.0.0.1") || proxy_port != 80;
            Settings.setConfig(hideMainWindow, noicon, noexit, proxy_manual, proxy_server, proxy_port, downloads, lookAndFeel);
            int side = -1;
            String config = "<default config>";
            arg = args[0];
            if (arg.equals("server")) {
                side = 0;
            } else if (arg.equals("viewer")) {
                side = 1;
            } else if (arg.equals("pwd-gen")) {
                PasswordUtility.passwordGenerator();
            } else if (arg.equals("--help") || arg.equals("-?")) {
                main.displayHelp();
            } else if (arg.equals("--version") || arg.equals("-v")) {
                main.displayHelp(false);
            }
            String server = Commons.defaultServerAddress;
            boolean default_ = true;
            boolean multihome = false;
            int port = 1099;
            int httpPort = 6666;
            String username = "admin";
            String password = "admin";
            boolean ssl = false;
            boolean reverse = false;
            for (int i = 1; i < args.length; ++i) {
                arg = args[i];
                if (arg.startsWith("--conf:")) {
                    config = arg.substring(7);
                    continue;
                }
                if (arg.startsWith("-a:")) {
                    server = arg.substring(3);
                    continue;
                }
                if (arg.startsWith("-p:")) {
                    port = InetAdrUtility.getPort(arg.substring(3), 1099);
                    continue;
                }
                if (arg.startsWith("-http:")) {
                    httpPort = InetAdrUtility.getPort(arg.substring(3), 6666);
                    continue;
                }
                if (arg.startsWith("-u:")) {
                    username = arg.substring(3);
                    continue;
                }
                if (arg.startsWith("-w:")) {
                    password = arg.substring(3);
                    continue;
                }
                if (arg.startsWith("-d")) {
                    default_ = true;
                    continue;
                }
                if (arg.startsWith("-s")) {
                    ssl = true;
                    continue;
                }
                if (arg.startsWith("-i")) {
                    multihome = true;
                    continue;
                }
                if (!arg.startsWith("-r")) continue;
                reverse = true;
            }
            if (side == 0) {
                serverConfig = config.equals("<default config>") ? new Config(true, config, server, default_, multihome, port, httpPort, username, password, ssl, reverse) : new Config(true, config);
                main.startServer();
            } else if (side == 1) {
                viewerConfig = config.equals("<default config>") ? new Config(false, config, server, port, username, password, ssl, reverse) : new Config(false, config);
                main.startViewer();
            }
        }
        return args.length != 0;
    }

    public static void displayHelp() {
        main.displayHelp(true);
    }

    public static void displayHelp(boolean full) {
        System.out.println("jrdesktop - Java Remote Desktop.\nA cross-platform software that provides remote view and control of a computer.\nhttp://jrdesktop.net/\n\n");
        if (full) {
            System.out.println("Usage: java -jar jrdesktop.jar <command> [options]\n\nCommands:\n   server | viewer             start server (or viewer) using default parameters (address: 127.0.0.1, port: 1099).\n   server | viewer [options]   start server (or viewer) using a specific options.\n   pwd-gen                     password generation utility.\n   --version | -v              display version information.\n   --help | -?                 display usage information.\n\nOptions:\n   -a:address              servers address.\n   -d                      set as the default JVM IP address.\n   -i                      auto detect server IP address.\n   -p:port                 servers port.\n   -http:port              servers http port.\n   -u:user                 user's name.\n   -w:pwd                  user's password.\n   -s                      secured connection using SSL.\n   -r                      reverse connection. \n   --hide                  hide main window. \n   --noicon                disable system tray icon. \n   --noexit                disable system exit. \n   --pxserver:address      proxy servers address. \n   --pxport:port           proxy servers port. \n   --home:directory        jrdesktops home directory. \n   --conf:file             load configuration file. \n   --downloads:directory   downloads location. \n   --lookAndFeel:laf       look and feel theme. \n");
        } else {
            System.out.println("0.3.1.0 " + Commons.jrdesktop_build_date);
        }
        main.exit();
    }

    public static void startServer() {
        if (main.serverConfig.reverseConnection) {
            Viewer._Start(serverConfig);
        } else {
            Server.Start(serverConfig);
        }
    }

    public static void startViewer() {
        if (main.viewerConfig.reverseConnection) {
            new Server(viewerConfig)._Start();
        } else {
            new Viewer(viewerConfig).Start();
        }
    }

    public static void updateStatus() {
        if (Settings.displayMode == 1) {
            mainApplet.updateStatus();
        } else {
            mainFrame.updateStatus();
        }
    }

    public static void displayTab(int index) {
        if (Settings.displayMode == 1) {
            mainApplet.displayTab(index);
        } else {
            mainFrame.displayTab(index);
        }
    }

    public static void exit() {
        if (Settings.exitDisabled && activeConnection > 0) {
            JOptionPane.showMessageDialog(null, "Please close all active connections first !!", "Warning", 2);
            return;
        }
        if (serverConfig != null && main.serverConfig.reverseConnection) {
            if (Viewer.isRunning()) {
                Viewer._Stop();
            }
        } else if (Server.isRunning()) {
            Server.Stop();
        }
        SystemProperties.clear();
        System.setSecurityManager(null);
        if (Settings.exitDisabled) {
            main.close();
        } else {
            System.exit(0);
        }
    }

    public static void close() {
        if (Settings.displayMode == 1) {
            mainApplet.close();
            JOptionPane.showConfirmDialog(null, "Please close the browser's window to exit this application", "Information", -1, 0);
        } else {
            mainFrame.close();
        }
        ConnectionDialog.close();
        DirDialog.close();
        SysTray.close();
    }

    public static void quit() {
        if (Settings.displayMode != 0 && !Settings.exitDisabled) {
            if (JOptionPane.showConfirmDialog(null, "jrdesktop is running as a " + (Settings.displayMode == 1 ? "web applet" : "Firefox extension") + ". If you chosse OK, you my lose all opened pages." + "\nYou may want instead to : \n   * Close jrdesktop using the window's close buttom; " + "\n   * Disable system exit as settings tab to have a normal shutdown of jrdesktop" + "\n\nAre you sure you want to continue ?", "Warning Dialog", 0) == 0) {
                main.exit();
            }
        } else if (JOptionPane.showConfirmDialog(null, "Exit application ?", "Confirm Dialog", 2) == 0) {
            main.exit();
        }
    }

    static {
        activeConnection = 0;
    }
}

