/*
 * Decompiled with CFR 0.152.
 */
package jrdesktop;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jrdesktop.DirDialog;
import jrdesktop.Settings;
import jrdesktop.main;
import jrdesktop.utilities.FileUtility;
import jrdesktop.utilities.LookAndFeelUtility;
import org.jdesktop.layout.GroupLayout;

public class SettingsJPanel
extends JPanel {
    private JButton jButtonBrowse;
    private JButton jButtonClear;
    private JButton jButtonOK;
    private JCheckBox jCheckBoxProxy;
    private JCheckBox jCheckBoxSysExit;
    private JCheckBox jCheckBoxTrayicon;
    private JCheckBox jCheckBoxWindow;
    private JComboBox jComboBoxLAF;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private static JTextField jTextFieldDownloadDir;
    private JTextField jTextFieldProxyPort;
    private JTextField jTextFieldProxyServer;

    public SettingsJPanel() {
        this.initComponents();
        this.jComboBoxLAF.setSelectedItem(Settings.lookAndFeel);
    }

    public static void setDownloadDir(String path) {
        jTextFieldDownloadDir.setText(path);
    }

    private void initComponents() {
        this.jButtonClear = new JButton();
        this.jPanel1 = new JPanel();
        this.jCheckBoxWindow = new JCheckBox();
        this.jCheckBoxTrayicon = new JCheckBox();
        this.jLabel3 = new JLabel();
        this.jComboBoxLAF = new JComboBox<String>(LookAndFeelUtility.getLAFs());
        this.jCheckBoxSysExit = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.jCheckBoxProxy = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.jTextFieldProxyServer = new JTextField();
        this.jTextFieldProxyPort = new JTextField();
        this.jLabel2 = new JLabel();
        this.jButtonOK = new JButton();
        this.jPanel3 = new JPanel();
        jTextFieldDownloadDir = new JTextField();
        this.jButtonBrowse = new JButton();
        this.jButtonClear.setIcon(new ImageIcon(this.getClass().getResource("/jrdesktop/images/history_clear.png")));
        this.jButtonClear.setText("Clear configuration files");
        this.jButtonClear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SettingsJPanel.this.jButtonClearActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Display"));
        this.jCheckBoxWindow.setSelected(Settings.guiDisabled);
        this.jCheckBoxWindow.setText("Hide Main windows.");
        this.jCheckBoxTrayicon.setSelected(Settings.systrayDisabled);
        this.jCheckBoxTrayicon.setText("Hide System tray icon.");
        this.jLabel3.setText("Theme");
        this.jComboBoxLAF.setSelectedItem(Settings.lookAndFeel);
        this.jCheckBoxSysExit.setSelected(Settings.exitDisabled);
        this.jCheckBoxSysExit.setText("Disable system exit.");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().addContainerGap().add(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().add(jPanel1Layout.createParallelGroup(1).add(this.jCheckBoxTrayicon).add(this.jCheckBoxWindow).add(jPanel1Layout.createSequentialGroup().add(this.jLabel3).addPreferredGap(0).add(this.jComboBoxLAF, 0, 90, Short.MAX_VALUE))).addContainerGap(21, Short.MAX_VALUE)).add(jPanel1Layout.createSequentialGroup().add(this.jCheckBoxSysExit).addContainerGap(34, Short.MAX_VALUE)))));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().add(this.jCheckBoxWindow).addPreferredGap(0).add(this.jCheckBoxTrayicon).addPreferredGap(0).add(this.jCheckBoxSysExit).addPreferredGap(0).add(jPanel1Layout.createParallelGroup(3).add(this.jComboBoxLAF, -2, -1, -2).add(this.jLabel3)).addContainerGap(16, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Proxy"));
        this.jCheckBoxProxy.setText("Manual configuration");
        this.jCheckBoxProxy.setSelected(Settings.proxyManual);
        this.jCheckBoxProxy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SettingsJPanel.this.jCheckBoxProxyActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Server");
        this.jTextFieldProxyServer.setText(Settings.proxyServer);
        this.jTextFieldProxyServer.setEnabled(Settings.proxyManual);
        this.jTextFieldProxyPort.setText(String.valueOf(Settings.proxyPort));
        this.jTextFieldProxyPort.setEnabled(Settings.proxyManual);
        this.jLabel2.setText("Port");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(1).add(jPanel2Layout.createSequentialGroup().add(jPanel2Layout.createParallelGroup(1).add(this.jCheckBoxProxy).add(jPanel2Layout.createSequentialGroup().add(4, 4, 4).add(jPanel2Layout.createParallelGroup(1).add(this.jLabel1).add(this.jLabel2)).addPreferredGap(0).add(jPanel2Layout.createParallelGroup(2).add(this.jTextFieldProxyServer, -1, 98, Short.MAX_VALUE).add(this.jTextFieldProxyPort, -2, 77, -2)))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(1).add(jPanel2Layout.createSequentialGroup().add(this.jCheckBoxProxy).addPreferredGap(0).add(jPanel2Layout.createParallelGroup(3).add(this.jLabel1).add(this.jTextFieldProxyServer, -2, -1, -2)).addPreferredGap(1).add(jPanel2Layout.createParallelGroup(3).add(this.jLabel2).add(this.jTextFieldProxyPort, -2, -1, -2)).addContainerGap(30, Short.MAX_VALUE)));
        this.jButtonOK.setIcon(new ImageIcon(this.getClass().getResource("/jrdesktop/images/ok.png")));
        this.jButtonOK.setText("Apply");
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SettingsJPanel.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Downloads location"));
        jTextFieldDownloadDir.setText(Settings.downloadsDir);
        jTextFieldDownloadDir.setMaximumSize(new Dimension(69, 20));
        jTextFieldDownloadDir.setMinimumSize(new Dimension(69, 20));
        jTextFieldDownloadDir.setPreferredSize(new Dimension(69, 20));
        this.jButtonBrowse.setText("...");
        this.jButtonBrowse.setMaximumSize(new Dimension(21, 28));
        this.jButtonBrowse.setMinimumSize(new Dimension(21, 28));
        this.jButtonBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SettingsJPanel.this.jButtonBrowseActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(1).add(jPanel3Layout.createSequentialGroup().addContainerGap().add(jTextFieldDownloadDir, -2, 272, -2).addPreferredGap(0).add(this.jButtonBrowse, -1, 43, Short.MAX_VALUE).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(1).add(jPanel3Layout.createSequentialGroup().add(jPanel3Layout.createParallelGroup(3).add(jTextFieldDownloadDir, -2, -1, -2).add(this.jButtonBrowse, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(1, false).add(layout.createSequentialGroup().add(this.jButtonClear).addPreferredGap(0, -1, Short.MAX_VALUE).add(this.jButtonOK)).add(this.jPanel3, -1, -1, Short.MAX_VALUE).add(layout.createSequentialGroup().add(this.jPanel1, -2, -1, -2).addPreferredGap(0).add(this.jPanel2, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(1).add(this.jPanel2, -1, -1, Short.MAX_VALUE).add(this.jPanel1, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add(this.jPanel3, -2, 50, -2).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.jButtonClear).add(this.jButtonOK)).addContainerGap()));
    }

    private void jButtonClearActionPerformed(ActionEvent evt) {
        String[] files = FileUtility.getConfigFiles();
        if (files.length == 0) {
            return;
        }
        if (JOptionPane.showConfirmDialog(this, "Delete configuration files ?", "Confirm Dialog", 2, 3) == 2) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            new File(Settings.home + files[i]).delete();
        }
    }

    private void jCheckBoxProxyActionPerformed(ActionEvent evt) {
        this.jTextFieldProxyServer.setEnabled(this.jCheckBoxProxy.isSelected());
        this.jTextFieldProxyPort.setEnabled(this.jCheckBoxProxy.isSelected());
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        Settings.setConfig(this.jCheckBoxWindow.isSelected(), this.jCheckBoxTrayicon.isSelected(), this.jCheckBoxSysExit.isSelected(), this.jCheckBoxProxy.isSelected(), this.jTextFieldProxyServer.getText(), Integer.valueOf(this.jTextFieldProxyPort.getText()), jTextFieldDownloadDir.getText(), this.jComboBoxLAF.getSelectedItem().toString());
        Settings.applyConfig(false);
        main.displayTab(0);
    }

    private void jButtonBrowseActionPerformed(ActionEvent evt) {
        DirDialog.main(null);
    }
}

