/*
 * Decompiled with CFR 0.152.
 */
package jrdesktop;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Arrays;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import jrdesktop.SettingsJPanel;
import org.jdesktop.layout.GroupLayout;

public class DirDialog
extends JDialog {
    private static boolean visible;
    private static DirDialog dialog;
    private DefaultMutableTreeNode parentNode = null;
    private String selectedFolder;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JTextField jTextFieldFolder;
    private JTree jTree;

    public DirDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.init();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTree = new JTree();
        this.jLabel2 = new JLabel();
        this.jTextFieldFolder = new JTextField();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Browse For Folder");
        this.setResizable(false);
        this.jLabel1.setText("Select a folder where you want to store downloaded files:");
        this.jTree.setAutoscrolls(true);
        this.jTree.addTreeWillExpandListener(new TreeWillExpandListener(){

            public void treeWillExpand(TreeExpansionEvent evt) throws ExpandVetoException {
                DirDialog.this.jTreeTreeWillExpand(evt);
            }

            public void treeWillCollapse(TreeExpansionEvent evt) throws ExpandVetoException {
            }
        });
        this.jTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent evt) {
                DirDialog.this.jTreeValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTree);
        this.jLabel2.setText("Folder:");
        this.jButtonCancel.setIcon(new ImageIcon(this.getClass().getResource("/jrdesktop/images/no.png")));
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DirDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setIcon(new ImageIcon(this.getClass().getResource("/jrdesktop/images/ok.png")));
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DirDialog.this.jButtonOKActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(1).add(this.jLabel1, -1, 401, Short.MAX_VALUE).add(this.jScrollPane1, -1, 401, Short.MAX_VALUE).add(2, layout.createSequentialGroup().add(this.jButtonCancel).addPreferredGap(0).add(this.jButtonOK)).add(2, layout.createSequentialGroup().add(this.jLabel2).addPreferredGap(0).add(this.jTextFieldFolder, -1, 356, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(this.jLabel1).addPreferredGap(0).add(this.jScrollPane1, -2, 238, -2).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.jLabel2).add(this.jTextFieldFolder, -2, -1, -2)).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.jButtonOK).add(this.jButtonCancel)).addContainerGap(22, Short.MAX_VALUE)));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 435) / 2, (screenSize.height - 382) / 2, 435, 382);
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (!new File(this.jTextFieldFolder.getText()).isDirectory()) {
            JOptionPane.showMessageDialog(this, "Path does not exists or not a directory !!");
            return;
        }
        if (!new File(this.jTextFieldFolder.getText()).canWrite()) {
            JOptionPane.showMessageDialog(this, "Can't write to the specific location !!");
            return;
        }
        SettingsJPanel.setDownloadDir(this.jTextFieldFolder.getText());
        this.dispose();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jTreeValueChanged(TreeSelectionEvent evt) {
        this.selectedFolder = this.getPath(evt.getPath().getPath());
        this.jTextFieldFolder.setText(this.selectedFolder);
    }

    private void jTreeTreeWillExpand(TreeExpansionEvent evt) throws ExpandVetoException {
        this.parentNode = (DefaultMutableTreeNode)evt.getPath().getLastPathComponent();
        this.selectedFolder = this.getPath(evt.getPath().getPath());
        this.expandNode();
    }

    public void init() {
        DefaultMutableTreeNode nodeRoots = new DefaultMutableTreeNode("My Computer");
        DefaultTreeModel modelRoots = new DefaultTreeModel(nodeRoots, true);
        File[] drives = File.listRoots();
        DefaultMutableTreeNode[] nodeDrives = new DefaultMutableTreeNode[drives.length];
        for (int i = 0; i < drives.length; ++i) {
            nodeDrives[i] = new DefaultMutableTreeNode(drives[i]);
            nodeRoots.add(nodeDrives[i]);
        }
        this.jTree.setModel(modelRoots);
    }

    private void expandNode() {
        Object[] childFiles = new File(this.selectedFolder).listFiles();
        if (childFiles == null) {
            return;
        }
        Arrays.sort(childFiles);
        for (int i = 0; i < childFiles.length; ++i) {
            if (!((File)childFiles[i]).isDirectory()) continue;
            this.parentNode.add(new DefaultMutableTreeNode(((File)childFiles[i]).getName()));
        }
    }

    public String getPath(Object[] path) {
        String fullPath = "";
        for (int i = 1; i < path.length; ++i) {
            if ((fullPath = fullPath + path[i].toString()).endsWith(File.separator)) continue;
            fullPath = fullPath + File.separator;
        }
        return fullPath;
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                dialog = new DirDialog((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent e) {
                        DirDialog.close();
                    }
                });
                dialog.setVisible(true);
                visible = true;
            }
        });
    }

    public static void close() {
        if (visible) {
            dialog.dispose();
            visible = false;
        }
    }
}

