/*
 * Decompiled with CFR 0.152.
 */
package jrdesktop.viewer;

import java.awt.Rectangle;
import java.io.File;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import jrdesktop.Config;
import jrdesktop.ConnectionInfos;
import jrdesktop.HostProperties;
import jrdesktop.SysTray;
import jrdesktop.rmi.client.RMIClient;
import jrdesktop.rmi.server.RMIServer;
import jrdesktop.server.robot;
import jrdesktop.utilities.ClipbrdUtility;
import jrdesktop.utilities.screenCaptureCompressor.ScreenCapture;
import jrdesktop.viewer.FileMng.FileTransGUI;
import jrdesktop.viewer.Recorder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Viewer
extends Thread {
    private int index = -1;
    private static robot rt;
    private Recorder recorder;
    private RMIClient client;
    private boolean connected = false;
    private static Hashtable<Integer, Recorder> viewers;
    private static ClipbrdUtility clipbrdUtility;
    private static boolean running;

    public Viewer(Config config) {
        this.client = new RMIClient(config);
    }

    public Viewer(Recorder recorder) {
        this.recorder = recorder;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void Start() {
        this.connect();
        if (this.connected) {
            this.recorder = new Recorder(this, this.client.clientConfig);
            this.recorder.viewerGUI.Start();
        } else {
            this.Stop();
        }
    }

    public void Stop() {
        this.disconnect();
        this.interrupt();
    }

    public int connect() {
        this.connected = false;
        this.index = this.client.connect();
        if (this.index == -1) {
            return -1;
        }
        this.setHostProperties();
        this.connected = true;
        return this.index;
    }

    public void disconnect() {
        this.connected = false;
        this.client.disconnect();
    }

    public void setOptions(Object data) {
        try {
            this.client.rmiServer.setOptions(data, this.index);
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
    }

    public void setOption(int option) {
        try {
            this.client.rmiServer.setOption(this.recorder.viewerOptions.getOption(option), this.index, option);
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
    }

    public void setKeyEvents() {
        try {
            this.client.rmiServer.setKeyEvents(this.recorder.eventsListener.getKeyEvents());
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
    }

    public void setMouseEvents() {
        try {
            this.client.rmiServer.setMouseEvents(this.index, this.recorder.eventsListener.getMouseEvents());
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
    }

    public void getClipboardContent() {
        if (!this.recorder.viewerOptions.getClipboardTransfer()) {
            return;
        }
        try {
            Object clipContent = this.client.rmiServer.getClipboardContent();
            this.recorder.clipbrdUtility.setContent(clipContent);
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
    }

    public void setClipboardContect() {
        if (!this.recorder.viewerOptions.getClipboardTransfer()) {
            return;
        }
        Object clipContent = this.recorder.clipbrdUtility.getContent();
        if (clipContent == null) {
            return;
        }
        try {
            this.client.rmiServer.setClipboardContent(clipContent);
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
    }

    public void getScreenCapture() {
        try {
            if (this.recorder.viewerOptions.isScreenCompressionEnabled()) {
                this.recorder.screenPlayer.UpdateScreen(this.client.rmiServer.getChangedScreenBlocks(this.index, this.recorder.viewerOptions.getCapture().isEmpty()));
            } else {
                this.recorder.screenPlayer.UpdateScreen(this.client.rmiServer.getScreenCapture(this.index));
            }
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
    }

    public void getScreenRect() {
        if (!this.connected) {
            return;
        }
        try {
            this.recorder.viewerOptions.setScreenRect(this.client.rmiServer.getScreenRect(this.index));
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
    }

    public ArrayList getFileList() {
        try {
            return this.client.rmiServer.getFileList();
        }
        catch (RemoteException re) {
            re.printStackTrace();
            return null;
        }
    }

    public void getConnectionInfos() {
        try {
            ConnectionInfos.display(this.client.rmiServer.getConnectionInfos(this.index));
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
    }

    public void getHostProperties() {
        try {
            HostProperties.display(this.client.rmiServer.getHostProperties());
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
    }

    public void setHostProperties() {
        try {
            this.client.rmiServer.setHostProperties(this.index, HostProperties.getLocalProperties());
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
    }

    public void sendData() {
        if (!this.recorder.viewerGUI.isActive()) {
            return;
        }
        this.setMouseEvents();
        this.setKeyEvents();
        this.setClipboardContect();
    }

    public void receiveData() {
        this.getScreenRect();
        this.getScreenCapture();
        if (!this.recorder.viewerGUI.isActive()) {
            return;
        }
        this.getClipboardContent();
    }

    public void SendFiles() {
        File[] files = this.recorder.fileManager.getFiles();
        if (files.length == 0) {
            return;
        }
        new FileTransGUI(this.recorder).SendFiles(files);
    }

    public void ReceiveFiles() {
        ArrayList fileList = null;
        try {
            fileList = this.client.rmiServer.getFileList();
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
        if (fileList == null) {
            return;
        }
        new FileTransGUI(this.recorder).ReceiveFiles(fileList);
    }

    public byte[] ReceiveFile(String filename) {
        try {
            return this.client.rmiServer.ReceiveFile(filename, this.index);
        }
        catch (RemoteException re) {
            re.printStackTrace();
            return null;
        }
    }

    public void SendFile(byte[] buffer, String filename) {
        try {
            this.client.rmiServer.SendFile(buffer, filename, this.index);
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
    }

    public static synchronized int addViewer(InetAddress inetAddress) {
        int index = viewers.size();
        viewers.put(index, new Recorder(inetAddress));
        SysTray.displayViewer(inetAddress.toString(), index, true);
        return index;
    }

    public static synchronized int removeViewer(int index) {
        String viewer = Viewer.viewers.get((Object)Integer.valueOf((int)index)).viewerOptions.getInetAddress().toString();
        viewers.remove(index);
        SysTray.displayViewer(viewer, viewers.size(), false);
        return index;
    }

    public static int getViewerIndex(Recorder _recorder) {
        for (int i = 0; i < viewers.size(); ++i) {
            if (!viewers.get(i).equals(_recorder)) continue;
            return i;
        }
        return -1;
    }

    public static synchronized int removeViewer(Recorder _recorder) {
        int index = Viewer.getViewerIndex(_recorder);
        if (index == -1) {
            return index;
        }
        String viewer = Viewer.viewers.get((Object)Integer.valueOf((int)index)).viewerOptions.getInetAddress().toString();
        viewers.remove(index);
        SysTray.displayViewer(viewer, viewers.size(), false);
        return index;
    }

    public static void setPause(Recorder _recorder, boolean bool) {
        int index = Viewer.getViewerIndex(_recorder);
        viewers.get(index).setPause(bool);
    }

    public static boolean isViewerPaused(Recorder _recorder) {
        int index = Viewer.getViewerIndex(_recorder);
        return viewers.get(index).isPaused();
    }

    public static void setKeyEvents(ArrayList events) {
        rt.setKeyEvents(events);
    }

    public static void setMouseEvents(int index, ArrayList events) {
        rt.setMouseEvents(Viewer.viewers.get((Object)Integer.valueOf((int)index)).viewerOptions, events);
    }

    public static String getStatus() {
        return RMIServer.getStatus();
    }

    public static void init() {
        running = true;
        rt = new robot();
        clipbrdUtility = new ClipbrdUtility();
        SysTray.updateServerStatus((byte)1);
    }

    public static void _Start() {
        running = false;
        if (!RMIServer.Start()) {
            return;
        }
        Viewer.init();
    }

    public static void _Start(Config serverConfig) {
        running = false;
        if (!RMIServer.Start(serverConfig)) {
            return;
        }
        Viewer.init();
    }

    public static void _Stop() {
        if (running) {
            running = false;
            Viewer.disconnectAllViewers();
            SysTray.updateServerStatus((byte)2);
        } else {
            SysTray.updateServerStatus((byte)3);
        }
        RMIServer.Stop();
    }

    public static boolean isRunning() {
        return running;
    }

    public static void disconnectAllViewers() {
        Enumeration<Integer> viewerEnum = viewers.keys();
        while (viewerEnum.hasMoreElements()) {
            Viewer.removeViewer(viewerEnum.nextElement());
        }
    }

    public static void setScreenCapture(byte[] data, int index) {
        if (!viewers.containsKey(index)) {
            return;
        }
        Viewer.viewers.get((Object)Integer.valueOf((int)index)).screenPlayer.UpdateScreen(data);
        Viewer.viewers.get((Object)Integer.valueOf((int)index)).viewerOptions.connectionInfos.incReceivedData(data.length);
    }

    public static void setChangedScreenBlocks(HashMap<String, byte[]> changedBlocks, int index) {
        if (!viewers.containsKey(index)) {
            return;
        }
        Viewer.viewers.get((Object)Integer.valueOf((int)index)).screenPlayer.UpdateScreen(changedBlocks);
        if (viewers.containsKey(index)) {
            Viewer.viewers.get((Object)Integer.valueOf((int)index)).viewerOptions.connectionInfos.incReceivedData(ScreenCapture.getChangedBlocksSize(changedBlocks));
        }
    }

    public static void setScreenRect(Rectangle rect, int index) {
        if (!viewers.containsKey(index)) {
            return;
        }
        Viewer.viewers.get((Object)Integer.valueOf((int)index)).viewerOptions.setScreenRect(rect);
    }

    public static ArrayList getMouseEvents(int index) {
        if (!viewers.containsKey(index)) {
            return new ArrayList();
        }
        return Viewer.viewers.get((Object)Integer.valueOf((int)index)).eventsListener.getMouseEvents();
    }

    public static ArrayList getKeyEvents(int index) {
        if (!viewers.containsKey(index)) {
            return new ArrayList();
        }
        return Viewer.viewers.get((Object)Integer.valueOf((int)index)).eventsListener.getKeyEvents();
    }

    public static void setClipboardContent(Object object, int index) {
        if (!viewers.containsKey(index)) {
            return;
        }
        Viewer.viewers.get((Object)Integer.valueOf((int)index)).clipbrdUtility.setContent(object);
    }

    public static Object getClipboardContent(int index) {
        if (!viewers.containsKey(index)) {
            return null;
        }
        return Viewer.viewers.get((Object)Integer.valueOf((int)index)).clipbrdUtility.getContent();
    }

    public static void setOptionsChanged(int index, boolean bool) {
        if (!viewers.containsKey(index)) {
            return;
        }
        Viewer.viewers.get((Object)Integer.valueOf((int)index)).viewerOptions.setChanged(bool);
    }

    public static boolean isOptionsChanged(int index) {
        if (!viewers.containsKey(index)) {
            return false;
        }
        return Viewer.viewers.get((Object)Integer.valueOf((int)index)).viewerOptions.isChanged();
    }

    public static Object getOptions(int index) {
        if (!viewers.containsKey(index)) {
            return null;
        }
        return Viewer.viewers.get((Object)Integer.valueOf((int)index)).viewerOptions.getOptions();
    }

    public static Object getOption(int index, int option) {
        if (!viewers.containsKey(index)) {
            return null;
        }
        return Viewer.viewers.get((Object)Integer.valueOf((int)index)).viewerOptions.getOption(option);
    }

    public static ArrayList getConnectionInfos(int index) {
        if (!viewers.containsKey(index)) {
            return null;
        }
        return Viewer.viewers.get((Object)Integer.valueOf((int)index)).viewerOptions.connectionInfos.getData();
    }

    public static void displayConnectionInfos(int index) {
        if (!viewers.containsKey(index)) {
            return;
        }
        Viewer.viewers.get((Object)Integer.valueOf((int)index)).viewerOptions.connectionInfos.display();
    }

    public static void setHostProperties(int index, Hashtable props) {
        if (!viewers.containsKey(index)) {
            return;
        }
        Viewer.viewers.get((Object)Integer.valueOf((int)index)).viewerOptions.setProperties(props);
    }

    public static void displayViewerProperties(int index) {
        HostProperties.display(Viewer.viewers.get((Object)Integer.valueOf((int)index)).viewerOptions.getProperties());
    }

    public static Hashtable<Integer, InetAddress> getConnectedHosts() {
        Hashtable<Integer, InetAddress> hosts = new Hashtable<Integer, InetAddress>();
        Enumeration<Integer> viewerEnum = viewers.keys();
        while (viewerEnum.hasMoreElements()) {
            int key = viewerEnum.nextElement();
            hosts.put(key, Viewer.viewers.get((Object)Integer.valueOf((int)key)).viewerOptions.getInetAddress());
        }
        return hosts;
    }

    static {
        viewers = new Hashtable();
        running = false;
    }
}

