/*
 * Decompiled with CFR 0.152.
 */
package jrdesktop.viewer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import jrdesktop.Commons;
import jrdesktop.utilities.ImageUtility;
import jrdesktop.viewer.Recorder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScreenPlayer
extends JLabel {
    private Recorder recorder;
    private float screenScale = 1.0f;
    private float oldscreenScale = 1.0f;
    boolean PartialScreenMode = false;
    private BufferedImage screenImage = null;
    private Rectangle selectionRect = Commons.emptyRect;
    private Rectangle oldselectionRect = Commons.diffRect;
    private Rectangle screenRect = Commons.emptyRect;
    private Rectangle oldScreenRect = Commons.diffRect;
    public boolean isSelecting = false;
    public int srcx;
    public int srcy;
    public int destx;
    public int desty;
    private BasicStroke bs;
    private GradientPaint gp;

    public ScreenPlayer(Recorder recorder) {
        this.recorder = recorder;
        this.setFocusable(true);
        this.InitialSelectionRect();
    }

    public void updateScreenRect() {
        this.screenScale = this.recorder.viewerOptions.getScreenScale();
        if (!this.PartialScreenMode) {
            this.screenRect = this.recorder.viewerOptions.getScreenRect();
            if (!this.screenRect.equals(this.oldScreenRect)) {
                this.oldScreenRect = this.screenRect;
                this.setSize(this.screenRect.getSize());
                this.setPreferredSize(this.screenRect.getSize());
                if (!this.recorder.viewerOptions.capture.getScreenRect().equals(this.screenRect)) {
                    this.recorder.viewerOptions.capture.updateScreenSize(this.screenRect);
                    this.recorder.viewerOptions.setNewScreenImage(this.screenRect, this.recorder.viewerOptions.getColorQuality());
                }
            }
            if (this.oldscreenScale != this.screenScale) {
                Dimension dimension = new Dimension((int)((double)this.screenScale * this.screenRect.getWidth()), (int)((double)this.screenScale * this.screenRect.getHeight()));
                this.setSize(dimension);
                this.setPreferredSize(dimension);
                this.oldscreenScale = this.screenScale;
            }
        } else {
            if (!this.isSelecting && !this.selectionRect.equals(this.oldselectionRect)) {
                this.oldselectionRect = this.selectionRect;
                this.setSize(this.selectionRect.getSize());
                this.setPreferredSize(this.selectionRect.getSize());
                if (!this.recorder.viewerOptions.capture.getScreenRect().equals(this.selectionRect)) {
                    this.recorder.viewerOptions.capture.updateScreenSize(this.selectionRect);
                    this.recorder.viewerOptions.setNewScreenImage(this.selectionRect, this.recorder.viewerOptions.getColorQuality());
                }
            }
            if (this.screenScale != this.screenScale) {
                Dimension dimension = new Dimension((int)((double)this.screenScale * this.selectionRect.getWidth()), (int)((double)this.screenScale * this.selectionRect.getHeight()));
                this.setSize(dimension);
                this.setPreferredSize(dimension);
                this.oldscreenScale = this.screenScale;
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        g.drawImage(this.screenImage, 0, 0, (int)((float)this.screenRect.width * this.screenScale), (int)((float)this.screenRect.height * this.screenScale), this);
        this.DrawSelectingRect(g);
    }

    public void UpdateScreen(byte[] data) {
        this.updateScreenRect();
        this.screenImage = ImageUtility.toBufferedImage(data);
        this.recorder.viewerOptions.setScreenImage(this.screenImage);
        this.repaint();
    }

    public void UpdateScreen(HashMap<String, byte[]> changedBlocks) {
        this.updateScreenRect();
        this.screenImage = this.recorder.viewerOptions.getScreenImage();
        this.screenImage = this.recorder.viewerOptions.getCapture().setChangedBlocks(this.screenImage, changedBlocks);
        this.recorder.viewerOptions.setScreenImage(this.screenImage);
        this.repaint();
    }

    public void InitialSelectionRect() {
        this.bs = new BasicStroke(5.0f, 1, 1, 0.0f, new float[]{12.0f, 12.0f}, 0.0f);
        this.gp = new GradientPaint(0.0f, 0.0f, Color.red, 1.0f, 1.0f, Color.white, true);
    }

    public void DrawSelectingRect(Graphics g) {
        if (this.isSelecting && (this.srcx != this.destx || this.srcy != this.desty)) {
            int x1 = this.srcx < this.destx ? this.srcx : this.destx;
            int y1 = this.srcy < this.desty ? this.srcy : this.desty;
            int x2 = this.srcx > this.destx ? this.srcx : this.destx;
            int y2 = this.srcy > this.desty ? this.srcy : this.desty;
            this.selectionRect.x = x1;
            this.selectionRect.y = y1;
            this.selectionRect.width = x2 - x1 + 1;
            this.selectionRect.height = y2 - y1 + 1;
            Graphics2D g2d = (Graphics2D)g;
            g2d.setStroke(this.bs);
            g2d.setPaint(this.gp);
            g2d.draw(this.selectionRect);
            this.PartialScreenMode = true;
        }
    }

    public boolean isPartialScreenMode() {
        return this.PartialScreenMode;
    }

    public Rectangle getSelectionRect() {
        return this.selectionRect;
    }

    public void startSelectingMode() {
        this.isSelecting = true;
        Cursor cursor = new Cursor(1);
        this.setCursor(cursor);
    }

    public void stopSelectingMode() {
        this.PartialScreenMode = false;
        this.selectionRect = Commons.emptyRect;
        this.oldselectionRect = Commons.diffRect;
        this.recorder.viewerOptions.setScreenRect(new Rectangle(0, 0, 0, 0));
        if (this.recorder.config.reverseConnection) {
            this.recorder.viewerOptions.setChanged(true);
        } else {
            this.recorder.viewer.setOption(0);
        }
    }

    public void doneSelecting() {
        if (this.isSelecting) {
            this.isSelecting = false;
            this.oldselectionRect = Commons.emptyRect;
            if (this.PartialScreenMode) {
                float screenScale = 1.0f / this.recorder.viewerOptions.getScreenScale();
                Rectangle rect = new Rectangle(this.selectionRect);
                rect.x = (int)((float)rect.x * screenScale);
                rect.y = (int)((float)rect.y * screenScale);
                rect.height = (int)((float)rect.height * screenScale);
                rect.width = (int)((float)rect.width * screenScale);
                this.recorder.viewerOptions.setScreenRect(rect);
                if (this.recorder.config.reverseConnection) {
                    this.recorder.viewerOptions.setChanged(true);
                } else {
                    this.recorder.viewer.setOption(0);
                }
                this.recorder.viewerGUI.jBtnPartialComplete.setIcon(new ImageIcon(Commons.DEFAULT_SCREEN_ICON));
            }
            this.srcx = this.destx;
            this.srcy = this.desty;
            Cursor cursor = new Cursor(0);
            this.setCursor(cursor);
        }
    }
}

