/*
 * Decompiled with CFR 0.152.
 */
package jrdesktop.utilities.screenCaptureCompressor;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.ImageIcon;
import jrdesktop.Commons;
import jrdesktop.utilities.ImageUtility;
import jrdesktop.utilities.screenCaptureCompressor.Screen;
import jrdesktop.utilities.screenCaptureCompressor.ScreenBlock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScreenCapture {
    private Screen screen = null;
    private int modified = 0;

    public ScreenCapture(float compression, int blocksRows, int blocksColumns) {
        this.screen = new Screen(blocksRows, blocksColumns);
    }

    public boolean isEmpty() {
        return this.screen.getScreenBlocks().isEmpty();
    }

    public Vector<String> getChangedScreenBlocks() {
        return this.screen.getChangedScreenBlocks();
    }

    public void clearScreen() {
        this.screen.getChangedScreenBlocks().clear();
        for (int y = 0; y < this.screen.getRowScreenBlocks(); ++y) {
            for (int x = 0; x < this.screen.getColumnScreenBlocks(); ++x) {
                this.screen.addScreenBlock(new ScreenBlock(this.screen.getScreenBlockName(y, x)));
                this.screen.getChangedScreenBlocks().addElement(this.screen.getScreenBlockName(y, x));
            }
        }
    }

    public int getTrafficPercent() {
        return this.modified * 100 / (this.screen.getRowScreenBlocks() * this.screen.getColumnScreenBlocks());
    }

    public void takeAndSaveImage(Robot rt, float compressionQuality, int colorQuality, double scaleAbsolute, Rectangle screenRect) throws IOException {
        if (screenRect.equals(Commons.emptyRect)) {
            screenRect = new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
        }
        BufferedImage screenImage = rt.createScreenCapture(screenRect);
        int pieceWidth = (int)this.screen.getScreenBlockWidth();
        int pieceHeight = (int)this.screen.getScreenBlockHeight();
        int newW = (int)((double)pieceWidth * scaleAbsolute);
        int newH = (int)((double)pieceHeight * scaleAbsolute);
        BufferedImage subImage = new BufferedImage(newW, newH, colorQuality);
        this.screen.getChangedScreenBlocks().clear();
        this.modified = 0;
        for (int y = 0; y < this.screen.getRowScreenBlocks(); ++y) {
            for (int x = 0; x < this.screen.getColumnScreenBlocks(); ++x) {
                String name = this.screen.getScreenBlockName(y, x);
                int startx = pieceWidth * x;
                int starty = pieceHeight * y;
                Graphics2D subImageGraphics = subImage.createGraphics();
                subImageGraphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                subImageGraphics.drawImage(screenImage, 0, 0, newW, newH, startx, starty, startx + pieceWidth, starty + pieceHeight, null);
                if (!this.screen.getScreenBlockImage(name).isModified(ImageUtility.toByteArray(subImage, compressionQuality), 1)) continue;
                this.screen.getChangedScreenBlocks().addElement(name);
                ++this.modified;
            }
        }
    }

    public byte[] getBlock(String name) {
        return this.screen.getScreenBlockImage(name).getData();
    }

    public void setBlock(ScreenBlock block) {
        this.screen.addScreenBlock(block);
    }

    public static long getChangedBlocksSize(HashMap<String, byte[]> blocks) {
        long size = 0L;
        for (String blockName : blocks.keySet()) {
            size += (long)blocks.get(blockName).length;
        }
        return size;
    }

    public HashMap<String, byte[]> getChangedBlocks() {
        HashMap<String, byte[]> blocks = new HashMap<String, byte[]>();
        for (int i = 0; i < this.screen.getChangedScreenBlocks().size(); ++i) {
            String blockName = this.screen.getChangedScreenBlocks().elementAt(i);
            blocks.put(blockName, this.screen.getScreenBlockImage(blockName).getData());
        }
        return blocks;
    }

    public BufferedImage setChangedBlocks(BufferedImage screenImage, HashMap<String, byte[]> changedBlocks) {
        for (String blockName : changedBlocks.keySet()) {
            this.setBlock(new ScreenBlock(blockName, changedBlocks.get(blockName)));
            screenImage = this.insertMosaicPiece(screenImage, blockName);
        }
        return screenImage;
    }

    public BufferedImage insertMosaicPiece(BufferedImage imageTotal, String name) {
        byte[] piece = this.screen.getScreenBlockImage(name).getData();
        ImageIcon imgPiece = new ImageIcon(piece);
        int pieceWidth = imgPiece.getIconWidth();
        int pieceHeight = imgPiece.getIconHeight();
        int row = this.screen.getBlockRow(name);
        int col = this.screen.getBlockColumn(name);
        int x = pieceWidth * col;
        int y = pieceHeight * row;
        Graphics2D imageTotalGraphics = imageTotal.createGraphics();
        imageTotalGraphics.drawImage(imgPiece.getImage(), x, y, pieceWidth, pieceHeight, null);
        return imageTotal;
    }

    public Rectangle getScreenRect() {
        return new Rectangle(0, 0, (int)this.screen.getScreenSizeWidth(), (int)this.screen.getScreenSizeHeight());
    }

    public void updateScreenSize(Rectangle rectangle) {
        this.screen.updateScreenSize(rectangle);
    }
}

