/*
 * Decompiled with CFR 0.152.
 */
package jrdesktop.utilities.screenCaptureCompressor;

public class ScreenBlock {
    public static final int COMPARE_LENGTH = 1;
    public static final int COMPARE_STRING = 2;
    public static final int COMPARE_BYTES = 3;
    private byte[] data = "".getBytes();
    private String name = "";
    private int differences = 0;

    ScreenBlock(String name) {
        this.name = name;
    }

    public ScreenBlock(String name, byte[] data) {
        this.name = name;
        this.data = data;
    }

    public String getName() {
        return this.name;
    }

    public int getDifferences() {
        return this.differences;
    }

    public byte[] getData() {
        return this.data;
    }

    public boolean isModified(byte[] newdata, int method) {
        if (method == 1 && newdata.length != this.data.length) {
            this.data = newdata;
            return true;
        }
        if (method == 2 && !new String(newdata).equals(new String(this.data))) {
            this.data = newdata;
            return true;
        }
        if (method == 3) {
            this.differences = 0;
            for (int i = 0; i < newdata.length; ++i) {
                if (newdata[i] == this.data[i]) continue;
                ++this.differences;
            }
            return this.differences > 0;
        }
        return false;
    }
}

