/*
 * Decompiled with CFR 0.152.
 */
package jrdesktop.utilities.screenCaptureCompressor;

import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.HashMap;
import java.util.Vector;
import jrdesktop.utilities.screenCaptureCompressor.ScreenBlock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Screen {
    private HashMap<String, ScreenBlock> screenBlocks = new HashMap();
    private double screenSizeWidth = Toolkit.getDefaultToolkit().getScreenSize().getWidth();
    private double screenSizeHeight = Toolkit.getDefaultToolkit().getScreenSize().getHeight();
    private int rowScreenBlocks = 0;
    private int columnScreenBlocks = 0;
    private double screenBlockHeight = 0.0;
    private double screenBlockWidth = 0.0;
    private final String separator = "-";
    private Vector<String> changedScreenBlocks = new Vector();

    public Screen(int rowScreenBlocks, int columnScreenBlocks) {
        this.rowScreenBlocks = rowScreenBlocks;
        this.columnScreenBlocks = columnScreenBlocks;
        this.screenBlockHeight = this.getScreenSizeHeight() / (double)rowScreenBlocks;
        this.screenBlockWidth = this.getScreenSizeWidth() / (double)columnScreenBlocks;
    }

    public void updateScreenSize(Rectangle screenRect) {
        this.screenSizeWidth = screenRect.width;
        this.screenSizeHeight = screenRect.height;
        this.screenBlockHeight = this.screenSizeHeight / (double)this.rowScreenBlocks;
        this.screenBlockWidth = this.screenSizeWidth / (double)this.columnScreenBlocks;
    }

    public String getScreenBlockName(int y, int x) {
        return "" + y + "-" + x;
    }

    public ScreenBlock getScreenBlockImage(String name) {
        return this.screenBlocks.get(name);
    }

    public void addScreenBlock(ScreenBlock block) {
        this.screenBlocks.put(block.getName(), block);
    }

    public int getBlockRow(String name) {
        return Integer.parseInt(name.split("-")[0]);
    }

    public int getBlockColumn(String name) {
        return Integer.parseInt(name.split("-")[1]);
    }

    public Vector<String> getChangedScreenBlocks() {
        return this.changedScreenBlocks;
    }

    public HashMap getScreenBlocks() {
        return this.screenBlocks;
    }

    public int getRowScreenBlocks() {
        return this.rowScreenBlocks;
    }

    public int getColumnScreenBlocks() {
        return this.columnScreenBlocks;
    }

    public double getScreenBlockHeight() {
        return this.screenBlockHeight;
    }

    public double getScreenBlockWidth() {
        return this.screenBlockWidth;
    }

    public double getScreenSizeHeight() {
        return this.screenSizeHeight;
    }

    public double getScreenSizeWidth() {
        return this.screenSizeWidth;
    }
}

