/*
 * Decompiled with CFR 0.152.
 */
package jrdesktop.utilities;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;

public class ImageUtility {
    private static ImageWriter writer = null;
    private static ImageWriteParam param = null;

    public static void init() {
        ImageIO.setUseCache(false);
        Iterator<ImageWriter> writers = ImageIO.getImageWritersBySuffix("jpeg");
        writer = writers.next();
        param = writer.getDefaultWriteParam();
        param.setCompressionMode(2);
        param.setCompressionQuality(1.0f);
    }

    public static BufferedImage read(InputStream in) throws IOException {
        BufferedImage image = null;
        image = ImageIO.read(in);
        if (image == null) {
            throw new IOException("Read fails");
        }
        return image;
    }

    public static void write(BufferedImage image, float quality, OutputStream out) throws IOException {
        ImageOutputStream ios = ImageIO.createImageOutputStream(out);
        writer.setOutput(ios);
        param.setCompressionQuality(quality);
        writer.write(null, new IIOImage(image, null, null), param);
        ios.close();
    }

    public static byte[] toByteArray(BufferedImage image, float quality) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            if (quality == -1.0f) {
                ImageIO.write((RenderedImage)image, "jpeg", out);
            } else {
                ImageUtility.write(image, quality, out);
            }
            return out.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return new byte[0];
        }
    }

    public static BufferedImage toBufferedImage(byte[] bytes) {
        try {
            return ImageUtility.read(new ByteArrayInputStream(bytes));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

