/*
 * Decompiled with CFR 0.152.
 */
package jrdesktop.utilities;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.FlavorListener;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.util.List;
import javax.swing.ImageIcon;
import jrdesktop.Commons;
import jrdesktop.utilities.FileUtility;

public class ClipbrdUtility {
    private Clipboard clipboard;
    private FlavorListener flavorlistener;
    private Object object;
    private String txt = "jrdesktop";
    private ImageIcon img = new ImageIcon(Commons.ALIVE_ICON);

    public ClipbrdUtility() {
        this.initClipboard();
        this.clipboard.addFlavorListener(this.flavorlistener);
    }

    public void initClipboard() {
        this.clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        this.flavorlistener = new FlavorListener(){

            public void flavorsChanged(FlavorEvent event) {
                try {
                    Transferable content = ClipbrdUtility.this.clipboard.getContents(this);
                    if (content == null) {
                        return;
                    }
                    if (content.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                        String newtxt = (String)ClipbrdUtility.this.clipboard.getData(DataFlavor.stringFlavor);
                        if (!ClipbrdUtility.this.txt.equals(newtxt)) {
                            ClipbrdUtility.this.txt = newtxt;
                            ClipbrdUtility.this.object = ClipbrdUtility.this.txt;
                        }
                    } else if (content.isDataFlavorSupported(DataFlavor.imageFlavor)) {
                        Image image = (Image)ClipbrdUtility.this.clipboard.getData(DataFlavor.imageFlavor);
                        if (!ClipbrdUtility.this.img.getImage().equals(image)) {
                            ClipbrdUtility.this.img = new ImageIcon(image);
                            ClipbrdUtility.this.object = ClipbrdUtility.this.img;
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
    }

    public boolean isEmpty() {
        return this.object == null;
    }

    public void setText(String string) {
        if (this.txt.equals(string)) {
            return;
        }
        this.txt = string;
        this.clipboard.setContents(new StringSelection(this.txt), null);
    }

    public void setImage(ImageIcon image) {
        if (this.img.getImage().equals(image.getImage())) {
            return;
        }
        this.img = image;
        this.clipboard.setContents(new ImageSelection(this.img.getImage()), null);
    }

    public void setContent(Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof String) {
            this.setText((String)object);
        } else if (object instanceof ImageIcon) {
            this.setImage((ImageIcon)object);
        }
    }

    public Object getContent() {
        Object obj = this.object;
        this.object = null;
        return obj;
    }

    public File[] getFiles() {
        File[] files = new File[]{};
        try {
            Transferable transferable = this.clipboard.getContents(this);
            if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                List list = (List)this.clipboard.getData(DataFlavor.javaFileListFlavor);
                files = list.toArray(new File[list.size()]);
            } else if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                String data = (String)this.clipboard.getData(new DataFlavor("application/x-java-serialized-object; class=java.lang.String"));
                List<File> list = FileUtility.textToFileList(data);
                files = list.toArray(new File[list.size()]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return files;
    }

    public void addFlavorListener() {
        this.clipboard.addFlavorListener(this.flavorlistener);
    }

    public void removeFlavorListener() {
        this.clipboard.removeFlavorListener(this.flavorlistener);
    }

    public static class ImageSelection
    implements Transferable {
        private final Image img;
        static DataFlavor[] flavors = new DataFlavor[]{DataFlavor.imageFlavor};

        public ImageSelection(Image img) {
            this.img = img;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return (DataFlavor[])flavors.clone();
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor.equals(DataFlavor.imageFlavor);
        }

        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.img;
        }
    }
}

