/*
 * Decompiled with CFR 0.152.
 */
package jrdesktop.rmi.server;

import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import javax.rmi.ssl.SslRMIServerSocketFactory;
import javax.swing.JOptionPane;
import jrdesktop.Config;
import jrdesktop.Settings;
import jrdesktop.SystemProperties;
import jrdesktop.rmi.client.MultihomeRMIClientSocketFactory;
import jrdesktop.rmi.server.ServerImpl;
import jrdesktop.utilities.FileUtility;
import jrdesktop.utilities.InetAdrUtility;

public class RMIServer {
    private static Registry registry;
    private static ServerImpl serverImpl;
    public static Config serverConfig;

    public static boolean Start(Config config) {
        serverConfig = config;
        return RMIServer.Start();
    }

    public static boolean Start() {
        if (RMIServer.serverConfig.ssl_enabled) {
            FileUtility.extractFile(Settings.keyStore);
            FileUtility.extractFile(Settings.trustStore);
            SystemProperties.setSSLProps();
        } else {
            SystemProperties.clearSSLProps();
        }
        if (RMIServer.serverConfig.default_address) {
            SystemProperties.setDefaultAdr(RMIServer.serverConfig.server_address);
        } else {
            SystemProperties.clearDefaultAdr();
        }
        try {
            registry = RMIServer.serverConfig.ssl_enabled ? LocateRegistry.createRegistry(RMIServer.serverConfig.server_port, new SslRMIClientSocketFactory(), new SslRMIServerSocketFactory(null, null, true)) : LocateRegistry.createRegistry(RMIServer.serverConfig.server_port);
            if (RMIServer.serverConfig.ssl_enabled && RMIServer.serverConfig.multihomed_enabled) {
                serverImpl = new ServerImpl(new MultihomeRMIClientSocketFactory(new SslRMIClientSocketFactory(), InetAdrUtility.getLocalIPAdresses()), new SslRMIServerSocketFactory(null, null, true));
            } else if (RMIServer.serverConfig.ssl_enabled && !RMIServer.serverConfig.multihomed_enabled) {
                serverImpl = new ServerImpl(new SslRMIClientSocketFactory(), new SslRMIServerSocketFactory(null, null, true), RMIServer.serverConfig.server_port);
            } else if (!RMIServer.serverConfig.ssl_enabled && RMIServer.serverConfig.multihomed_enabled) {
                serverImpl = new ServerImpl(new MultihomeRMIClientSocketFactory(null, InetAdrUtility.getLocalIPAdresses()), null);
            } else if (!RMIServer.serverConfig.ssl_enabled && !RMIServer.serverConfig.multihomed_enabled) {
                serverImpl = new ServerImpl(RMIServer.serverConfig.server_port);
            }
            System.out.println(serverImpl);
            registry.rebind("jrdesktop", serverImpl);
        }
        catch (Exception e) {
            RMIServer.Stop();
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, e.getMessage(), "Error !!", 0);
            return false;
        }
        System.out.println(RMIServer.getStatus());
        return true;
    }

    public static void Stop() {
        try {
            if (registry != null) {
                UnicastRemoteObject.unexportObject(registry, true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        registry = null;
        serverImpl = null;
    }

    public static String getStatus() {
        boolean auth = RMIServer.serverConfig.username.length() != 0 || RMIServer.serverConfig.password.length() != 0;
        String status = "Running ...\nat: " + RMIServer.serverConfig.server_address + ":" + RMIServer.serverConfig.server_port + "\nauthentication: " + (auth ? "enabled" : "disabled") + "\nencryption: " + (RMIServer.serverConfig.ssl_enabled ? "enabled" : "disabled") + "\nmultihomed: " + (RMIServer.serverConfig.multihomed_enabled ? "enabled" : "disabled") + "\nreverse connection: " + (RMIServer.serverConfig.reverseConnection ? "enabled" : "disabled");
        return status;
    }

    static {
        serverConfig = new Config(true, "");
    }
}

