/*
 * Decompiled with CFR 0.152.
 */
package jrdesktop.rmi.client;

import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import javax.swing.JOptionPane;
import jrdesktop.Config;
import jrdesktop.Settings;
import jrdesktop.SystemProperties;
import jrdesktop.rmi.server.ServerInterface;
import jrdesktop.utilities.FileUtility;
import jrdesktop.utilities.InetAdrUtility;
import jrdesktop.utilities.PasswordUtility;

public class RMIClient {
    public Config clientConfig;
    private Registry registry;
    public ServerInterface rmiServer;
    private int index = -1;
    private boolean connected = false;

    public RMIClient(Config config) {
        this.clientConfig = config;
        if (this.clientConfig.ssl_enabled) {
            FileUtility.extractFile(Settings.keyStore);
            FileUtility.extractFile(Settings.trustStore);
            SystemProperties.setSSLProps();
        } else {
            SystemProperties.clearSSLProps();
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void Start() {
        this.connect();
        if (!this.connected) {
            this.disconnect();
        }
    }

    public int connect() {
        this.connected = false;
        try {
            this.registry = this.clientConfig.ssl_enabled ? LocateRegistry.getRegistry(this.clientConfig.server_address, this.clientConfig.server_port, new SslRMIClientSocketFactory()) : LocateRegistry.getRegistry(this.clientConfig.server_address, this.clientConfig.server_port);
            this.rmiServer = (ServerInterface)this.registry.lookup("jrdesktop");
            this.index = this.rmiServer.startViewer(InetAdrUtility.getLocalHost(), this.clientConfig.username, PasswordUtility.encodeString(this.clientConfig.password), this.clientConfig.reverseConnection);
            switch (this.index) {
                case -1: {
                    JOptionPane.showMessageDialog(null, "Authentication failed !!", "Error !!", 0);
                    return -1;
                }
                case -2: {
                    JOptionPane.showMessageDialog(null, "Reverse connection failed !!", "Error !!", 0);
                    return -1;
                }
            }
            this.displayStatus();
            this.connected = true;
            return this.index;
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, e.getMessage(), "Error !!", 0);
            return -1;
        }
    }

    public void disconnect() {
        this.connected = false;
        try {
            if (this.rmiServer != null && this.index > -1) {
                this.rmiServer.stopViewer(this.index);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.rmiServer = null;
        this.registry = null;
    }

    public void displayStatus() {
        boolean auth = this.clientConfig.username.length() != 0 || this.clientConfig.password.length() != 0;
        System.out.println("Viewer connected to " + this.rmiServer + "\n\tauthentication: " + (auth ? "enabled" : "desabled") + "\n\tencryption: " + (this.clientConfig.ssl_enabled ? "enabled" : "desabled") + "\n\treverse connection: " + (this.clientConfig.reverseConnection ? "enabled" : "disabled"));
    }
}

