/*
 * Decompiled with CFR 0.152.
 */
package jrdesktop;

import java.awt.EventQueue;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jrdesktop.AboutJPanel;
import jrdesktop.Commons;
import jrdesktop.Config;
import jrdesktop.HomeJPanel;
import jrdesktop.Settings;
import jrdesktop.SettingsJPanel;
import jrdesktop.main;
import jrdesktop.server.ActiveConnectionsJPanel;
import jrdesktop.server.ConfigJPanel;
import jrdesktop.utilities.InetAdrUtility;
import org.jdesktop.layout.GroupLayout;

public class mainApplet
extends JApplet {
    private static mainApplet applet;
    private static HomeJPanel hjp;
    private static ConfigJPanel cjp;
    private static ActiveConnectionsJPanel acjp;
    private static SettingsJPanel sjp;
    private static AboutJPanel ajp;
    private static JTabbedPane jTabbedPane;

    public void main() {
        Commons.init();
        Settings.displayMode = 1;
        this.analyseAppletArgs();
        Settings.loadConfig();
        Settings.applyConfig(true);
    }

    public void init() {
        this.main();
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    mainApplet.this.initComponents();
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        applet = this;
    }

    public void analyseAppletArgs() {
        String side;
        String ssl_;
        String password;
        String default__;
        String lookAndFeel;
        String proxyport;
        String noexit;
        String home = this.getParameter("home");
        if (home != null) {
            Settings.updateFilePaths(home);
            Settings.loadConfig();
        }
        boolean noSystExit = (noexit = this.getParameter("noexit")) != null ? Boolean.valueOf(noexit) : Settings.exitDisabled;
        String noicon = this.getParameter("noicon");
        boolean noTrayicon = noicon != null ? Boolean.valueOf(noicon) : Settings.systrayDisabled;
        String proxy_server = this.getParameter("pxserver");
        if (proxy_server == null) {
            proxy_server = Settings.proxyServer;
        }
        int proxy_port = (proxyport = this.getParameter("pxport")) != null ? Integer.valueOf(proxyport) : Settings.proxyPort;
        String downloads = this.getParameter("downloads");
        if (downloads == null) {
            downloads = Settings.downloadsDir;
        }
        if ((lookAndFeel = this.getParameter("lookAndFeel")) == null) {
            lookAndFeel = Settings.lookAndFeel;
        }
        boolean proxy_manual = !proxy_server.equals("127.0.0.1") || proxy_port != 80;
        Settings.setConfig(false, noTrayicon, noSystExit, proxy_manual, proxy_server, proxy_port, downloads, lookAndFeel);
        String server = this.getParameter("server");
        if (server == null) {
            server = Commons.defaultServerAddress;
        }
        boolean default_ = (default__ = this.getParameter("default")) != null ? Boolean.valueOf(default__) : true;
        String multihome_ = this.getParameter("multihome");
        boolean multihome = multihome_ != null ? Boolean.valueOf(multihome_) : false;
        String port_ = this.getParameter("port");
        int port = port_ != null ? InetAdrUtility.getPort(port_, 1099) : 1099;
        String httpPort_ = this.getParameter("httpPort");
        int httpPort = httpPort_ != null ? InetAdrUtility.getPort(httpPort_, 6666) : 6666;
        String username = this.getParameter("username");
        if (username == null) {
            username = "admin";
        }
        if ((password = this.getParameter("password")) == null) {
            password = "admin";
        }
        boolean ssl = (ssl_ = this.getParameter("ssl")) != null ? Boolean.valueOf(ssl_) : false;
        String reverse_ = this.getParameter("reverse");
        boolean reverse = reverse_ != null ? Boolean.valueOf(reverse_) : false;
        String config = this.getParameter("config");
        if (config == null) {
            config = "<default config>";
        }
        if ((side = this.getParameter("side")) != null) {
            if (side.equals("server")) {
                main.serverConfig = config.equals("<default config>") ? new Config(true, config, server, default_, multihome, port, httpPort, username, password, ssl, reverse) : new Config(true, config);
                main.startServer();
            } else if (side.equals("viewer")) {
                main.viewerConfig = config.equals("<default config>") ? new Config(false, config, server, port, username, password, ssl, reverse) : new Config(false, config);
                main.startViewer();
            }
        }
    }

    private void initComponents() {
        hjp = new HomeJPanel();
        cjp = new ConfigJPanel();
        acjp = new ActiveConnectionsJPanel();
        sjp = new SettingsJPanel();
        ajp = new AboutJPanel();
        jTabbedPane = new JTabbedPane();
        this.setStub(null);
        jTabbedPane.addTab("Home", new ImageIcon(this.getClass().getResource("/jrdesktop/images/gohome.png")), hjp);
        jTabbedPane.addTab("Config", new ImageIcon(this.getClass().getResource("/jrdesktop/images/configure.png")), cjp);
        jTabbedPane.addTab("Connections", new ImageIcon(this.getClass().getResource("/jrdesktop/images/connect_established.png")), acjp);
        jTabbedPane.addTab("Settings", new ImageIcon(this.getClass().getResource("/jrdesktop/images/settings.png")), sjp);
        jTabbedPane.addTab("About", new ImageIcon(this.getClass().getResource("/jrdesktop/images/about.png")), ajp);
        jTabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                mainApplet.this.jTabbedPaneStateChanged(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(jTabbedPane, -1, 425, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(jTabbedPane, -1, 299, Short.MAX_VALUE).addContainerGap()));
    }

    private void jTabbedPaneStateChanged(ChangeEvent evt) {
        switch (jTabbedPane.getSelectedIndex()) {
            case 0: {
                hjp.updateStatus();
                break;
            }
            case 2: {
                acjp.updateList();
            }
        }
    }

    public static void displayTab(int index) {
        jTabbedPane.setSelectedIndex(index);
    }

    public static void updateStatus() {
        if (hjp != null) {
            hjp.updateStatus();
        }
    }

    public static void close() {
        applet.destroy();
    }
}

