/*
 * Decompiled with CFR 0.152.
 */
package jrdesktop;

import java.awt.AWTException;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import jrdesktop.Commons;
import jrdesktop.main;
import jrdesktop.rmi.server.RMIServer;
import jrdesktop.server.Server;
import jrdesktop.viewer.ConnectionDialog;

public class SysTray {
    private static MenuItem serverItem;
    private static TrayIcon trayIcon;
    private static boolean enabled;
    public static byte customMsg;

    public static void updateServerStatus(byte msgType) {
        SysTray.updateServerStatus(msgType, null);
    }

    public static void updateServerStatus(byte msgType, String msg) {
        if (!SysTray.isSupported() || !enabled) {
            return;
        }
        switch (msgType) {
            case 4: {
                serverItem.setLabel("Stop Server");
                if (Server.isRunning()) {
                    if (Server.getViewersCount() != 0) {
                        trayIcon.setImage(new ImageIcon(Commons.ALIVE_ICON).getImage());
                    } else {
                        trayIcon.setImage(new ImageIcon(Commons.WAIT_ICON).getImage());
                    }
                }
                trayIcon.setToolTip("jrdesktop [Server running]\n" + RMIServer.serverConfig.server_address);
                break;
            }
            case 5: {
                serverItem.setLabel("Start");
                trayIcon.setImage(new ImageIcon(Commons.IDLE_ICON).getImage());
                trayIcon.setToolTip("jrdesktop [Server stopped]\n" + RMIServer.serverConfig.server_address);
                break;
            }
            case 1: {
                serverItem.setLabel("Stop");
                trayIcon.displayMessage("Connection status", "Server Started !!", TrayIcon.MessageType.INFO);
                trayIcon.setImage(new ImageIcon(Commons.WAIT_ICON).getImage());
                trayIcon.setToolTip("jrdesktop [Server running]\n" + RMIServer.serverConfig.server_address);
                break;
            }
            case 3: {
                trayIcon.displayMessage("Connection status", "Connection Failed !!", TrayIcon.MessageType.ERROR);
                break;
            }
            case 2: {
                serverItem.setLabel("Start");
                trayIcon.displayMessage("Connection status", "Server Stopped !!", TrayIcon.MessageType.INFO);
                trayIcon.setImage(new ImageIcon(Commons.IDLE_ICON).getImage());
                trayIcon.setToolTip("jrdesktop [Server stopped]\n" + RMIServer.serverConfig.server_address);
                break;
            }
            default: {
                trayIcon.displayMessage("File Reception:", msg, TrayIcon.MessageType.INFO);
            }
        }
        serverItem.setEnabled(true);
        if (msgType > 0) {
            main.updateStatus();
        }
    }

    public static void displayViewer(String viewer, int size, boolean connected) {
        if (!SysTray.isSupported() || !enabled) {
            return;
        }
        if (connected) {
            trayIcon.displayMessage("Viewer details", viewer + " connected !!", TrayIcon.MessageType.INFO);
            if (size == 0) {
                trayIcon.setImage(new ImageIcon(Commons.ALIVE_ICON).getImage());
            }
        } else {
            trayIcon.displayMessage("Viewer details", viewer + " disconnected !!", TrayIcon.MessageType.INFO);
            if (size == 0) {
                trayIcon.setImage(new ImageIcon(Commons.WAIT_ICON).getImage());
            }
        }
    }

    public static boolean isSupported() {
        return Commons.java_version < 1.6f ? false : SystemTray.isSupported();
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static void close() {
        if (!SysTray.isSupported() || !enabled) {
            return;
        }
        enabled = false;
        SystemTray tray = SystemTray.getSystemTray();
        tray.remove(trayIcon);
    }

    public static void display() {
        if (!SysTray.isSupported() || enabled) {
            return;
        }
        enabled = true;
        Runnable runner = new Runnable(){

            public void run() {
                SystemTray tray = SystemTray.getSystemTray();
                PopupMenu popup = new PopupMenu();
                trayIcon = new TrayIcon(new ImageIcon(Commons.IDLE_ICON).getImage(), "jrdesktop", popup);
                trayIcon.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        main.displayTab(0);
                    }
                });
                MenuItem item = new MenuItem("Open jrdesktop");
                item.setFont(new Font(null, 1, 12));
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        main.displayTab(0);
                    }
                });
                popup.add(item);
                item = new MenuItem("-");
                popup.add(item);
                serverItem = new MenuItem("Start");
                serverItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        serverItem.setEnabled(false);
                        if (Server.isRunning()) {
                            Server.Stop();
                        } else {
                            Server.Start();
                        }
                    }
                });
                popup.add(serverItem);
                item = new MenuItem("Configuration ...");
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        main.displayTab(1);
                    }
                });
                popup.add(item);
                item = new MenuItem("Active Connections");
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        main.displayTab(2);
                    }
                });
                popup.add(item);
                item = new MenuItem("-");
                popup.add(item);
                item = new MenuItem("New connection ...");
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        ConnectionDialog.main(null);
                    }
                });
                popup.add(item);
                item = new MenuItem("-");
                popup.add(item);
                item = new MenuItem("Settings ...");
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        main.displayTab(3);
                    }
                });
                popup.add(item);
                item = new MenuItem("About");
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        main.displayTab(4);
                    }
                });
                popup.add(item);
                item = new MenuItem("Exit");
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        main.quit();
                    }
                });
                popup.add(item);
                try {
                    tray.add(trayIcon);
                }
                catch (AWTException e) {
                    System.err.println("Can't add to tray");
                }
                if (Server.isRunning()) {
                    SysTray.updateServerStatus((byte)4);
                } else {
                    SysTray.updateServerStatus((byte)5);
                }
            }
        };
        EventQueue.invokeLater(runner);
    }

    static {
        enabled = false;
        customMsg = 0;
    }
}

