/*
 * Decompiled with CFR 0.152.
 */
package jrdesktop;

import java.util.ArrayList;
import javax.swing.JOptionPane;
import jrdesktop.utilities.FileUtility;

public class ConnectionInfos {
    private long previous = 0L;
    private long startedAt = 0L;
    private long duration = 0L;
    private long dataSize = 0L;
    private long sentData = 0L;
    private long receivedData = 0L;
    private long transferSpeed = 0L;

    public ConnectionInfos(boolean start) {
        if (start) {
            this.init();
        }
    }

    public void init() {
        this.startedAt = System.currentTimeMillis();
        this.duration = 0L;
        this.dataSize = 0L;
        this.sentData = 0L;
        this.receivedData = 0L;
        this.transferSpeed = 0L;
    }

    public void display() {
        this.refresh();
        JOptionPane.showMessageDialog(null, "Duration: \t" + this.getDuration() + "\n\n" + "Sent data: \t" + this.getSize(this.sentData) + "\n" + "Received data: \t" + this.getSize(this.receivedData) + "\n\n" + "Total data size: \t" + this.getSize(this.dataSize) + "\n\n" + "Transfer speed: \t" + this.getSpeed(), "Connection infos", 1);
    }

    public static void display(ArrayList data) {
        JOptionPane.showMessageDialog(null, "Duration: \t" + data.get(0) + "\n\n" + "Sent data: \t" + data.get(1) + "\n" + "Received data: \t" + data.get(2) + "\n\n" + "Total data size: \t" + data.get(3) + "\n\n" + "Transfer speed: \t" + data.get(4), "Connection infos", 1);
    }

    public ArrayList getData() {
        this.refresh();
        ArrayList<String> data = new ArrayList<String>();
        data.add(this.getDuration());
        data.add(this.getSize(this.sentData));
        data.add(this.getSize(this.receivedData));
        data.add(this.getSize(this.dataSize));
        data.add(this.getSpeed());
        return data;
    }

    public void incSentData(long size) {
        this.sentData += size;
    }

    public void incReceivedData(long size) {
        this.receivedData += size;
    }

    public void refresh() {
        this.duration = this.previous + System.currentTimeMillis() - this.startedAt;
        this.dataSize = this.sentData + this.receivedData;
        this.transferSpeed = this.dataSize * 1000L / this.duration;
    }

    public String getDuration() {
        long h = this.duration / 3600000L;
        long m = this.duration % 3600000L / 60000L;
        long s = this.duration % 60000L / 1000L;
        return h + ":" + m + ":" + s;
    }

    public String getSize(long size) {
        return FileUtility.getSizeHumanFormat(size, FileUtility.BYTES);
    }

    public String getSpeed() {
        return FileUtility.getSizeHumanFormat(this.transferSpeed, FileUtility.BYTES_PER_SECOND);
    }

    public void resetStartTime() {
        this.previous = System.currentTimeMillis() - this.startedAt;
        this.startedAt = 0L;
    }
}

