/*
 * Decompiled with CFR 0.152.
 */
package jrdesktop;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import jrdesktop.Commons;
import jrdesktop.Settings;
import jrdesktop.utilities.FileUtility;
import jrdesktop.utilities.PasswordUtility;

public class Config {
    public String server_address = Commons.defaultServerAddress;
    public int server_port = 1099;
    public int http_port = 6666;
    public String username = "admin";
    public String password = "admin";
    public boolean ssl_enabled = false;
    public boolean multihomed_enabled = false;
    public boolean default_address = true;
    public boolean reverseConnection = false;

    public Config(boolean side, String name) {
        if (new File(name).canRead()) {
            this.loadData(name);
            this.storeConfiguration(side, "");
        } else {
            this.loadConfiguration(side, name);
        }
    }

    public Config(boolean side, String name, String Address, boolean default_address, boolean Multihomed_enabled, int Port, int httpPort, String Username, String Password, boolean Ssl_enabled, boolean reverse_connection) {
        this.setConfiguration(side, name, Address, default_address, Multihomed_enabled, Port, httpPort, Username, Password, Ssl_enabled, reverse_connection);
    }

    public Config(boolean side, String name, String Address, int Port, String Username, String Password, boolean Ssl_enabled, boolean reverse_connection) {
        this.setConfiguration(side, name, Address, Port, Username, Password, Ssl_enabled, reverse_connection);
    }

    public void loadData(String filename) {
        try {
            Properties properties = new Properties();
            properties.load(new FileInputStream(filename));
            this.server_address = properties.get("server-address").toString();
            this.server_port = Integer.valueOf(properties.get("server-port").toString());
            this.http_port = Integer.valueOf(properties.get("http-port").toString());
            this.username = properties.get("username").toString();
            this.password = PasswordUtility.decodeString(properties.get("password").toString());
            this.ssl_enabled = Boolean.valueOf(properties.getProperty("ssl-enabled"));
            this.multihomed_enabled = Boolean.valueOf(properties.getProperty("multihomed-enabled"));
            this.default_address = Boolean.valueOf(properties.getProperty("default-address"));
            this.reverseConnection = Boolean.valueOf(properties.getProperty("reverse-connection"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadConfiguration(boolean side, String name) {
        String config_file = FileUtility.getConfigFilename(side, name);
        if (new File(config_file).canRead()) {
            this.loadData(config_file);
        } else {
            this.storeConfiguration(side, name);
        }
    }

    public void storeConfiguration(boolean side, String name) {
        String config_file = FileUtility.getConfigFilename(side, name);
        try {
            new File(Settings.home).mkdirs();
            new File(config_file).createNewFile();
            Properties properties = new Properties();
            properties.put("server-address", this.server_address);
            properties.put("server-port", String.valueOf(this.server_port));
            properties.put("http-port", String.valueOf(this.http_port));
            properties.put("username", this.username);
            properties.put("password", PasswordUtility.encodeString(this.password));
            properties.put("ssl-enabled", String.valueOf(this.ssl_enabled));
            properties.put("multihomed-enabled", String.valueOf(this.multihomed_enabled));
            properties.put("default-address", String.valueOf(this.default_address));
            properties.put("reverse-connection", String.valueOf(this.reverseConnection));
            properties.store(new FileOutputStream(config_file), "jrdesktop " + FileUtility.getSide(side) + " configuration file");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setConfiguration(boolean side, String name, String Address, boolean Default_Address, boolean Multihomed_enabled, int Port, int HttpPort, String Username, String Password, boolean Ssl_enabled, boolean reverse_connection) {
        this.server_address = Address;
        this.default_address = Default_Address;
        this.multihomed_enabled = Multihomed_enabled;
        this.server_port = Port;
        this.http_port = HttpPort;
        this.username = Username;
        this.password = Password;
        this.ssl_enabled = Ssl_enabled;
        this.reverseConnection = reverse_connection;
        this.storeConfiguration(side, name);
    }

    public void setConfiguration(boolean side, String name, String address, int port, String Username, String password, boolean ssl_enabled, boolean reverse_connection) {
        this.setConfiguration(side, name, address, false, false, port, this.http_port, Username, password, ssl_enabled, reverse_connection);
    }
}

