/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11.wrapper;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.CK_C_INITIALIZE_ARGS;
import sun.security.pkcs11.wrapper.CK_INFO;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.CK_MECHANISM_INFO;
import sun.security.pkcs11.wrapper.CK_NOTIFY;
import sun.security.pkcs11.wrapper.CK_SESSION_INFO;
import sun.security.pkcs11.wrapper.CK_SLOT_INFO;
import sun.security.pkcs11.wrapper.CK_TOKEN_INFO;
import sun.security.pkcs11.wrapper.PKCS11Exception;

public class PKCS11 {
    private static final String PKCS11_WRAPPER = "j2pkcs11";
    private final String pkcs11ModulePath;
    private long pNativeData;
    private static final Map<String, PKCS11> moduleMap;

    public static void loadNative() {
    }

    public static native long freeMechanism(long var0);

    private static native void initializeLibrary();

    private static native void finalizeLibrary();

    PKCS11(String pkcs11ModulePath, String functionListName) throws IOException {
        this.connect(pkcs11ModulePath, functionListName);
        this.pkcs11ModulePath = pkcs11ModulePath;
    }

    public static synchronized PKCS11 getInstance(String pkcs11ModulePath, String functionList, CK_C_INITIALIZE_ARGS pInitArgs, boolean omitInitialize) throws IOException, PKCS11Exception {
        PKCS11 pkcs11 = moduleMap.get(pkcs11ModulePath);
        if (pkcs11 == null) {
            block4: {
                pkcs11 = pInitArgs != null && (pInitArgs.flags & 2L) != 0L ? new PKCS11(pkcs11ModulePath, functionList) : new SynchronizedPKCS11(pkcs11ModulePath, functionList);
                if (!omitInitialize) {
                    try {
                        pkcs11.C_Initialize(pInitArgs);
                    }
                    catch (PKCS11Exception e) {
                        if (e.getErrorCode() == 401L) break block4;
                        throw e;
                    }
                }
            }
            moduleMap.put(pkcs11ModulePath, pkcs11);
        }
        return pkcs11;
    }

    private native void connect(String var1, String var2) throws IOException;

    private native void disconnect();

    native void C_Initialize(Object var1) throws PKCS11Exception;

    public native void C_Finalize(Object var1) throws PKCS11Exception;

    public native CK_INFO C_GetInfo() throws PKCS11Exception;

    public native long[] C_GetSlotList(boolean var1) throws PKCS11Exception;

    public native CK_SLOT_INFO C_GetSlotInfo(long var1) throws PKCS11Exception;

    public native CK_TOKEN_INFO C_GetTokenInfo(long var1) throws PKCS11Exception;

    public native long[] C_GetMechanismList(long var1) throws PKCS11Exception;

    public native CK_MECHANISM_INFO C_GetMechanismInfo(long var1, long var3) throws PKCS11Exception;

    public native long C_OpenSession(long var1, long var3, Object var5, CK_NOTIFY var6) throws PKCS11Exception;

    public native void C_CloseSession(long var1) throws PKCS11Exception;

    public native CK_SESSION_INFO C_GetSessionInfo(long var1) throws PKCS11Exception;

    public native byte[] C_GetOperationState(long var1) throws PKCS11Exception;

    public native void C_SetOperationState(long var1, byte[] var3, long var4, long var6) throws PKCS11Exception;

    public native void C_Login(long var1, long var3, char[] var5) throws PKCS11Exception;

    public native void C_Logout(long var1) throws PKCS11Exception;

    public native long C_CreateObject(long var1, CK_ATTRIBUTE[] var3) throws PKCS11Exception;

    public native long C_CopyObject(long var1, long var3, CK_ATTRIBUTE[] var5) throws PKCS11Exception;

    public native void C_DestroyObject(long var1, long var3) throws PKCS11Exception;

    public native void C_GetAttributeValue(long var1, long var3, CK_ATTRIBUTE[] var5) throws PKCS11Exception;

    public native void C_SetAttributeValue(long var1, long var3, CK_ATTRIBUTE[] var5) throws PKCS11Exception;

    public native void C_FindObjectsInit(long var1, CK_ATTRIBUTE[] var3) throws PKCS11Exception;

    public native long[] C_FindObjects(long var1, long var3) throws PKCS11Exception;

    public native void C_FindObjectsFinal(long var1) throws PKCS11Exception;

    public native void C_EncryptInit(long var1, CK_MECHANISM var3, long var4) throws PKCS11Exception;

    public native int C_Encrypt(long var1, long var3, byte[] var5, int var6, int var7, long var8, byte[] var10, int var11, int var12) throws PKCS11Exception;

    public native int C_EncryptUpdate(long var1, long var3, byte[] var5, int var6, int var7, long var8, byte[] var10, int var11, int var12) throws PKCS11Exception;

    public native int C_EncryptFinal(long var1, long var3, byte[] var5, int var6, int var7) throws PKCS11Exception;

    public native void C_DecryptInit(long var1, CK_MECHANISM var3, long var4) throws PKCS11Exception;

    public native int C_Decrypt(long var1, long var3, byte[] var5, int var6, int var7, long var8, byte[] var10, int var11, int var12) throws PKCS11Exception;

    public native int C_DecryptUpdate(long var1, long var3, byte[] var5, int var6, int var7, long var8, byte[] var10, int var11, int var12) throws PKCS11Exception;

    public native int C_DecryptFinal(long var1, long var3, byte[] var5, int var6, int var7) throws PKCS11Exception;

    public native void C_DigestInit(long var1, CK_MECHANISM var3) throws PKCS11Exception;

    public native int C_DigestSingle(long var1, CK_MECHANISM var3, byte[] var4, int var5, int var6, byte[] var7, int var8, int var9) throws PKCS11Exception;

    public native void C_DigestUpdate(long var1, long var3, byte[] var5, int var6, int var7) throws PKCS11Exception;

    public native void C_DigestKey(long var1, long var3) throws PKCS11Exception;

    public native int C_DigestFinal(long var1, byte[] var3, int var4, int var5) throws PKCS11Exception;

    public native void C_SignInit(long var1, CK_MECHANISM var3, long var4) throws PKCS11Exception;

    public native byte[] C_Sign(long var1, byte[] var3) throws PKCS11Exception;

    public native void C_SignUpdate(long var1, long var3, byte[] var5, int var6, int var7) throws PKCS11Exception;

    public native byte[] C_SignFinal(long var1, int var3) throws PKCS11Exception;

    public native void C_SignRecoverInit(long var1, CK_MECHANISM var3, long var4) throws PKCS11Exception;

    public native int C_SignRecover(long var1, byte[] var3, int var4, int var5, byte[] var6, int var7, int var8) throws PKCS11Exception;

    public native void C_VerifyInit(long var1, CK_MECHANISM var3, long var4) throws PKCS11Exception;

    public native void C_Verify(long var1, byte[] var3, byte[] var4) throws PKCS11Exception;

    public native void C_VerifyUpdate(long var1, long var3, byte[] var5, int var6, int var7) throws PKCS11Exception;

    public native void C_VerifyFinal(long var1, byte[] var3) throws PKCS11Exception;

    public native void C_VerifyRecoverInit(long var1, CK_MECHANISM var3, long var4) throws PKCS11Exception;

    public native int C_VerifyRecover(long var1, byte[] var3, int var4, int var5, byte[] var6, int var7, int var8) throws PKCS11Exception;

    public native byte[] getNativeKeyInfo(long var1, long var3, long var5, CK_MECHANISM var7) throws PKCS11Exception;

    public native long createNativeKey(long var1, byte[] var3, long var4, CK_MECHANISM var6) throws PKCS11Exception;

    public native long C_GenerateKey(long var1, CK_MECHANISM var3, CK_ATTRIBUTE[] var4) throws PKCS11Exception;

    public native long[] C_GenerateKeyPair(long var1, CK_MECHANISM var3, CK_ATTRIBUTE[] var4, CK_ATTRIBUTE[] var5) throws PKCS11Exception;

    public native byte[] C_WrapKey(long var1, CK_MECHANISM var3, long var4, long var6) throws PKCS11Exception;

    public native long C_UnwrapKey(long var1, CK_MECHANISM var3, long var4, byte[] var6, CK_ATTRIBUTE[] var7) throws PKCS11Exception;

    public native long C_DeriveKey(long var1, CK_MECHANISM var3, long var4, CK_ATTRIBUTE[] var6) throws PKCS11Exception;

    public native void C_SeedRandom(long var1, byte[] var3) throws PKCS11Exception;

    public native void C_GenerateRandom(long var1, byte[] var3) throws PKCS11Exception;

    public String toString() {
        return "Module name: " + this.pkcs11ModulePath;
    }

    protected void finalize() throws Throwable {
        this.disconnect();
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                System.loadLibrary(PKCS11.PKCS11_WRAPPER);
                return null;
            }
        });
        PKCS11.initializeLibrary();
        moduleMap = new HashMap<String, PKCS11>();
    }

    static class SynchronizedPKCS11
    extends PKCS11 {
        SynchronizedPKCS11(String pkcs11ModulePath, String functionListName) throws IOException {
            super(pkcs11ModulePath, functionListName);
        }

        @Override
        synchronized void C_Initialize(Object pInitArgs) throws PKCS11Exception {
            super.C_Initialize(pInitArgs);
        }

        @Override
        public synchronized void C_Finalize(Object pReserved) throws PKCS11Exception {
            super.C_Finalize(pReserved);
        }

        @Override
        public synchronized CK_INFO C_GetInfo() throws PKCS11Exception {
            return super.C_GetInfo();
        }

        @Override
        public synchronized long[] C_GetSlotList(boolean tokenPresent) throws PKCS11Exception {
            return super.C_GetSlotList(tokenPresent);
        }

        @Override
        public synchronized CK_SLOT_INFO C_GetSlotInfo(long slotID) throws PKCS11Exception {
            return super.C_GetSlotInfo(slotID);
        }

        @Override
        public synchronized CK_TOKEN_INFO C_GetTokenInfo(long slotID) throws PKCS11Exception {
            return super.C_GetTokenInfo(slotID);
        }

        @Override
        public synchronized long[] C_GetMechanismList(long slotID) throws PKCS11Exception {
            return super.C_GetMechanismList(slotID);
        }

        @Override
        public synchronized CK_MECHANISM_INFO C_GetMechanismInfo(long slotID, long type) throws PKCS11Exception {
            return super.C_GetMechanismInfo(slotID, type);
        }

        @Override
        public synchronized long C_OpenSession(long slotID, long flags, Object pApplication, CK_NOTIFY Notify) throws PKCS11Exception {
            return super.C_OpenSession(slotID, flags, pApplication, Notify);
        }

        @Override
        public synchronized void C_CloseSession(long hSession) throws PKCS11Exception {
            super.C_CloseSession(hSession);
        }

        @Override
        public synchronized CK_SESSION_INFO C_GetSessionInfo(long hSession) throws PKCS11Exception {
            return super.C_GetSessionInfo(hSession);
        }

        @Override
        public synchronized void C_Login(long hSession, long userType, char[] pPin) throws PKCS11Exception {
            super.C_Login(hSession, userType, pPin);
        }

        @Override
        public synchronized void C_Logout(long hSession) throws PKCS11Exception {
            super.C_Logout(hSession);
        }

        @Override
        public synchronized long C_CreateObject(long hSession, CK_ATTRIBUTE[] pTemplate) throws PKCS11Exception {
            return super.C_CreateObject(hSession, pTemplate);
        }

        @Override
        public synchronized long C_CopyObject(long hSession, long hObject, CK_ATTRIBUTE[] pTemplate) throws PKCS11Exception {
            return super.C_CopyObject(hSession, hObject, pTemplate);
        }

        @Override
        public synchronized void C_DestroyObject(long hSession, long hObject) throws PKCS11Exception {
            super.C_DestroyObject(hSession, hObject);
        }

        @Override
        public synchronized void C_GetAttributeValue(long hSession, long hObject, CK_ATTRIBUTE[] pTemplate) throws PKCS11Exception {
            super.C_GetAttributeValue(hSession, hObject, pTemplate);
        }

        @Override
        public synchronized void C_SetAttributeValue(long hSession, long hObject, CK_ATTRIBUTE[] pTemplate) throws PKCS11Exception {
            super.C_SetAttributeValue(hSession, hObject, pTemplate);
        }

        @Override
        public synchronized void C_FindObjectsInit(long hSession, CK_ATTRIBUTE[] pTemplate) throws PKCS11Exception {
            super.C_FindObjectsInit(hSession, pTemplate);
        }

        @Override
        public synchronized long[] C_FindObjects(long hSession, long ulMaxObjectCount) throws PKCS11Exception {
            return super.C_FindObjects(hSession, ulMaxObjectCount);
        }

        @Override
        public synchronized void C_FindObjectsFinal(long hSession) throws PKCS11Exception {
            super.C_FindObjectsFinal(hSession);
        }

        @Override
        public synchronized void C_EncryptInit(long hSession, CK_MECHANISM pMechanism, long hKey) throws PKCS11Exception {
            super.C_EncryptInit(hSession, pMechanism, hKey);
        }

        @Override
        public synchronized int C_Encrypt(long hSession, long directIn, byte[] in, int inOfs, int inLen, long directOut, byte[] out, int outOfs, int outLen) throws PKCS11Exception {
            return super.C_Encrypt(hSession, directIn, in, inOfs, inLen, directOut, out, outOfs, outLen);
        }

        @Override
        public synchronized int C_EncryptUpdate(long hSession, long directIn, byte[] in, int inOfs, int inLen, long directOut, byte[] out, int outOfs, int outLen) throws PKCS11Exception {
            return super.C_EncryptUpdate(hSession, directIn, in, inOfs, inLen, directOut, out, outOfs, outLen);
        }

        @Override
        public synchronized int C_EncryptFinal(long hSession, long directOut, byte[] out, int outOfs, int outLen) throws PKCS11Exception {
            return super.C_EncryptFinal(hSession, directOut, out, outOfs, outLen);
        }

        @Override
        public synchronized void C_DecryptInit(long hSession, CK_MECHANISM pMechanism, long hKey) throws PKCS11Exception {
            super.C_DecryptInit(hSession, pMechanism, hKey);
        }

        @Override
        public synchronized int C_Decrypt(long hSession, long directIn, byte[] in, int inOfs, int inLen, long directOut, byte[] out, int outOfs, int outLen) throws PKCS11Exception {
            return super.C_Decrypt(hSession, directIn, in, inOfs, inLen, directOut, out, outOfs, outLen);
        }

        @Override
        public synchronized int C_DecryptUpdate(long hSession, long directIn, byte[] in, int inOfs, int inLen, long directOut, byte[] out, int outOfs, int outLen) throws PKCS11Exception {
            return super.C_DecryptUpdate(hSession, directIn, in, inOfs, inLen, directOut, out, outOfs, outLen);
        }

        @Override
        public synchronized int C_DecryptFinal(long hSession, long directOut, byte[] out, int outOfs, int outLen) throws PKCS11Exception {
            return super.C_DecryptFinal(hSession, directOut, out, outOfs, outLen);
        }

        @Override
        public synchronized void C_DigestInit(long hSession, CK_MECHANISM pMechanism) throws PKCS11Exception {
            super.C_DigestInit(hSession, pMechanism);
        }

        @Override
        public synchronized int C_DigestSingle(long hSession, CK_MECHANISM pMechanism, byte[] in, int inOfs, int inLen, byte[] digest, int digestOfs, int digestLen) throws PKCS11Exception {
            return super.C_DigestSingle(hSession, pMechanism, in, inOfs, inLen, digest, digestOfs, digestLen);
        }

        @Override
        public synchronized void C_DigestUpdate(long hSession, long directIn, byte[] in, int inOfs, int inLen) throws PKCS11Exception {
            super.C_DigestUpdate(hSession, directIn, in, inOfs, inLen);
        }

        @Override
        public synchronized void C_DigestKey(long hSession, long hKey) throws PKCS11Exception {
            super.C_DigestKey(hSession, hKey);
        }

        @Override
        public synchronized int C_DigestFinal(long hSession, byte[] pDigest, int digestOfs, int digestLen) throws PKCS11Exception {
            return super.C_DigestFinal(hSession, pDigest, digestOfs, digestLen);
        }

        @Override
        public synchronized void C_SignInit(long hSession, CK_MECHANISM pMechanism, long hKey) throws PKCS11Exception {
            super.C_SignInit(hSession, pMechanism, hKey);
        }

        @Override
        public synchronized byte[] C_Sign(long hSession, byte[] pData) throws PKCS11Exception {
            return super.C_Sign(hSession, pData);
        }

        @Override
        public synchronized void C_SignUpdate(long hSession, long directIn, byte[] in, int inOfs, int inLen) throws PKCS11Exception {
            super.C_SignUpdate(hSession, directIn, in, inOfs, inLen);
        }

        @Override
        public synchronized byte[] C_SignFinal(long hSession, int expectedLen) throws PKCS11Exception {
            return super.C_SignFinal(hSession, expectedLen);
        }

        @Override
        public synchronized void C_SignRecoverInit(long hSession, CK_MECHANISM pMechanism, long hKey) throws PKCS11Exception {
            super.C_SignRecoverInit(hSession, pMechanism, hKey);
        }

        @Override
        public synchronized int C_SignRecover(long hSession, byte[] in, int inOfs, int inLen, byte[] out, int outOufs, int outLen) throws PKCS11Exception {
            return super.C_SignRecover(hSession, in, inOfs, inLen, out, outOufs, outLen);
        }

        @Override
        public synchronized void C_VerifyInit(long hSession, CK_MECHANISM pMechanism, long hKey) throws PKCS11Exception {
            super.C_VerifyInit(hSession, pMechanism, hKey);
        }

        @Override
        public synchronized void C_Verify(long hSession, byte[] pData, byte[] pSignature) throws PKCS11Exception {
            super.C_Verify(hSession, pData, pSignature);
        }

        @Override
        public synchronized void C_VerifyUpdate(long hSession, long directIn, byte[] in, int inOfs, int inLen) throws PKCS11Exception {
            super.C_VerifyUpdate(hSession, directIn, in, inOfs, inLen);
        }

        @Override
        public synchronized void C_VerifyFinal(long hSession, byte[] pSignature) throws PKCS11Exception {
            super.C_VerifyFinal(hSession, pSignature);
        }

        @Override
        public synchronized void C_VerifyRecoverInit(long hSession, CK_MECHANISM pMechanism, long hKey) throws PKCS11Exception {
            super.C_VerifyRecoverInit(hSession, pMechanism, hKey);
        }

        @Override
        public synchronized int C_VerifyRecover(long hSession, byte[] in, int inOfs, int inLen, byte[] out, int outOufs, int outLen) throws PKCS11Exception {
            return super.C_VerifyRecover(hSession, in, inOfs, inLen, out, outOufs, outLen);
        }

        @Override
        public synchronized long C_GenerateKey(long hSession, CK_MECHANISM pMechanism, CK_ATTRIBUTE[] pTemplate) throws PKCS11Exception {
            return super.C_GenerateKey(hSession, pMechanism, pTemplate);
        }

        @Override
        public synchronized long[] C_GenerateKeyPair(long hSession, CK_MECHANISM pMechanism, CK_ATTRIBUTE[] pPublicKeyTemplate, CK_ATTRIBUTE[] pPrivateKeyTemplate) throws PKCS11Exception {
            return super.C_GenerateKeyPair(hSession, pMechanism, pPublicKeyTemplate, pPrivateKeyTemplate);
        }

        @Override
        public synchronized byte[] C_WrapKey(long hSession, CK_MECHANISM pMechanism, long hWrappingKey, long hKey) throws PKCS11Exception {
            return super.C_WrapKey(hSession, pMechanism, hWrappingKey, hKey);
        }

        @Override
        public synchronized long C_UnwrapKey(long hSession, CK_MECHANISM pMechanism, long hUnwrappingKey, byte[] pWrappedKey, CK_ATTRIBUTE[] pTemplate) throws PKCS11Exception {
            return super.C_UnwrapKey(hSession, pMechanism, hUnwrappingKey, pWrappedKey, pTemplate);
        }

        @Override
        public synchronized long C_DeriveKey(long hSession, CK_MECHANISM pMechanism, long hBaseKey, CK_ATTRIBUTE[] pTemplate) throws PKCS11Exception {
            return super.C_DeriveKey(hSession, pMechanism, hBaseKey, pTemplate);
        }

        @Override
        public synchronized void C_SeedRandom(long hSession, byte[] pSeed) throws PKCS11Exception {
            super.C_SeedRandom(hSession, pSeed);
        }

        @Override
        public synchronized void C_GenerateRandom(long hSession, byte[] randomData) throws PKCS11Exception {
            super.C_GenerateRandom(hSession, randomData);
        }
    }
}

