/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ec;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.interfaces.ECPrivateKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import sun.security.pkcs.PKCS8Key;
import sun.security.util.ArrayUtil;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ECParameters;
import sun.security.x509.AlgorithmId;

public final class ECPrivateKeyImpl
extends PKCS8Key
implements ECPrivateKey {
    private static final long serialVersionUID = 88695385615075129L;
    private BigInteger s;
    private byte[] arrayS;
    private ECParameterSpec params;

    public ECPrivateKeyImpl(byte[] encoded) throws InvalidKeyException {
        this.decode(encoded);
    }

    public ECPrivateKeyImpl(BigInteger s, ECParameterSpec params) throws InvalidKeyException {
        this.s = s;
        this.params = params;
        this.makeEncoding(s);
    }

    ECPrivateKeyImpl(byte[] s, ECParameterSpec params) throws InvalidKeyException {
        this.arrayS = (byte[])s.clone();
        this.params = params;
        this.makeEncoding(s);
    }

    private void makeEncoding(byte[] s) throws InvalidKeyException {
        this.algid = new AlgorithmId(AlgorithmId.EC_oid, ECParameters.getAlgorithmParameters(this.params));
        try {
            DerOutputStream out = new DerOutputStream();
            out.putInteger(1);
            byte[] privBytes = (byte[])s.clone();
            ArrayUtil.reverse(privBytes);
            out.putOctetString(privBytes);
            DerValue val = new DerValue(48, out.toByteArray());
            this.key = val.toByteArray();
        }
        catch (IOException exc) {
            throw new InvalidKeyException(exc);
        }
    }

    private void makeEncoding(BigInteger s) throws InvalidKeyException {
        this.algid = new AlgorithmId(AlgorithmId.EC_oid, ECParameters.getAlgorithmParameters(this.params));
        try {
            byte[] sArr = s.toByteArray();
            int numOctets = (this.params.getOrder().bitLength() + 7) / 8;
            byte[] sOctets = new byte[numOctets];
            int inPos = Math.max(sArr.length - sOctets.length, 0);
            int outPos = Math.max(sOctets.length - sArr.length, 0);
            int length = Math.min(sArr.length, sOctets.length);
            System.arraycopy(sArr, inPos, sOctets, outPos, length);
            DerOutputStream out = new DerOutputStream();
            out.putInteger(1);
            out.putOctetString(sOctets);
            DerValue val = new DerValue(48, out.toByteArray());
            this.key = val.toByteArray();
        }
        catch (IOException exc) {
            throw new InvalidKeyException(exc);
        }
    }

    @Override
    public String getAlgorithm() {
        return "EC";
    }

    @Override
    public BigInteger getS() {
        if (this.s == null) {
            byte[] arrCopy = (byte[])this.arrayS.clone();
            ArrayUtil.reverse(arrCopy);
            this.s = new BigInteger(1, arrCopy);
        }
        return this.s;
    }

    public byte[] getArrayS() {
        if (this.arrayS == null) {
            byte[] arr = this.getS().toByteArray();
            ArrayUtil.reverse(arr);
            int byteLength = (this.params.getOrder().bitLength() + 7) / 8;
            this.arrayS = new byte[byteLength];
            int length = Math.min(byteLength, arr.length);
            System.arraycopy(arr, 0, this.arrayS, 0, length);
        }
        return (byte[])this.arrayS.clone();
    }

    @Override
    public ECParameterSpec getParams() {
        return this.params;
    }

    protected void parseKeyBits() throws InvalidKeyException {
        try {
            DerInputStream in = new DerInputStream(this.key);
            DerValue derValue = in.getDerValue();
            if (derValue.tag != 48) {
                throw new IOException("Not a SEQUENCE");
            }
            DerInputStream data = derValue.data;
            int version = data.getInteger();
            if (version != 1) {
                throw new IOException("Version must be 1");
            }
            byte[] privData = data.getOctetString();
            ArrayUtil.reverse(privData);
            this.arrayS = privData;
            while (data.available() != 0) {
                DerValue value = data.getDerValue();
                if (value.isContextSpecific((byte)0) || value.isContextSpecific((byte)1)) continue;
                throw new InvalidKeyException("Unexpected value: " + value);
            }
            AlgorithmParameters algParams = this.algid.getParameters();
            if (algParams == null) {
                throw new InvalidKeyException("EC domain parameters must be encoded in the algorithm identifier");
            }
            this.params = algParams.getParameterSpec(ECParameterSpec.class);
        }
        catch (IOException e) {
            throw new InvalidKeyException("Invalid EC private key", e);
        }
        catch (InvalidParameterSpecException e) {
            throw new InvalidKeyException("Invalid EC private key", e);
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        throw new InvalidObjectException("ECPrivateKeyImpl keys are not directly deserializable");
    }
}

