/*
 * Decompiled with CFR 0.152.
 */
package sun.swing;

import java.awt.Point;
import javax.swing.RepaintManager;
import javax.swing.TransferHandler;
import javax.swing.text.JTextComponent;
import sun.misc.Unsafe;
import sun.swing.JLightweightFrame;
import sun.swing.SwingUtilities2;

public final class SwingAccessor {
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static JTextComponentAccessor jtextComponentAccessor;
    private static JLightweightFrameAccessor jLightweightFrameAccessor;
    private static RepaintManagerAccessor repaintManagerAccessor;
    private static ThreadLocal<Boolean> tlObj;

    private SwingAccessor() {
    }

    public static void setJTextComponentAccessor(JTextComponentAccessor jtca) {
        jtextComponentAccessor = jtca;
    }

    public static JTextComponentAccessor getJTextComponentAccessor() {
        if (jtextComponentAccessor == null) {
            unsafe.ensureClassInitialized(JTextComponent.class);
        }
        return jtextComponentAccessor;
    }

    public static void setJLightweightFrameAccessor(JLightweightFrameAccessor accessor) {
        jLightweightFrameAccessor = accessor;
    }

    public static JLightweightFrameAccessor getJLightweightFrameAccessor() {
        if (jLightweightFrameAccessor == null) {
            unsafe.ensureClassInitialized(JLightweightFrame.class);
        }
        return jLightweightFrameAccessor;
    }

    public static void setRepaintManagerAccessor(RepaintManagerAccessor accessor) {
        repaintManagerAccessor = accessor;
    }

    public static RepaintManagerAccessor getRepaintManagerAccessor() {
        if (repaintManagerAccessor == null) {
            unsafe.ensureClassInitialized(RepaintManager.class);
        }
        return repaintManagerAccessor;
    }

    public static Boolean getAllowHTMLObject() {
        Boolean b = tlObj.get();
        if (b == null) {
            return Boolean.TRUE;
        }
        return b;
    }

    public static void setAllowHTMLObject(Boolean val) {
        tlObj.set(val);
    }

    static {
        tlObj = new ThreadLocal();
    }

    public static interface RepaintManagerAccessor {
        public void addRepaintListener(RepaintManager var1, SwingUtilities2.RepaintListener var2);

        public void removeRepaintListener(RepaintManager var1, SwingUtilities2.RepaintListener var2);
    }

    public static interface JLightweightFrameAccessor {
        public void updateCursor(JLightweightFrame var1);
    }

    public static interface JTextComponentAccessor {
        public TransferHandler.DropLocation dropLocationForPoint(JTextComponent var1, Point var2);

        public Object setDropLocation(JTextComponent var1, TransferHandler.DropLocation var2, Object var3, boolean var4);
    }
}

