/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.security.auth.x500.X500Principal;
import sun.security.provider.certpath.State;
import sun.security.provider.certpath.UntrustedChecker;
import sun.security.util.Debug;
import sun.security.x509.X509CertImpl;

class ForwardState
implements State {
    private static final Debug debug = Debug.getInstance("certpath");
    X500Principal issuerDN;
    X509CertImpl cert;
    int traversedCACerts;
    private boolean init = true;
    UntrustedChecker untrustedChecker;
    ArrayList<PKIXCertPathChecker> forwardCheckers;
    boolean selfIssued;

    ForwardState() {
    }

    @Override
    public boolean isInitial() {
        return this.init;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("State [");
        sb.append("\n  issuerDN of last cert: ").append(this.issuerDN);
        sb.append("\n  traversedCACerts: ").append(this.traversedCACerts);
        sb.append("\n  init: ").append(String.valueOf(this.init));
        sb.append("\n  selfIssued: ").append(String.valueOf(this.selfIssued));
        sb.append("]\n");
        return sb.toString();
    }

    public void initState(List<PKIXCertPathChecker> certPathCheckers) throws CertPathValidatorException {
        this.traversedCACerts = 0;
        this.forwardCheckers = new ArrayList();
        for (PKIXCertPathChecker checker : certPathCheckers) {
            if (!checker.isForwardCheckingSupported()) continue;
            checker.init(true);
            this.forwardCheckers.add(checker);
        }
        this.init = true;
    }

    @Override
    public void updateState(X509Certificate cert) throws CertificateException, IOException, CertPathValidatorException {
        X509CertImpl icert;
        if (cert == null) {
            return;
        }
        this.cert = icert = X509CertImpl.toImpl(cert);
        this.issuerDN = cert.getIssuerX500Principal();
        this.selfIssued = X509CertImpl.isSelfIssued(cert);
        if (!this.selfIssued && !this.init && cert.getBasicConstraints() != -1) {
            ++this.traversedCACerts;
        }
        this.init = false;
    }

    @Override
    public Object clone() {
        try {
            ForwardState clonedState = (ForwardState)super.clone();
            clonedState.forwardCheckers = (ArrayList)this.forwardCheckers.clone();
            ListIterator<PKIXCertPathChecker> li = clonedState.forwardCheckers.listIterator();
            while (li.hasNext()) {
                PKIXCertPathChecker checker = li.next();
                if (!(checker instanceof Cloneable)) continue;
                li.set((PKIXCertPathChecker)checker.clone());
            }
            return clonedState;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString(), e);
        }
    }
}

