/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.Timestamp;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import sun.misc.HexDumpEncoder;
import sun.security.pkcs.ContentInfo;
import sun.security.pkcs.PKCS7;
import sun.security.pkcs.PKCS9Attribute;
import sun.security.pkcs.PKCS9Attributes;
import sun.security.pkcs.ParsingException;
import sun.security.timestamp.TimestampToken;
import sun.security.util.Debug;
import sun.security.util.DerEncoder;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.DisabledAlgorithmConstraints;
import sun.security.util.JarConstraintsParameters;
import sun.security.util.ObjectIdentifier;
import sun.security.util.SignatureUtil;
import sun.security.x509.AlgorithmId;
import sun.security.x509.KeyUsageExtension;
import sun.security.x509.X500Name;

public class SignerInfo
implements DerEncoder {
    private static final DisabledAlgorithmConstraints JAR_DISABLED_CHECK = DisabledAlgorithmConstraints.jarConstraints();
    BigInteger version;
    X500Name issuerName;
    BigInteger certificateSerialNumber;
    AlgorithmId digestAlgorithmId;
    AlgorithmId digestEncryptionAlgorithmId;
    byte[] encryptedDigest;
    Timestamp timestamp;
    private boolean hasTimestamp = true;
    private static final Debug debug = Debug.getInstance("jar");
    PKCS9Attributes authenticatedAttributes;
    PKCS9Attributes unauthenticatedAttributes;
    private Map<AlgorithmId, AlgorithmInfo> algorithms = new HashMap<AlgorithmId, AlgorithmInfo>();

    public SignerInfo(X500Name issuerName, BigInteger serial, AlgorithmId digestAlgorithmId, AlgorithmId digestEncryptionAlgorithmId, byte[] encryptedDigest) {
        this.version = BigInteger.ONE;
        this.issuerName = issuerName;
        this.certificateSerialNumber = serial;
        this.digestAlgorithmId = digestAlgorithmId;
        this.digestEncryptionAlgorithmId = digestEncryptionAlgorithmId;
        this.encryptedDigest = encryptedDigest;
    }

    public SignerInfo(X500Name issuerName, BigInteger serial, AlgorithmId digestAlgorithmId, PKCS9Attributes authenticatedAttributes, AlgorithmId digestEncryptionAlgorithmId, byte[] encryptedDigest, PKCS9Attributes unauthenticatedAttributes) {
        this.version = BigInteger.ONE;
        this.issuerName = issuerName;
        this.certificateSerialNumber = serial;
        this.digestAlgorithmId = digestAlgorithmId;
        this.authenticatedAttributes = authenticatedAttributes;
        this.digestEncryptionAlgorithmId = digestEncryptionAlgorithmId;
        this.encryptedDigest = encryptedDigest;
        this.unauthenticatedAttributes = unauthenticatedAttributes;
    }

    public SignerInfo(DerInputStream derin) throws IOException, ParsingException {
        this(derin, false);
    }

    public SignerInfo(DerInputStream derin, boolean oldStyle) throws IOException, ParsingException {
        this.version = derin.getBigInteger();
        DerValue[] issuerAndSerialNumber = derin.getSequence(2);
        if (issuerAndSerialNumber.length != 2) {
            throw new ParsingException("Invalid length for IssuerAndSerialNumber");
        }
        byte[] issuerBytes = issuerAndSerialNumber[0].toByteArray();
        this.issuerName = new X500Name(new DerValue(48, issuerBytes));
        this.certificateSerialNumber = issuerAndSerialNumber[1].getBigInteger();
        DerValue tmp = derin.getDerValue();
        this.digestAlgorithmId = AlgorithmId.parse(tmp);
        if (oldStyle) {
            derin.getSet(0);
        } else if ((byte)derin.peekByte() == -96) {
            this.authenticatedAttributes = new PKCS9Attributes(derin);
        }
        tmp = derin.getDerValue();
        this.digestEncryptionAlgorithmId = AlgorithmId.parse(tmp);
        this.encryptedDigest = derin.getOctetString();
        if (oldStyle) {
            derin.getSet(0);
        } else if (derin.available() != 0 && (byte)derin.peekByte() == -95) {
            this.unauthenticatedAttributes = new PKCS9Attributes(derin, true);
        }
        if (derin.available() != 0) {
            throw new ParsingException("extra data at the end");
        }
    }

    public void encode(DerOutputStream out) throws IOException {
        this.derEncode(out);
    }

    @Override
    public void derEncode(OutputStream out) throws IOException {
        DerOutputStream seq = new DerOutputStream();
        seq.putInteger(this.version);
        DerOutputStream issuerAndSerialNumber = new DerOutputStream();
        this.issuerName.encode(issuerAndSerialNumber);
        issuerAndSerialNumber.putInteger(this.certificateSerialNumber);
        seq.write((byte)48, issuerAndSerialNumber);
        this.digestAlgorithmId.encode(seq);
        if (this.authenticatedAttributes != null) {
            this.authenticatedAttributes.encode((byte)-96, seq);
        }
        this.digestEncryptionAlgorithmId.encode(seq);
        seq.putOctetString(this.encryptedDigest);
        if (this.unauthenticatedAttributes != null) {
            this.unauthenticatedAttributes.encode((byte)-95, seq);
        }
        DerOutputStream tmp = new DerOutputStream();
        tmp.write((byte)48, seq);
        out.write(tmp.toByteArray());
    }

    public X509Certificate getCertificate(PKCS7 block) throws IOException {
        return block.getCertificate(this.certificateSerialNumber, this.issuerName);
    }

    public ArrayList<X509Certificate> getCertificateChain(PKCS7 block) throws IOException {
        boolean match;
        X509Certificate userCert = block.getCertificate(this.certificateSerialNumber, this.issuerName);
        if (userCert == null) {
            return null;
        }
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        certList.add(userCert);
        X509Certificate[] pkcsCerts = block.getCertificates();
        if (pkcsCerts == null || userCert.getSubjectDN().equals(userCert.getIssuerDN())) {
            return certList;
        }
        Principal issuer = userCert.getIssuerDN();
        int start = 0;
        block0: do {
            match = false;
            for (int i = start; i < pkcsCerts.length; ++i) {
                if (!issuer.equals(pkcsCerts[i].getSubjectDN())) continue;
                certList.add(pkcsCerts[i]);
                if (pkcsCerts[i].getSubjectDN().equals(pkcsCerts[i].getIssuerDN())) {
                    start = pkcsCerts.length;
                } else {
                    issuer = pkcsCerts[i].getIssuerDN();
                    X509Certificate tmpCert = pkcsCerts[start];
                    pkcsCerts[start] = pkcsCerts[i];
                    pkcsCerts[i] = tmpCert;
                    ++start;
                }
                match = true;
                continue block0;
            }
        } while (match);
        return certList;
    }

    SignerInfo verify(PKCS7 block, byte[] data) throws NoSuchAlgorithmException, SignatureException {
        try {
            byte[] dataSigned;
            Timestamp timestamp = this.getTimestamp();
            ContentInfo content = block.getContentInfo();
            if (data == null) {
                data = content.getContentBytes();
            }
            String digestAlgName = this.digestAlgorithmId.getName();
            this.algorithms.put(this.digestAlgorithmId, new AlgorithmInfo("SignerInfo digestAlgorithm field", false));
            if (this.authenticatedAttributes == null) {
                dataSigned = data;
            } else {
                ObjectIdentifier contentType = (ObjectIdentifier)this.authenticatedAttributes.getAttributeValue(PKCS9Attribute.CONTENT_TYPE_OID);
                if (contentType == null || !contentType.equals((Object)content.contentType)) {
                    return null;
                }
                byte[] messageDigest = (byte[])this.authenticatedAttributes.getAttributeValue(PKCS9Attribute.MESSAGE_DIGEST_OID);
                if (messageDigest == null) {
                    return null;
                }
                MessageDigest md = MessageDigest.getInstance(digestAlgName);
                byte[] computedMessageDigest = md.digest(data);
                if (!MessageDigest.isEqual(messageDigest, computedMessageDigest)) {
                    return null;
                }
                dataSigned = this.authenticatedAttributes.getDerEncoding();
            }
            String encryptionAlgName = this.getDigestEncryptionAlgorithmId().getName();
            String tmp = AlgorithmId.getEncAlgFromSigAlg(encryptionAlgName);
            if (tmp != null) {
                encryptionAlgName = tmp;
            }
            String sigAlgName = AlgorithmId.makeSigAlg(digestAlgName, encryptionAlgName);
            try {
                ObjectIdentifier oid = AlgorithmId.get(sigAlgName).getOID();
                AlgorithmId sigAlgId = new AlgorithmId(oid, this.digestEncryptionAlgorithmId.getParameters());
                this.algorithms.put(sigAlgId, new AlgorithmInfo("SignerInfo digestEncryptionAlgorithm field", true));
            }
            catch (NoSuchAlgorithmException oid) {
                // empty catch block
            }
            X509Certificate cert = this.getCertificate(block);
            if (cert == null) {
                return null;
            }
            PublicKey key = cert.getPublicKey();
            if (cert.hasUnsupportedCriticalExtension()) {
                throw new SignatureException("Certificate has unsupported critical extension(s)");
            }
            boolean[] keyUsageBits = cert.getKeyUsage();
            if (keyUsageBits != null) {
                KeyUsageExtension keyUsage;
                try {
                    keyUsage = new KeyUsageExtension(keyUsageBits);
                }
                catch (IOException ioe) {
                    throw new SignatureException("Failed to parse keyUsage extension");
                }
                boolean digSigAllowed = keyUsage.get("digital_signature");
                boolean nonRepuAllowed = keyUsage.get("non_repudiation");
                if (!digSigAllowed && !nonRepuAllowed) {
                    throw new SignatureException("Key usage restricted: cannot be used for digital signatures");
                }
            }
            Signature sig = Signature.getInstance(sigAlgName);
            AlgorithmParameters ap = this.digestEncryptionAlgorithmId.getParameters();
            try {
                SignatureUtil.initVerifyWithParam(sig, key, SignatureUtil.getParamSpec(sigAlgName, ap));
            }
            catch (InvalidAlgorithmParameterException | InvalidKeyException | ProviderException e) {
                throw new SignatureException(e.getMessage(), e);
            }
            sig.update(dataSigned);
            if (sig.verify(this.encryptedDigest)) {
                return this;
            }
        }
        catch (IOException | CertificateException e) {
            throw new SignatureException("Error verifying signature", e);
        }
        return null;
    }

    SignerInfo verify(PKCS7 block) throws NoSuchAlgorithmException, SignatureException {
        return this.verify(block, null);
    }

    public BigInteger getVersion() {
        return this.version;
    }

    public X500Name getIssuerName() {
        return this.issuerName;
    }

    public BigInteger getCertificateSerialNumber() {
        return this.certificateSerialNumber;
    }

    public AlgorithmId getDigestAlgorithmId() {
        return this.digestAlgorithmId;
    }

    public PKCS9Attributes getAuthenticatedAttributes() {
        return this.authenticatedAttributes;
    }

    public AlgorithmId getDigestEncryptionAlgorithmId() {
        return this.digestEncryptionAlgorithmId;
    }

    public byte[] getEncryptedDigest() {
        return this.encryptedDigest;
    }

    public PKCS9Attributes getUnauthenticatedAttributes() {
        return this.unauthenticatedAttributes;
    }

    public PKCS7 getTsToken() throws IOException {
        if (this.unauthenticatedAttributes == null) {
            return null;
        }
        PKCS9Attribute tsTokenAttr = this.unauthenticatedAttributes.getAttribute(PKCS9Attribute.SIGNATURE_TIMESTAMP_TOKEN_OID);
        if (tsTokenAttr == null) {
            return null;
        }
        return new PKCS7((byte[])tsTokenAttr.getValue());
    }

    public Timestamp getTimestamp() throws IOException, NoSuchAlgorithmException, SignatureException, CertificateException {
        if (this.timestamp != null || !this.hasTimestamp) {
            return this.timestamp;
        }
        PKCS7 tsToken = this.getTsToken();
        if (tsToken == null) {
            this.hasTimestamp = false;
            return null;
        }
        byte[] encTsTokenInfo = tsToken.getContentInfo().getData();
        SignerInfo[] tsa = tsToken.verify(encTsTokenInfo);
        if (tsa == null || tsa.length == 0) {
            throw new SignatureException("Unable to verify timestamp");
        }
        ArrayList<X509Certificate> chain = tsa[0].getCertificateChain(tsToken);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        CertPath tsaChain = cf.generateCertPath(chain);
        TimestampToken tsTokenInfo = new TimestampToken(encTsTokenInfo);
        this.verifyTimestamp(tsTokenInfo);
        this.algorithms.putAll(tsa[0].algorithms);
        this.timestamp = new Timestamp(tsTokenInfo.getDate(), tsaChain);
        return this.timestamp;
    }

    private void verifyTimestamp(TimestampToken token) throws NoSuchAlgorithmException, SignatureException {
        AlgorithmId digestAlgId = token.getHashAlgorithm();
        this.algorithms.put(digestAlgId, new AlgorithmInfo("TimestampToken digestAlgorithm field", false));
        MessageDigest md = MessageDigest.getInstance(digestAlgId.getName());
        if (!MessageDigest.isEqual(token.getHashedMessage(), md.digest(this.encryptedDigest))) {
            throw new SignatureException("Signature timestamp (#" + token.getSerialNumber() + ") generated on " + token.getDate() + " is inapplicable");
        }
        if (debug != null) {
            debug.println();
            debug.println("Detected signature timestamp (#" + token.getSerialNumber() + ") generated on " + token.getDate());
            debug.println();
        }
    }

    public String toString() {
        HexDumpEncoder hexDump = new HexDumpEncoder();
        String out = "";
        out = out + "Signer Info for (issuer): " + this.issuerName + "\n";
        out = out + "\tversion: " + Debug.toHexString(this.version) + "\n";
        out = out + "\tcertificateSerialNumber: " + Debug.toHexString(this.certificateSerialNumber) + "\n";
        out = out + "\tdigestAlgorithmId: " + this.digestAlgorithmId + "\n";
        if (this.authenticatedAttributes != null) {
            out = out + "\tauthenticatedAttributes: " + this.authenticatedAttributes + "\n";
        }
        out = out + "\tdigestEncryptionAlgorithmId: " + this.digestEncryptionAlgorithmId + "\n";
        out = out + "\tencryptedDigest: \n" + hexDump.encodeBuffer(this.encryptedDigest) + "\n";
        if (this.unauthenticatedAttributes != null) {
            out = out + "\tunauthenticatedAttributes: " + this.unauthenticatedAttributes + "\n";
        }
        return out;
    }

    public static Set<String> verifyAlgorithms(SignerInfo[] infos, JarConstraintsParameters params, String name) throws SignatureException {
        HashMap<AlgorithmId, AlgorithmInfo> algorithms = new HashMap<AlgorithmId, AlgorithmInfo>();
        for (SignerInfo signerInfo : infos) {
            algorithms.putAll(signerInfo.algorithms);
        }
        HashSet<String> enabledAlgorithms = new HashSet<String>();
        try {
            for (Map.Entry algEntry : algorithms.entrySet()) {
                AlgorithmInfo algorithmInfo = (AlgorithmInfo)algEntry.getValue();
                params.setExtendedExceptionMsg(name, algorithmInfo.field());
                AlgorithmId algId = (AlgorithmId)algEntry.getKey();
                JAR_DISABLED_CHECK.permits(algId.getName(), algId.getParameters(), params, algorithmInfo.checkKey());
                enabledAlgorithms.add(algId.getName());
            }
        }
        catch (CertPathValidatorException e) {
            throw new SignatureException(e);
        }
        return enabledAlgorithms;
    }

    private class AlgorithmInfo {
        String field;
        boolean checkKey;

        private AlgorithmInfo(String f, boolean cK) {
            this.field = f;
            this.checkKey = cK;
        }

        String field() {
            return this.field;
        }

        boolean checkKey() {
            return this.checkKey;
        }
    }
}

