/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5;

import java.io.IOException;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.Credentials;
import sun.security.krb5.KrbException;
import sun.security.krb5.KrbKdcRep;
import sun.security.krb5.KrbTgsReq;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.internal.EncTGSRepPart;
import sun.security.krb5.internal.KRBError;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.TGSRep;
import sun.security.krb5.internal.TGSReq;
import sun.security.krb5.internal.Ticket;
import sun.security.util.DerValue;

public class KrbTgsRep
extends KrbKdcRep {
    private TGSRep rep;
    private Credentials creds;
    private Ticket secondTicket;
    private static final boolean DEBUG = Krb5.DEBUG;

    KrbTgsRep(byte[] ibuf, KrbTgsReq tgsReq) throws KrbException, IOException {
        PrincipalName repSname;
        DerValue ref = new DerValue(ibuf);
        TGSReq req = tgsReq.getMessage();
        TGSRep rep = null;
        try {
            rep = new TGSRep(ref);
        }
        catch (Asn1Exception e) {
            rep = null;
            KRBError err = new KRBError(ref);
            String errStr = err.getErrorString();
            String eText = null;
            if (errStr != null && errStr.length() > 0) {
                eText = errStr.charAt(errStr.length() - 1) == '\u0000' ? errStr.substring(0, errStr.length() - 1) : errStr;
            }
            KrbException ke = eText == null ? new KrbException(err.getErrorCode()) : new KrbException(err.getErrorCode(), eText);
            ke.initCause(e);
            throw ke;
        }
        byte[] enc_tgs_rep_bytes = rep.encPart.decrypt(tgsReq.tgsReqKey, tgsReq.usedSubkey() ? 9 : 8);
        byte[] enc_tgs_rep_part = rep.encPart.reset(enc_tgs_rep_bytes);
        ref = new DerValue(enc_tgs_rep_part);
        EncTGSRepPart enc_part = new EncTGSRepPart(ref);
        rep.encKDCRepPart = enc_part;
        KrbTgsRep.check(false, req, rep, tgsReq.tgsReqKey);
        PrincipalName serverAlias = tgsReq.getServerAlias();
        if (serverAlias != null && (serverAlias.equals(repSname = enc_part.sname) || KrbTgsRep.isReferralSname(repSname))) {
            serverAlias = null;
        }
        PrincipalName clientAlias = null;
        if (rep.cname.equals(req.reqBody.cname)) {
            clientAlias = tgsReq.getClientAlias();
        }
        this.creds = new Credentials(rep.ticket, rep.cname, clientAlias, enc_part.sname, serverAlias, enc_part.key, enc_part.flags, enc_part.authtime, enc_part.starttime, enc_part.endtime, enc_part.renewTill, enc_part.caddr);
        this.rep = rep;
        this.secondTicket = tgsReq.getSecondTicket();
    }

    public Credentials getCreds() {
        return this.creds;
    }

    sun.security.krb5.internal.ccache.Credentials setCredentials() {
        return new sun.security.krb5.internal.ccache.Credentials(this.rep, this.secondTicket);
    }

    private static boolean isReferralSname(PrincipalName sname) {
        String[] snameStrings;
        return sname != null && (snameStrings = sname.getNameStrings()).length == 2 && snameStrings[0].equals("krbtgt");
    }
}

