/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.nio.channels.spi.SelectorProvider;
import java.security.AccessController;
import sun.nio.ch.PollSelectorProvider;
import sun.security.action.GetPropertyAction;

public class DefaultSelectorProvider {
    private DefaultSelectorProvider() {
    }

    private static SelectorProvider createProvider(String cn) {
        Class<?> c;
        try {
            c = Class.forName(cn);
        }
        catch (ClassNotFoundException x) {
            throw new AssertionError((Object)x);
        }
        try {
            return (SelectorProvider)c.newInstance();
        }
        catch (IllegalAccessException | InstantiationException x) {
            throw new AssertionError((Object)x);
        }
    }

    public static SelectorProvider create() {
        String osname = AccessController.doPrivileged(new GetPropertyAction("os.name"));
        if (osname.equals("SunOS")) {
            return DefaultSelectorProvider.createProvider("sun.nio.ch.DevPollSelectorProvider");
        }
        if (osname.equals("Linux")) {
            return DefaultSelectorProvider.createProvider("sun.nio.ch.EPollSelectorProvider");
        }
        return new PollSelectorProvider();
    }
}

