/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.xr;

import java.awt.AlphaComposite;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import sun.awt.SunToolkit;
import sun.awt.X11ComponentPeer;
import sun.font.FontManagerNativeLibrary;
import sun.java2d.InvalidPipeException;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.SurfaceDataProxy;
import sun.java2d.jules.JulesPathBuf;
import sun.java2d.jules.JulesShapePipe;
import sun.java2d.loops.CompositeType;
import sun.java2d.loops.MaskFill;
import sun.java2d.loops.RenderLoops;
import sun.java2d.loops.SurfaceType;
import sun.java2d.loops.XORComposite;
import sun.java2d.pipe.PixelToShapeConverter;
import sun.java2d.pipe.Region;
import sun.java2d.pipe.ShapeDrawPipe;
import sun.java2d.pipe.TextPipe;
import sun.java2d.pipe.ValidatePipe;
import sun.java2d.x11.XSurfaceData;
import sun.java2d.xr.XRBackend;
import sun.java2d.xr.XRCompositeManager;
import sun.java2d.xr.XRDrawImage;
import sun.java2d.xr.XRGraphicsConfig;
import sun.java2d.xr.XRMaskBlit;
import sun.java2d.xr.XRMaskFill;
import sun.java2d.xr.XRPMBlitLoops;
import sun.java2d.xr.XRPaints;
import sun.java2d.xr.XRRenderer;
import sun.java2d.xr.XRSurfaceDataProxy;
import sun.java2d.xr.XRUtils;

public abstract class XRSurfaceData
extends XSurfaceData {
    X11ComponentPeer peer;
    XRGraphicsConfig graphicsConfig;
    XRBackend renderQueue;
    private RenderLoops solidloops;
    protected int depth;
    public static final String DESC_BYTE_A8_X11 = "Byte A8 Pixmap";
    public static final String DESC_INT_RGB_X11 = "Integer RGB Pixmap";
    public static final String DESC_INT_ARGB_X11 = "Integer ARGB-Pre Pixmap";
    public static final SurfaceType ByteA8X11 = SurfaceType.ByteGray.deriveSubType("Byte A8 Pixmap");
    public static final SurfaceType IntRgbX11 = SurfaceType.IntRgb.deriveSubType("Integer RGB Pixmap");
    public static final SurfaceType IntArgbPreX11 = SurfaceType.IntArgbPre.deriveSubType("Integer ARGB-Pre Pixmap");
    protected XRRenderer xrpipe;
    protected PixelToShapeConverter xrtxpipe;
    protected TextPipe xrtextpipe;
    protected XRDrawImage xrDrawImage;
    protected ShapeDrawPipe aaShapePipe;
    protected PixelToShapeConverter aaPixelToShapeConv;
    private long xgc;
    private int validatedGCForegroundPixel = 0;
    private XORComposite validatedXorComp;
    private int xid;
    public int picture;
    public XRCompositeManager maskBuffer;
    private Region validatedClip;
    private Region validatedGCClip;
    private boolean validatedExposures = true;
    boolean transformInUse = false;
    AffineTransform validatedSourceTransform = new AffineTransform();
    AffineTransform staticSrcTx = null;
    int validatedRepeat = 0;
    int validatedFilter = 0;

    private static native void initIDs();

    protected native void XRInitSurface(int var1, int var2, int var3, long var4, int var6);

    native void initXRPicture(long var1, int var3);

    native void freeXSDOPicture(long var1);

    @Override
    public Raster getRaster(int x, int y, int w, int h) {
        throw new InternalError("not implemented yet");
    }

    public static void initXRSurfaceData() {
        if (!XRSurfaceData.isX11SurfaceDataInitialized()) {
            FontManagerNativeLibrary.load();
            XRSurfaceData.initIDs();
            XRPMBlitLoops.register();
            XRMaskFill.register();
            XRMaskBlit.register();
            XRSurfaceData.setX11SurfaceDataInitialized();
        }
    }

    protected boolean isXRDrawableValid() {
        try {
            SunToolkit.awtLock();
            boolean bl = this.isDrawableValid();
            return bl;
        }
        finally {
            SunToolkit.awtUnlock();
        }
    }

    @Override
    public SurfaceDataProxy makeProxyFor(SurfaceData srcData) {
        return XRSurfaceDataProxy.createProxy(srcData, this.graphicsConfig);
    }

    @Override
    public void validatePipe(SunGraphics2D sg2d) {
        boolean validated = false;
        TextPipe textpipe = this.getTextPipe(sg2d);
        if (textpipe == null) {
            super.validatePipe(sg2d);
            textpipe = sg2d.textpipe;
            validated = true;
        }
        PixelToShapeConverter txPipe = null;
        XRRenderer nonTxPipe = null;
        if (sg2d.antialiasHint != 2) {
            if (sg2d.paintState <= 1) {
                if (sg2d.compositeState <= 2) {
                    txPipe = this.xrtxpipe;
                    nonTxPipe = this.xrpipe;
                }
            } else if (sg2d.compositeState <= 1 && XRPaints.isValid(sg2d)) {
                txPipe = this.xrtxpipe;
                nonTxPipe = this.xrpipe;
            }
        }
        if (sg2d.antialiasHint == 2 && JulesPathBuf.isCairoAvailable()) {
            sg2d.shapepipe = this.aaShapePipe;
            sg2d.drawpipe = this.aaPixelToShapeConv;
            sg2d.fillpipe = this.aaPixelToShapeConv;
        } else if (txPipe != null) {
            if (sg2d.transformState >= 3) {
                sg2d.drawpipe = txPipe;
                sg2d.fillpipe = txPipe;
            } else if (sg2d.strokeState != 0) {
                sg2d.drawpipe = txPipe;
                sg2d.fillpipe = nonTxPipe;
            } else {
                sg2d.drawpipe = nonTxPipe;
                sg2d.fillpipe = nonTxPipe;
            }
            sg2d.shapepipe = nonTxPipe;
        } else if (!validated) {
            super.validatePipe(sg2d);
        }
        sg2d.textpipe = textpipe;
        sg2d.imagepipe = this.xrDrawImage;
    }

    protected TextPipe getTextPipe(SunGraphics2D sg2d) {
        boolean supportedPaint = sg2d.compositeState <= 1 && (sg2d.paintState <= 1 || sg2d.composite == null);
        boolean supportedCompOp = false;
        if (sg2d.composite instanceof AlphaComposite) {
            int compRule = ((AlphaComposite)sg2d.composite).getRule();
            supportedCompOp = XRUtils.isMaskEvaluated(XRUtils.j2dAlphaCompToXR(compRule)) || compRule == 2 && sg2d.paintState <= 1;
        }
        return supportedPaint && supportedCompOp ? this.xrtextpipe : null;
    }

    @Override
    protected MaskFill getMaskFill(SunGraphics2D sg2d) {
        AlphaComposite aComp = null;
        if (sg2d.composite != null && sg2d.composite instanceof AlphaComposite) {
            aComp = (AlphaComposite)sg2d.composite;
        }
        boolean supportedPaint = sg2d.paintState <= 1 || XRPaints.isValid(sg2d);
        boolean supportedCompOp = false;
        if (aComp != null) {
            int rule = aComp.getRule();
            supportedCompOp = XRUtils.isMaskEvaluated(XRUtils.j2dAlphaCompToXR(rule));
        }
        return supportedPaint && supportedCompOp ? super.getMaskFill(sg2d) : null;
    }

    @Override
    public RenderLoops getRenderLoops(SunGraphics2D sg2d) {
        if (sg2d.paintState <= 1 && sg2d.compositeState <= 1) {
            return this.solidloops;
        }
        return super.getRenderLoops(sg2d);
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return this.graphicsConfig;
    }

    public static XRWindowSurfaceData createData(X11ComponentPeer peer) {
        XRGraphicsConfig gc = XRSurfaceData.getGC(peer);
        return new XRWindowSurfaceData(peer, gc, gc.getSurfaceType());
    }

    public static XRPixmapSurfaceData createData(XRGraphicsConfig gc, int width, int height, ColorModel cm, Image image, long drawable, int transparency, boolean isTexture) {
        int depth;
        if (gc.getColorModel().getPixelSize() == 32) {
            depth = 32;
            transparency = 3;
        } else {
            depth = transparency > 1 ? 32 : 24;
        }
        cm = depth == 24 ? new DirectColorModel(depth, 0xFF0000, 65280, 255) : new DirectColorModel(depth, 0xFF0000, 65280, 255, -16777216);
        return new XRPixmapSurfaceData(gc, width, height, image, XRSurfaceData.getSurfaceType(gc, transparency), cm, drawable, transparency, XRUtils.getPictureFormatForTransparency(transparency), depth, isTexture);
    }

    protected XRSurfaceData(X11ComponentPeer peer, XRGraphicsConfig gc, SurfaceType sType, ColorModel cm, int depth, int transparency) {
        super(sType, cm);
        this.peer = peer;
        this.graphicsConfig = gc;
        this.solidloops = this.graphicsConfig.getSolidLoops(sType);
        this.depth = depth;
        this.initOps(peer, this.graphicsConfig, depth);
        this.setBlitProxyKey(gc.getProxyKey());
    }

    protected XRSurfaceData(XRBackend renderQueue) {
        super(IntRgbX11, new DirectColorModel(24, 0xFF0000, 65280, 255));
        this.renderQueue = renderQueue;
    }

    public void initXRender(int pictureFormat) {
        try {
            SunToolkit.awtLock();
            this.initXRPicture(this.getNativeOps(), pictureFormat);
            this.renderQueue = XRCompositeManager.getInstance(this).getBackend();
            this.maskBuffer = XRCompositeManager.getInstance(this);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        finally {
            SunToolkit.awtUnlock();
        }
    }

    public static XRGraphicsConfig getGC(X11ComponentPeer peer) {
        if (peer != null) {
            return (XRGraphicsConfig)peer.getGraphicsConfiguration();
        }
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = env.getDefaultScreenDevice();
        return (XRGraphicsConfig)gd.getDefaultConfiguration();
    }

    public abstract boolean canSourceSendExposures(int var1, int var2, int var3, int var4);

    public void validateCopyAreaGC(Region gcClip, boolean needExposures) {
        if (this.validatedGCClip != gcClip) {
            if (gcClip != null) {
                this.renderQueue.setGCClipRectangles(this.xgc, gcClip);
            }
            this.validatedGCClip = gcClip;
        }
        if (this.validatedExposures != needExposures) {
            this.validatedExposures = needExposures;
            this.renderQueue.setGCExposures(this.xgc, needExposures);
        }
        if (this.validatedXorComp != null) {
            this.renderQueue.setGCMode(this.xgc, true);
            this.renderQueue.setGCForeground(this.xgc, this.validatedGCForegroundPixel);
            this.validatedXorComp = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean copyArea(SunGraphics2D sg2d, int x, int y, int w, int h, int dx, int dy) {
        if (this.xrpipe == null) {
            if (!this.isXRDrawableValid()) {
                return true;
            }
            this.makePipes();
        }
        CompositeType comptype = sg2d.imageComp;
        if (sg2d.transformState < 3 && (CompositeType.SrcOverNoEa.equals(comptype) || CompositeType.SrcNoEa.equals(comptype))) {
            x += sg2d.transX;
            y += sg2d.transY;
            try {
                SunToolkit.awtLock();
                boolean needExposures = this.canSourceSendExposures(x, y, w, h);
                this.validateCopyAreaGC(sg2d.getCompClip(), needExposures);
                this.renderQueue.copyArea(this.xid, this.xid, this.xgc, x, y, w, h, x + dx, y + dy);
            }
            finally {
                SunToolkit.awtUnlock();
            }
            return true;
        }
        return false;
    }

    public static SurfaceType getSurfaceType(XRGraphicsConfig gc, int transparency) {
        SurfaceType sType = null;
        switch (transparency) {
            case 1: {
                sType = IntRgbX11;
                break;
            }
            case 2: 
            case 3: {
                sType = IntArgbPreX11;
            }
        }
        return sType;
    }

    @Override
    public void invalidate() {
        if (this.isValid()) {
            this.setInvalid();
            super.invalidate();
        }
    }

    void validateAsSource(AffineTransform sxForm, int repeat, int filter) {
        if (this.validatedClip != null) {
            this.validatedClip = null;
            this.renderQueue.setClipRectangles(this.picture, null);
        }
        if (this.validatedRepeat != repeat && repeat != -1) {
            this.validatedRepeat = repeat;
            this.renderQueue.setPictureRepeat(this.picture, repeat);
        }
        if (sxForm == null) {
            if (this.transformInUse) {
                this.validatedSourceTransform.setToIdentity();
                this.renderQueue.setPictureTransform(this.picture, this.validatedSourceTransform);
                this.transformInUse = false;
            }
        } else if (!this.transformInUse || this.transformInUse && !sxForm.equals(this.validatedSourceTransform)) {
            this.validatedSourceTransform.setTransform(sxForm.getScaleX(), sxForm.getShearY(), sxForm.getShearX(), sxForm.getScaleY(), sxForm.getTranslateX(), sxForm.getTranslateY());
            AffineTransform srcTransform = this.validatedSourceTransform;
            if (this.staticSrcTx != null) {
                srcTransform = new AffineTransform(this.validatedSourceTransform);
                srcTransform.preConcatenate(this.staticSrcTx);
            }
            this.renderQueue.setPictureTransform(this.picture, srcTransform);
            this.transformInUse = true;
        }
        if (filter != this.validatedFilter && filter != -1) {
            this.renderQueue.setFilter(this.picture, filter);
            this.validatedFilter = filter;
        }
    }

    public void validateAsDestination(SunGraphics2D sg2d, Region clip) {
        if (!this.isValid()) {
            throw new InvalidPipeException("bounds changed");
        }
        boolean updateGCClip = false;
        if (clip != this.validatedClip) {
            this.renderQueue.setClipRectangles(this.picture, clip);
            this.validatedClip = clip;
            updateGCClip = true;
        }
        if (sg2d != null && sg2d.compositeState == 2) {
            int pixel;
            if (this.validatedXorComp != sg2d.getComposite()) {
                this.validatedXorComp = (XORComposite)sg2d.getComposite();
                this.renderQueue.setGCMode(this.xgc, false);
            }
            if (this.validatedGCForegroundPixel != (pixel = sg2d.pixel)) {
                int xorpixelmod = this.validatedXorComp.getXorPixel();
                this.renderQueue.setGCForeground(this.xgc, pixel ^ xorpixelmod);
                this.validatedGCForegroundPixel = pixel;
            }
            if (updateGCClip) {
                this.renderQueue.setGCClipRectangles(this.xgc, clip);
            }
        }
    }

    public synchronized void makePipes() {
        if (this.xrpipe == null) {
            try {
                SunToolkit.awtLock();
                this.xgc = XRSurfaceData.XCreateGC(this.getNativeOps());
                this.xrpipe = new XRRenderer(this.maskBuffer.getMaskBuffer());
                this.xrtxpipe = new PixelToShapeConverter(this.xrpipe);
                this.xrtextpipe = this.maskBuffer.getTextRenderer();
                this.xrDrawImage = new XRDrawImage();
                if (JulesPathBuf.isCairoAvailable()) {
                    this.aaShapePipe = new JulesShapePipe(XRCompositeManager.getInstance(this));
                    this.aaPixelToShapeConv = new PixelToShapeConverter(this.aaShapePipe);
                }
            }
            finally {
                SunToolkit.awtUnlock();
            }
        }
    }

    public long getGC() {
        return this.xgc;
    }

    public int getPicture() {
        return this.picture;
    }

    public int getXid() {
        return this.xid;
    }

    public XRGraphicsConfig getGraphicsConfig() {
        return this.graphicsConfig;
    }

    public void setStaticSrcTx(AffineTransform staticSrcTx) {
        this.staticSrcTx = staticSrcTx;
    }

    public static class LazyPipe
    extends ValidatePipe {
        @Override
        public boolean validate(SunGraphics2D sg2d) {
            XRSurfaceData xsd = (XRSurfaceData)sg2d.surfaceData;
            if (!xsd.isXRDrawableValid()) {
                return false;
            }
            xsd.makePipes();
            return super.validate(sg2d);
        }
    }

    public static class XRPixmapSurfaceData
    extends XRSurfaceData {
        Image offscreenImage;
        int width;
        int height;
        int transparency;
        private final int scale;

        public XRPixmapSurfaceData(XRGraphicsConfig gc, int width, int height, Image image, SurfaceType sType, ColorModel cm, long drawable, int transparency, int pictFormat, int depth, boolean isTexture) {
            super(null, gc, sType, cm, depth, transparency);
            this.scale = isTexture ? 1 : gc.getDevice().getScaleFactor();
            this.width = width * this.scale;
            this.height = height * this.scale;
            this.offscreenImage = image;
            this.transparency = transparency;
            this.initSurface(depth, this.width, this.height, drawable, pictFormat);
            this.initXRender(pictFormat);
            this.makePipes();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void initSurface(int depth, int width, int height, long drawable, int pictFormat) {
            try {
                SunToolkit.awtLock();
                this.XRInitSurface(depth, width, height, drawable, pictFormat);
            }
            finally {
                SunToolkit.awtUnlock();
            }
        }

        @Override
        public SurfaceData getReplacement() {
            return XRPixmapSurfaceData.restoreContents(this.offscreenImage);
        }

        @Override
        public int getTransparency() {
            return this.transparency;
        }

        @Override
        public Rectangle getBounds() {
            return new Rectangle(this.width, this.height);
        }

        @Override
        public boolean canSourceSendExposures(int x, int y, int w, int h) {
            return x < 0 || y < 0 || x + w > this.width || y + h > this.height;
        }

        @Override
        public void flush() {
            this.invalidate();
            this.flushNativeSurface();
        }

        @Override
        public Object getDestination() {
            return this.offscreenImage;
        }

        @Override
        public double getDefaultScaleX() {
            return this.scale;
        }

        @Override
        public double getDefaultScaleY() {
            return this.scale;
        }
    }

    public static class XRInternalSurfaceData
    extends XRSurfaceData {
        public XRInternalSurfaceData(XRBackend renderQueue, int pictXid) {
            super(renderQueue);
            this.picture = pictXid;
            this.transformInUse = false;
        }

        @Override
        public boolean canSourceSendExposures(int x, int y, int w, int h) {
            return false;
        }

        @Override
        public Rectangle getBounds() {
            return null;
        }

        @Override
        public Object getDestination() {
            return null;
        }

        @Override
        public SurfaceData getReplacement() {
            return null;
        }
    }

    public static class XRWindowSurfaceData
    extends XRSurfaceData {
        protected final int scale;

        public XRWindowSurfaceData(X11ComponentPeer peer, XRGraphicsConfig gc, SurfaceType sType) {
            super(peer, gc, sType, peer.getColorModel(), peer.getColorModel().getPixelSize(), 1);
            this.scale = gc.getScale();
            if (this.isXRDrawableValid()) {
                this.initXRender(XRUtils.getPictureFormatForTransparency(1));
                this.makePipes();
            }
        }

        @Override
        public SurfaceData getReplacement() {
            return this.peer.getSurfaceData();
        }

        @Override
        public Rectangle getBounds() {
            Rectangle r = this.peer.getBounds();
            r.y = 0;
            r.x = 0;
            r.width *= this.scale;
            r.height *= this.scale;
            return r;
        }

        @Override
        public boolean canSourceSendExposures(int x, int y, int w, int h) {
            return true;
        }

        @Override
        public Object getDestination() {
            return this.peer.getTarget();
        }

        @Override
        public void invalidate() {
            try {
                SunToolkit.awtLock();
                this.freeXSDOPicture(this.getNativeOps());
            }
            finally {
                SunToolkit.awtUnlock();
            }
            super.invalidate();
        }

        @Override
        public double getDefaultScaleX() {
            return this.scale;
        }

        @Override
        public double getDefaultScaleY() {
            return this.scale;
        }
    }
}

