/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.xr;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.font.XRTextRenderer;
import sun.java2d.SunGraphics2D;
import sun.java2d.jules.TrapezoidList;
import sun.java2d.loops.XORComposite;
import sun.java2d.xr.GrowableEltArray;
import sun.java2d.xr.GrowableRectArray;
import sun.java2d.xr.MaskTileManager;
import sun.java2d.xr.XRBackend;
import sun.java2d.xr.XRBackendNative;
import sun.java2d.xr.XRColor;
import sun.java2d.xr.XRMaskImage;
import sun.java2d.xr.XRPaints;
import sun.java2d.xr.XRSolidSrcPict;
import sun.java2d.xr.XRSurfaceData;
import sun.java2d.xr.XRUtils;

public class XRCompositeManager {
    private static boolean enableGradCache = true;
    private static XRCompositeManager instance;
    private static final int SOLID = 0;
    private static final int TEXTURE = 1;
    private static final int GRADIENT = 2;
    int srcType;
    XRSolidSrcPict solidSrc32;
    XRSurfaceData texture;
    XRSurfaceData gradient;
    int alphaMask = 0;
    XRColor solidColor = new XRColor();
    float extraAlpha = 1.0f;
    byte compRule = (byte)3;
    XRColor alphaColor = new XRColor();
    XRSurfaceData solidSrcPict;
    int alphaMaskPict;
    int gradCachePixmap;
    int gradCachePicture;
    boolean xorEnabled = false;
    int validatedPixel = 0;
    Composite validatedComp;
    Paint validatedPaint;
    float validatedExtraAlpha = 1.0f;
    XRBackend con = new XRBackendNative();
    MaskTileManager maskBuffer;
    XRTextRenderer textRenderer;
    XRMaskImage maskImage;

    public static synchronized XRCompositeManager getInstance(XRSurfaceData surface) {
        if (instance == null) {
            instance = new XRCompositeManager(surface);
        }
        return instance;
    }

    private XRCompositeManager(XRSurfaceData surface) {
        String gradProp = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("sun.java2d.xrgradcache");
            }
        });
        enableGradCache = gradProp == null || !gradProp.equalsIgnoreCase("false") && !gradProp.equalsIgnoreCase("f");
        XRPaints.register(this);
        this.initResources(surface);
        this.maskBuffer = new MaskTileManager(this, surface.getXid());
        this.textRenderer = new XRTextRenderer(this);
        this.maskImage = new XRMaskImage(this, surface.getXid());
    }

    public void initResources(XRSurfaceData surface) {
        int parentXid = surface.getXid();
        this.solidSrc32 = new XRSolidSrcPict(this.con, parentXid);
        this.setForeground(0);
        int extraAlphaMask = this.con.createPixmap(parentXid, 8, 1, 1);
        this.alphaMaskPict = this.con.createPicture(extraAlphaMask, 2);
        this.con.setPictureRepeat(this.alphaMaskPict, 1);
        this.con.renderRectangle(this.alphaMaskPict, (byte)0, XRColor.NO_ALPHA, 0, 0, 1, 1);
        if (enableGradCache) {
            this.gradCachePixmap = this.con.createPixmap(parentXid, 32, 256, 256);
            this.gradCachePicture = this.con.createPicture(this.gradCachePixmap, 0);
        }
    }

    public void setForeground(int pixel) {
        this.solidColor.setColorValues(pixel, true);
    }

    public void setGradientPaint(XRSurfaceData gradient) {
        if (this.gradient != null) {
            this.con.freePicture(this.gradient.picture);
        }
        this.gradient = gradient;
        this.srcType = 2;
    }

    public void setTexturePaint(XRSurfaceData texture) {
        this.texture = texture;
        this.srcType = 1;
    }

    public void XRResetPaint() {
        this.srcType = 0;
    }

    public void validateCompositeState(Composite comp, AffineTransform xform, Paint paint, SunGraphics2D sg2d) {
        boolean updatePaint;
        boolean bl = updatePaint = paint != this.validatedPaint || paint == null;
        if (comp != this.validatedComp) {
            if (comp != null) {
                this.setComposite(comp);
            } else {
                comp = AlphaComposite.getInstance(3);
                this.setComposite(comp);
            }
            updatePaint = true;
            this.validatedComp = comp;
        }
        if (sg2d != null && (this.validatedPixel != sg2d.pixel || updatePaint)) {
            this.validatedPixel = sg2d.pixel;
            this.setForeground(this.validatedPixel);
        }
        if (updatePaint) {
            if (paint != null && sg2d != null && sg2d.paintState >= 2) {
                XRPaints.setPaint(sg2d, paint);
            } else {
                this.XRResetPaint();
            }
            this.validatedPaint = paint;
        }
        if (this.srcType != 0) {
            AffineTransform at = (AffineTransform)xform.clone();
            try {
                at.invert();
            }
            catch (NoninvertibleTransformException e) {
                at.setToIdentity();
            }
            this.getCurrentSource().validateAsSource(at, -1, XRUtils.ATransOpToXRQuality(sg2d.interpolationType));
        }
    }

    private void setComposite(Composite comp) {
        if (comp instanceof AlphaComposite) {
            AlphaComposite aComp = (AlphaComposite)comp;
            this.validatedExtraAlpha = aComp.getAlpha();
            this.compRule = XRUtils.j2dAlphaCompToXR(aComp.getRule());
            this.extraAlpha = this.validatedExtraAlpha;
            if (this.extraAlpha == 1.0f) {
                this.alphaMask = 0;
                this.alphaColor.alpha = XRColor.FULL_ALPHA.alpha;
            } else {
                this.alphaColor.alpha = XRColor.byteToXRColorValue((int)(this.extraAlpha * 255.0f));
                this.alphaMask = this.alphaMaskPict;
                this.con.renderRectangle(this.alphaMaskPict, (byte)1, this.alphaColor, 0, 0, 1, 1);
            }
            this.xorEnabled = false;
        } else if (comp instanceof XORComposite) {
            this.xorEnabled = true;
        } else {
            throw new InternalError("Composite accaleration not implemented for: " + comp.getClass().getName());
        }
    }

    public boolean maskRequired() {
        return !this.xorEnabled && (this.srcType != 0 || this.srcType == 0 && this.solidColor.alpha != 65535 || this.extraAlpha != 1.0f);
    }

    public void XRComposite(int src, int mask, int dst, int srcX, int srcY, int maskX, int maskY, int dstX, int dstY, int width, int height) {
        int cachedSrc = src == 0 ? this.getCurrentSource().picture : src;
        int cachedX = srcX;
        int cachedY = srcY;
        if (enableGradCache && this.gradient != null && cachedSrc == this.gradient.picture) {
            this.con.renderComposite((byte)1, this.gradient.picture, 0, this.gradCachePicture, srcX, srcY, 0, 0, 0, 0, width, height);
            cachedX = 0;
            cachedY = 0;
            cachedSrc = this.gradCachePicture;
        }
        this.con.renderComposite(this.compRule, cachedSrc, mask, dst, cachedX, cachedY, maskX, maskY, dstX, dstY, width, height);
    }

    public void XRCompositeTraps(int dst, int srcX, int srcY, TrapezoidList trapList) {
        int renderReferenceX = 0;
        int renderReferenceY = 0;
        if (trapList.getP1YLeft(0) < trapList.getP2YLeft(0)) {
            renderReferenceX = trapList.getP1XLeft(0);
            renderReferenceY = trapList.getP1YLeft(0);
        } else {
            renderReferenceX = trapList.getP2XLeft(0);
            renderReferenceY = trapList.getP2YLeft(0);
        }
        renderReferenceX = (int)Math.floor(XRUtils.XFixedToDouble(renderReferenceX));
        renderReferenceY = (int)Math.floor(XRUtils.XFixedToDouble(renderReferenceY));
        this.con.renderCompositeTrapezoids(this.compRule, this.getCurrentSource().picture, 2, dst, renderReferenceX, renderReferenceY, trapList);
    }

    public void XRRenderRectangles(XRSurfaceData dst, GrowableRectArray rects) {
        if (this.xorEnabled) {
            this.con.GCRectangles(dst.getXid(), dst.getGC(), rects);
        } else if (rects.getSize() == 1) {
            this.con.renderRectangle(dst.getPicture(), this.compRule, this.solidColor, rects.getX(0), rects.getY(0), rects.getWidth(0), rects.getHeight(0));
        } else {
            this.con.renderRectangles(dst.getPicture(), this.compRule, this.solidColor, rects);
        }
    }

    public void XRCompositeRectangles(XRSurfaceData dst, GrowableRectArray rects) {
        int srcPict = this.getCurrentSource().picture;
        for (int i = 0; i < rects.getSize(); ++i) {
            int x = rects.getX(i);
            int y = rects.getY(i);
            int width = rects.getWidth(i);
            int height = rects.getHeight(i);
            this.con.renderComposite(this.compRule, srcPict, 0, dst.picture, x, y, 0, 0, x, y, width, height);
        }
    }

    protected XRSurfaceData getCurrentSource() {
        switch (this.srcType) {
            case 0: {
                return this.solidSrc32.prepareSrcPict(this.validatedPixel);
            }
            case 1: {
                return this.texture;
            }
            case 2: {
                return this.gradient;
            }
        }
        return null;
    }

    public void compositeBlit(XRSurfaceData src, XRSurfaceData dst, int sx, int sy, int dx, int dy, int w, int h) {
        this.con.renderComposite(this.compRule, src.picture, this.alphaMask, dst.picture, sx, sy, 0, 0, dx, dy, w, h);
    }

    public void compositeText(XRSurfaceData dst, int sx, int sy, int glyphSet, int maskFormat, GrowableEltArray elts) {
        byte textCompRule = this.compRule != 1 ? (byte)this.compRule : (byte)3;
        this.con.XRenderCompositeText(textCompRule, this.getCurrentSource().picture, dst.picture, maskFormat, sx, sy, 0, 0, glyphSet, elts);
    }

    public XRColor getMaskColor() {
        return !this.isTexturePaintActive() ? XRColor.FULL_ALPHA : this.getAlphaColor();
    }

    public int getExtraAlphaMask() {
        return this.alphaMask;
    }

    public boolean isTexturePaintActive() {
        return this.srcType == 1;
    }

    public boolean isSolidPaintActive() {
        return this.srcType == 0;
    }

    public XRColor getAlphaColor() {
        return this.alphaColor;
    }

    public XRBackend getBackend() {
        return this.con;
    }

    public float getExtraAlpha() {
        return this.validatedExtraAlpha;
    }

    public byte getCompRule() {
        return this.compRule;
    }

    public XRTextRenderer getTextRenderer() {
        return this.textRenderer;
    }

    public MaskTileManager getMaskBuffer() {
        return this.maskBuffer;
    }

    public XRMaskImage getMaskImage() {
        return this.maskImage;
    }
}

