/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.marlin;

import sun.java2d.marlin.FloatMath;
import sun.java2d.marlin.MarlinCache;
import sun.java2d.marlin.MarlinConst;
import sun.java2d.marlin.MarlinRenderingEngine;
import sun.java2d.marlin.MarlinUtils;
import sun.java2d.marlin.OffHeapArray;
import sun.java2d.marlin.Renderer;
import sun.java2d.marlin.RendererContext;
import sun.java2d.pipe.AATileGenerator;
import sun.misc.Unsafe;

final class MarlinTileGenerator
implements AATileGenerator,
MarlinConst {
    private static final int MAX_TILE_ALPHA_SUM = TILE_SIZE * TILE_SIZE * MAX_AA_ALPHA;
    private final Renderer rdr;
    private final MarlinCache cache;
    private int x;
    private int y;

    MarlinTileGenerator(Renderer r) {
        this.rdr = r;
        this.cache = r.cache;
    }

    MarlinTileGenerator init() {
        this.x = this.cache.bboxX0;
        this.y = this.cache.bboxY0;
        return this;
    }

    @Override
    public void dispose() {
        this.cache.dispose();
        this.rdr.dispose();
        MarlinRenderingEngine.returnRendererContext(this.rdr.rdrCtx);
    }

    void getBbox(int[] bbox) {
        bbox[0] = this.cache.bboxX0;
        bbox[1] = this.cache.bboxY0;
        bbox[2] = this.cache.bboxX1;
        bbox[3] = this.cache.bboxY1;
    }

    @Override
    public int getTileWidth() {
        return TILE_SIZE;
    }

    @Override
    public int getTileHeight() {
        return TILE_SIZE;
    }

    @Override
    public int getTypicalAlpha() {
        int alpha;
        int al = this.cache.alphaSumInTile(this.x);
        int n = al == 0 ? 0 : (alpha = al == MAX_TILE_ALPHA_SUM ? 255 : 128);
        if (doStats) {
            RendererContext.stats.hist_tile_generator_alpha.add(alpha);
        }
        return alpha;
    }

    @Override
    public void nextTile() {
        if ((this.x += TILE_SIZE) >= this.cache.bboxX1) {
            this.x = this.cache.bboxX0;
            this.y += TILE_SIZE;
            if (this.y < this.cache.bboxY1) {
                this.rdr.endRendering(this.y);
            }
        }
    }

    @Override
    public void getAlpha(byte[] tile, int offset, int rowstride) {
        if (this.cache.useRLE) {
            this.getAlphaRLE(tile, offset, rowstride);
        } else {
            this.getAlphaNoRLE(tile, offset, rowstride);
        }
    }

    private void getAlphaNoRLE(byte[] tile, int offset, int rowstride) {
        MarlinCache _cache = this.cache;
        long[] rowAAChunkIndex = _cache.rowAAChunkIndex;
        int[] rowAAx0 = _cache.rowAAx0;
        int[] rowAAx1 = _cache.rowAAx1;
        int x0 = this.x;
        int x1 = FloatMath.min(x0 + TILE_SIZE, _cache.bboxX1);
        boolean y0 = false;
        int y1 = FloatMath.min(this.y + TILE_SIZE, _cache.bboxY1) - this.y;
        if (doLogBounds) {
            MarlinUtils.logInfo("getAlpha = [" + x0 + " ... " + x1 + "[ [" + 0 + " ... " + y1 + "[");
        }
        Unsafe _unsafe = OffHeapArray.unsafe;
        long SIZE = 1L;
        long addr_rowAA = _cache.rowAAChunk.address;
        int skipRowPixels = rowstride - (x1 - x0);
        int idx = offset;
        for (int cy = 0; cy < y1; ++cy) {
            int aax0;
            int cx = x0;
            int aax1 = rowAAx1[cy];
            if (aax1 > x0 && (aax0 = rowAAx0[cy]) < x1) {
                int end;
                cx = aax0;
                if (cx <= x0) {
                    cx = x0;
                } else {
                    for (end = x0; end < cx; ++end) {
                        tile[idx++] = 0;
                    }
                }
                long addr = addr_rowAA + rowAAChunkIndex[cy] + (long)(cx - aax0);
                int n = end = aax1 <= x1 ? aax1 : x1;
                while (cx < end) {
                    tile[idx++] = _unsafe.getByte(addr);
                    ++addr;
                    ++cx;
                }
            }
            while (cx < x1) {
                tile[idx++] = 0;
                ++cx;
            }
            if (doTrace) {
                for (int i = idx - (x1 - x0); i < idx; ++i) {
                    System.out.print(MarlinTileGenerator.hex(tile[i], 2));
                }
                System.out.println();
            }
            idx += skipRowPixels;
        }
        this.nextTile();
    }

    private void getAlphaRLE(byte[] tile, int offset, int rowstride) {
        MarlinCache _cache = this.cache;
        long[] rowAAChunkIndex = _cache.rowAAChunkIndex;
        int[] rowAAx0 = _cache.rowAAx0;
        int[] rowAAx1 = _cache.rowAAx1;
        int[] rowAAEnc = _cache.rowAAEnc;
        long[] rowAALen = _cache.rowAALen;
        long[] rowAAPos = _cache.rowAAPos;
        int x0 = this.x;
        int x1 = FloatMath.min(x0 + TILE_SIZE, _cache.bboxX1);
        boolean y0 = false;
        int y1 = FloatMath.min(this.y + TILE_SIZE, _cache.bboxY1) - this.y;
        if (doLogBounds) {
            MarlinUtils.logInfo("getAlpha = [" + x0 + " ... " + x1 + "[ [" + 0 + " ... " + y1 + "[");
        }
        Unsafe _unsafe = OffHeapArray.unsafe;
        long SIZE_BYTE = 1L;
        long SIZE_INT = 4L;
        long addr_rowAA = _cache.rowAAChunk.address;
        int skipRowPixels = rowstride - (x1 - x0);
        int idx = offset;
        for (int cy = 0; cy < y1; ++cy) {
            int i;
            long addr;
            int cx = x0;
            if (rowAAEnc[cy] == 0) {
                int aax0;
                int aax1 = rowAAx1[cy];
                if (aax1 > x0 && (aax0 = rowAAx0[cy]) < x1) {
                    int end;
                    cx = aax0;
                    if (cx <= x0) {
                        cx = x0;
                    } else {
                        for (end = x0; end < cx; ++end) {
                            tile[idx++] = 0;
                        }
                    }
                    addr = addr_rowAA + rowAAChunkIndex[cy] + (long)(cx - aax0);
                    int n = end = aax1 <= x1 ? aax1 : x1;
                    while (cx < end) {
                        tile[idx++] = _unsafe.getByte(addr);
                        ++addr;
                        ++cx;
                    }
                }
            } else if (rowAAx1[cy] > x0) {
                cx = rowAAx0[cy];
                if (cx > x1) {
                    cx = x1;
                }
                for (i = x0; i < cx; ++i) {
                    tile[idx++] = 0;
                }
                long addr_row = addr_rowAA + rowAAChunkIndex[cy];
                long addr_end = addr_row + rowAALen[cy];
                addr = addr_row + rowAAPos[cy];
                long last_addr = 0L;
                while (cx < x1 && addr < addr_end) {
                    int runLen;
                    int rx1;
                    last_addr = addr;
                    int packed = _unsafe.getInt(addr);
                    int cx1 = packed >> 8;
                    addr += 4L;
                    int rx0 = cx;
                    if (rx0 < x0) {
                        rx0 = x0;
                    }
                    if ((rx1 = (cx = cx1)) > x1) {
                        rx1 = x1;
                        cx = x1;
                    }
                    if ((runLen = rx1 - rx0) <= 0) continue;
                    byte val = (byte)(packed & 0xFF);
                    do {
                        tile[idx++] = val;
                    } while (--runLen > 0);
                }
                if (last_addr != 0L) {
                    rowAAx0[cy] = cx;
                    rowAAPos[cy] = last_addr - addr_row;
                }
            }
            while (cx < x1) {
                tile[idx++] = 0;
                ++cx;
            }
            if (doTrace) {
                for (i = idx - (x1 - x0); i < idx; ++i) {
                    System.out.print(MarlinTileGenerator.hex(tile[i], 2));
                }
                System.out.println();
            }
            idx += skipRowPixels;
        }
        this.nextTile();
    }

    static String hex(int v, int d) {
        String s = Integer.toHexString(v);
        while (s.length() < d) {
            s = "0" + s;
        }
        return s.substring(0, d);
    }
}

