/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.marlin;

import java.util.ArrayDeque;
import java.util.Arrays;
import sun.java2d.marlin.MarlinConst;
import sun.java2d.marlin.MarlinUtils;

final class IntArrayCache
implements MarlinConst {
    private final int arraySize;
    private final ArrayDeque<int[]> intArrays;
    private int getOp = 0;
    private int createOp = 0;
    private int returnOp = 0;

    void dumpStats() {
        if (this.getOp > 0) {
            MarlinUtils.logInfo("IntArrayCache[" + this.arraySize + "]: get: " + this.getOp + " created: " + this.createOp + " - returned: " + this.returnOp + " :: cache size: " + this.intArrays.size());
        }
    }

    IntArrayCache(int arraySize) {
        this.arraySize = arraySize;
        this.intArrays = new ArrayDeque(6);
    }

    int[] getArray() {
        int[] array;
        if (doStats) {
            ++this.getOp;
        }
        if ((array = this.intArrays.pollLast()) != null) {
            return array;
        }
        if (doStats) {
            ++this.createOp;
        }
        return new int[this.arraySize];
    }

    void putDirtyArray(int[] array, int length) {
        if (length != this.arraySize) {
            if (doChecks) {
                MarlinUtils.logInfo("ArrayCache: bad length = " + length);
            }
            return;
        }
        if (doStats) {
            ++this.returnOp;
        }
        this.intArrays.addLast(array);
    }

    void putArray(int[] array, int length, int fromIndex, int toIndex) {
        if (length != this.arraySize) {
            if (doChecks) {
                MarlinUtils.logInfo("ArrayCache: bad length = " + length);
            }
            return;
        }
        if (doStats) {
            ++this.returnOp;
        }
        IntArrayCache.fill(array, fromIndex, toIndex, 0);
        this.intArrays.addLast(array);
    }

    static void fill(int[] array, int fromIndex, int toIndex, int value) {
        if (toIndex != 0) {
            Arrays.fill(array, fromIndex, toIndex, value);
        }
        if (doChecks) {
            IntArrayCache.check(array, fromIndex, toIndex, value);
        }
    }

    static void check(int[] array, int fromIndex, int toIndex, int value) {
        if (doChecks) {
            for (int i = 0; i < array.length; ++i) {
                if (array[i] == value) continue;
                MarlinUtils.logException("Invalid value at: " + i + " = " + array[i] + " from: " + fromIndex + " to: " + toIndex + "\n" + Arrays.toString(array), new Throwable());
                Arrays.fill(array, value);
                return;
            }
        }
    }
}

