/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.marlin;

import java.util.ArrayDeque;
import java.util.Arrays;
import sun.java2d.marlin.MarlinConst;
import sun.java2d.marlin.MarlinUtils;

final class FloatArrayCache
implements MarlinConst {
    private final int arraySize;
    private final ArrayDeque<float[]> floatArrays;
    private int getOp = 0;
    private int createOp = 0;
    private int returnOp = 0;

    void dumpStats() {
        if (this.getOp > 0) {
            MarlinUtils.logInfo("FloatArrayCache[" + this.arraySize + "]: get: " + this.getOp + " created: " + this.createOp + " - returned: " + this.returnOp + " :: cache size: " + this.floatArrays.size());
        }
    }

    FloatArrayCache(int arraySize) {
        this.arraySize = arraySize;
        this.floatArrays = new ArrayDeque(6);
    }

    float[] getArray() {
        float[] array;
        if (doStats) {
            ++this.getOp;
        }
        if ((array = this.floatArrays.pollLast()) != null) {
            return array;
        }
        if (doStats) {
            ++this.createOp;
        }
        return new float[this.arraySize];
    }

    void putDirtyArray(float[] array, int length) {
        if (length != this.arraySize) {
            if (doChecks) {
                MarlinUtils.logInfo("ArrayCache: bad length = " + length);
            }
            return;
        }
        if (doStats) {
            ++this.returnOp;
        }
        this.floatArrays.addLast(array);
    }

    void putArray(float[] array, int length, int fromIndex, int toIndex) {
        if (length != this.arraySize) {
            if (doChecks) {
                MarlinUtils.logInfo("ArrayCache: bad length = " + length);
            }
            return;
        }
        if (doStats) {
            ++this.returnOp;
        }
        FloatArrayCache.fill(array, fromIndex, toIndex, 0.0f);
        this.floatArrays.addLast(array);
    }

    static void fill(float[] array, int fromIndex, int toIndex, float value) {
        if (toIndex != 0) {
            Arrays.fill(array, fromIndex, toIndex, value);
        }
        if (doChecks) {
            FloatArrayCache.check(array, fromIndex, toIndex, value);
        }
    }

    static void check(float[] array, int fromIndex, int toIndex, float value) {
        if (doChecks) {
            for (int i = 0; i < array.length; ++i) {
                if (array[i] == value) continue;
                MarlinUtils.logException("Invalid value at: " + i + " = " + array[i] + " from: " + fromIndex + " to: " + toIndex + "\n" + Arrays.toString(array), new Throwable());
                Arrays.fill(array, value);
                return;
            }
        }
    }
}

