/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.geom.Dimension2D;
import java.awt.image.ImageObserver;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import sun.awt.image.AbstractMultiResolutionImage;
import sun.awt.image.ImageCache;
import sun.awt.image.ToolkitImage;

public class MultiResolutionCachedImage
extends AbstractMultiResolutionImage {
    private final int baseImageWidth;
    private final int baseImageHeight;
    private final Dimension2D[] sizes;
    private final BiFunction<Integer, Integer, Image> mapper;
    private int availableInfo;

    public MultiResolutionCachedImage(int baseImageWidth, int baseImageHeight, BiFunction<Integer, Integer, Image> mapper) {
        this(baseImageWidth, baseImageHeight, new Dimension[]{new Dimension(baseImageWidth, baseImageHeight)}, mapper);
    }

    public MultiResolutionCachedImage(int baseImageWidth, int baseImageHeight, Dimension2D[] sizes, BiFunction<Integer, Integer, Image> mapper) {
        this.baseImageWidth = baseImageWidth;
        this.baseImageHeight = baseImageHeight;
        this.sizes = sizes == null ? null : Arrays.copyOf(sizes, sizes.length);
        this.mapper = mapper;
    }

    @Override
    public Image getResolutionVariant(double destWidth, double destHeight) {
        MultiResolutionCachedImage.checkSize(destWidth, destHeight);
        int width = (int)Math.ceil(destWidth);
        int height = (int)Math.ceil(destHeight);
        ImageCache cache = ImageCache.getInstance();
        ImageCacheKey key = new ImageCacheKey(this, width, height);
        Image resolutionVariant = cache.getImage(key);
        if (resolutionVariant == null) {
            resolutionVariant = this.mapper.apply(width, height);
            cache.setImage(key, resolutionVariant);
        }
        MultiResolutionCachedImage.preload(resolutionVariant, this.availableInfo);
        return resolutionVariant;
    }

    private static void checkSize(double width, double height) {
        if (width <= 0.0 || height <= 0.0) {
            throw new IllegalArgumentException(String.format("Width (%s) or height (%s) cannot be <= 0", width, height));
        }
        if (!Double.isFinite(width) || !Double.isFinite(height)) {
            throw new IllegalArgumentException(String.format("Width (%s) or height (%s) is not finite", width, height));
        }
    }

    @Override
    public List<Image> getResolutionVariants() {
        return Arrays.stream(this.sizes).map((? super T size) -> this.getResolutionVariant(size.getWidth(), size.getHeight())).collect(Collectors.toList());
    }

    public MultiResolutionCachedImage map(Function<Image, Image> mapper) {
        return new MultiResolutionCachedImage(this.baseImageWidth, this.baseImageHeight, this.sizes, (width, height) -> (Image)mapper.apply(this.getResolutionVariant(width.intValue(), height.intValue())));
    }

    @Override
    public int getWidth(ImageObserver observer) {
        this.updateInfo(observer, 1);
        return this.baseImageWidth;
    }

    @Override
    public int getHeight(ImageObserver observer) {
        this.updateInfo(observer, 2);
        return this.baseImageHeight;
    }

    @Override
    public Object getProperty(String name, ImageObserver observer) {
        this.updateInfo(observer, 4);
        return Image.UndefinedProperty;
    }

    @Override
    public Image getScaledInstance(int width, int height, int hints) {
        return this.getResolutionVariant(width, height);
    }

    @Override
    protected Image getBaseImage() {
        return this.getResolutionVariant(this.baseImageWidth, this.baseImageHeight);
    }

    private void updateInfo(ImageObserver observer, int info) {
        this.availableInfo |= observer == null ? 32 : info;
    }

    private static int getInfo(Image image) {
        if (image instanceof ToolkitImage) {
            return ((ToolkitImage)image).getImageRep().check((img, infoflags, x, y, w, h) -> false);
        }
        return 0;
    }

    private static void preload(Image image, final int availableInfo) {
        if (availableInfo != 0 && image instanceof ToolkitImage) {
            ((ToolkitImage)image).preload(new ImageObserver(){
                int flags;
                {
                    this.flags = availableInfo;
                }

                @Override
                public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
                    this.flags &= ~infoflags;
                    return this.flags != 0 && (infoflags & 0xC0) == 0;
                }
            });
        }
    }

    private static class ImageCacheKey
    implements ImageCache.PixelsKey {
        private final int pixelCount;
        private final int hash;
        private final int w;
        private final int h;
        private final Image baseImage;

        ImageCacheKey(Image baseImage, int w, int h) {
            this.baseImage = baseImage;
            this.w = w;
            this.h = h;
            this.pixelCount = w * h;
            this.hash = this.hash();
        }

        @Override
        public int getPixelCount() {
            return this.pixelCount;
        }

        private int hash() {
            int hash = this.baseImage.hashCode();
            hash = 31 * hash + this.w;
            hash = 31 * hash + this.h;
            return hash;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ImageCacheKey) {
                ImageCacheKey key = (ImageCacheKey)obj;
                return this.baseImage == key.baseImage && this.w == key.w && this.h == key.h;
            }
            return false;
        }
    }
}

