/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.peer.PopupMenuPeer;
import java.util.Vector;
import sun.awt.AWTAccessor;
import sun.awt.X11.XComponentPeer;
import sun.awt.X11.XEvent;
import sun.awt.X11.XKeyEvent;
import sun.awt.X11.XMenuPeer;
import sun.awt.X11.XMenuWindow;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindow;
import sun.util.logging.PlatformLogger;

public class XPopupMenuPeer
extends XMenuWindow
implements PopupMenuPeer {
    private static PlatformLogger log = PlatformLogger.getLogger("sun.awt.X11.XBaseMenuWindow");
    private XComponentPeer componentPeer;
    private PopupMenu popupMenuTarget;
    private XMenuPeer showingMousePressedSubmenu = null;
    private static final int CAPTION_MARGIN_TOP = 4;
    private static final int CAPTION_SEPARATOR_HEIGHT = 6;

    XPopupMenuPeer(PopupMenu target) {
        super((XMenuPeer)null);
        this.popupMenuTarget = target;
    }

    @Override
    public void setFont(Font f) {
        this.resetMapping();
        this.setItemsFont(f);
        this.postPaintEvent();
    }

    @Override
    public void setLabel(String label) {
        this.resetMapping();
        this.postPaintEvent();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.postPaintEvent();
    }

    public void enable() {
        this.setEnabled(true);
    }

    public void disable() {
        this.setEnabled(false);
    }

    @Override
    public void addSeparator() {
        if (log.isLoggable(PlatformLogger.Level.FINER)) {
            log.finer("addSeparator is not implemented");
        }
    }

    @Override
    public void show(Event e) {
        this.target = (Component)e.target;
        Vector targetItemVector = this.getMenuTargetItems();
        if (targetItemVector != null) {
            this.reloadItems(targetItemVector);
            Point tl = this.target.getLocationOnScreen();
            Point pt = new Point(tl.x + e.x, tl.y + e.y);
            if (!this.ensureCreated()) {
                return;
            }
            Dimension dim = this.getDesiredSize();
            Rectangle bounds = this.getWindowBounds(pt, dim);
            this.reshape(bounds);
            this.xSetVisible(true);
            this.toFront();
            this.selectItem(null, false);
            this.grabInput();
        }
    }

    Font getTargetFont() {
        if (this.popupMenuTarget == null) {
            return XWindow.getDefaultFont();
        }
        return AWTAccessor.getMenuComponentAccessor().getFont_NoClientCode(this.popupMenuTarget);
    }

    String getTargetLabel() {
        if (this.target == null) {
            return "";
        }
        return AWTAccessor.getMenuItemAccessor().getLabel(this.popupMenuTarget);
    }

    boolean isTargetEnabled() {
        if (this.popupMenuTarget == null) {
            return false;
        }
        return AWTAccessor.getMenuItemAccessor().isEnabled(this.popupMenuTarget);
    }

    @Override
    Vector getMenuTargetItems() {
        if (this.popupMenuTarget == null) {
            return null;
        }
        return AWTAccessor.getMenuAccessor().getItems(this.popupMenuTarget);
    }

    protected Rectangle getWindowBounds(Point origin, Dimension windowSize) {
        Rectangle globalBounds = new Rectangle(origin.x, origin.y, 0, 0);
        Dimension screenSize = this.graphicsConfig.getBounds().getSize();
        Rectangle res = this.fitWindowRight(globalBounds, windowSize, screenSize);
        if (res != null) {
            return res;
        }
        res = this.fitWindowLeft(globalBounds, windowSize, screenSize);
        if (res != null) {
            return res;
        }
        res = this.fitWindowBelow(globalBounds, windowSize, screenSize);
        if (res != null) {
            return res;
        }
        res = this.fitWindowAbove(globalBounds, windowSize, screenSize);
        if (res != null) {
            return res;
        }
        return this.fitWindowToScreen(windowSize, screenSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Dimension getCaptionSize() {
        String s = this.getTargetLabel();
        if (s.equals("")) {
            return null;
        }
        Graphics g = this.getGraphics();
        if (g == null) {
            return null;
        }
        try {
            Dimension textDimension;
            g.setFont(this.getTargetFont());
            FontMetrics fm = g.getFontMetrics();
            String str = this.getTargetLabel();
            int width = fm.stringWidth(str);
            int height = 4 + fm.getHeight() + 6;
            Dimension dimension = textDimension = new Dimension(width, height);
            return dimension;
        }
        finally {
            g.dispose();
        }
    }

    @Override
    protected void paintCaption(Graphics g, Rectangle rect) {
        String s = this.getTargetLabel();
        if (s.equals("")) {
            return;
        }
        g.setFont(this.getTargetFont());
        FontMetrics fm = g.getFontMetrics();
        String str = this.getTargetLabel();
        int width = fm.stringWidth(str);
        int textx = rect.x + (rect.width - width) / 2;
        int texty = rect.y + 4 + fm.getAscent();
        int sepy = rect.y + rect.height - 3;
        g.setColor(this.isTargetEnabled() ? this.getForegroundColor() : this.getDisabledColor());
        g.drawString(s, textx, texty);
        this.draw3DRect(g, rect.x, sepy, rect.width, 2, false);
    }

    @Override
    protected void doDispose() {
        super.doDispose();
        XToolkit.targetDisposedPeer(this.popupMenuTarget, this);
    }

    @Override
    protected void handleEvent(AWTEvent event) {
        switch (event.getID()) {
            case 500: 
            case 501: 
            case 502: 
            case 503: 
            case 504: 
            case 505: 
            case 506: {
                this.doHandleJavaMouseEvent((MouseEvent)event);
                break;
            }
            case 401: 
            case 402: {
                this.doHandleJavaKeyEvent((KeyEvent)event);
                break;
            }
            default: {
                super.handleEvent(event);
            }
        }
    }

    @Override
    void ungrabInputImpl() {
        this.hide();
    }

    @Override
    public void handleKeyPress(XEvent xev) {
        XKeyEvent xkey = xev.get_xkey();
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine(xkey.toString());
        }
        if (this.isEventDisabled(xev)) {
            return;
        }
        Component currentSource = this.getEventSource();
        this.handleKeyPress(xkey);
    }
}

