/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.util.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.InvalidPropertiesFormatException;
import java.util.Map;
import java.util.Properties;
import jdk.internal.org.xml.sax.Attributes;
import jdk.internal.org.xml.sax.InputSource;
import jdk.internal.org.xml.sax.SAXException;
import jdk.internal.org.xml.sax.SAXParseException;
import jdk.internal.org.xml.sax.helpers.DefaultHandler;
import jdk.internal.util.xml.SAXParser;
import jdk.internal.util.xml.XMLStreamException;
import jdk.internal.util.xml.impl.SAXParserImpl;
import jdk.internal.util.xml.impl.XMLStreamWriterImpl;

public class PropertiesDefaultHandler
extends DefaultHandler {
    private static final String ELEMENT_ROOT = "properties";
    private static final String ELEMENT_COMMENT = "comment";
    private static final String ELEMENT_ENTRY = "entry";
    private static final String ATTR_KEY = "key";
    private static final String PROPS_DTD_DECL = "<!DOCTYPE properties SYSTEM \"http://java.sun.com/dtd/properties.dtd\">";
    private static final String PROPS_DTD_URI = "http://java.sun.com/dtd/properties.dtd";
    private static final String PROPS_DTD = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!-- DTD for properties --><!ELEMENT properties ( comment?, entry* ) ><!ATTLIST properties version CDATA #FIXED \"1.0\"><!ELEMENT comment (#PCDATA) ><!ELEMENT entry (#PCDATA) ><!ATTLIST entry  key CDATA #REQUIRED>";
    private static final String EXTERNAL_XML_VERSION = "1.0";
    private Properties properties;
    static final String ALLOWED_ELEMENTS = "properties, comment, entry";
    static final String ALLOWED_COMMENT = "comment";
    StringBuffer buf = new StringBuffer();
    boolean sawComment = false;
    boolean validEntry = false;
    int rootElem = 0;
    String key;
    String rootElm;

    public void load(Properties props, InputStream in) throws IOException, InvalidPropertiesFormatException, UnsupportedEncodingException {
        this.properties = props;
        try {
            SAXParserImpl parser = new SAXParserImpl();
            ((SAXParser)parser).parse(in, (DefaultHandler)this);
        }
        catch (SAXException saxe) {
            throw new InvalidPropertiesFormatException(saxe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(Properties props, OutputStream os, String comment, String encoding) throws IOException {
        try {
            XMLStreamWriterImpl writer = new XMLStreamWriterImpl(os, encoding);
            writer.writeStartDocument();
            writer.writeDTD(PROPS_DTD_DECL);
            writer.writeStartElement(ELEMENT_ROOT);
            if (comment != null && comment.length() > 0) {
                writer.writeStartElement("comment");
                writer.writeCharacters(comment);
                writer.writeEndElement();
            }
            Properties properties = props;
            synchronized (properties) {
                for (Map.Entry e : props.entrySet()) {
                    Object k = e.getKey();
                    Object v = e.getValue();
                    if (!(k instanceof String) || !(v instanceof String)) continue;
                    writer.writeStartElement(ELEMENT_ENTRY);
                    writer.writeAttribute(ATTR_KEY, (String)k);
                    writer.writeCharacters((String)v);
                    writer.writeEndElement();
                }
            }
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.close();
        }
        catch (XMLStreamException e) {
            if (e.getCause() instanceof UnsupportedEncodingException) {
                throw (UnsupportedEncodingException)e.getCause();
            }
            throw new IOException(e);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.rootElem < 2) {
            ++this.rootElem;
        }
        if (this.rootElm == null) {
            this.fatalError(new SAXParseException("An XML properties document must contain the DOCTYPE declaration as defined by java.util.Properties.", null));
        }
        if (this.rootElem == 1 && !this.rootElm.equals(qName)) {
            this.fatalError(new SAXParseException("Document root element \"" + qName + "\", must match DOCTYPE root \"" + this.rootElm + "\"", null));
        }
        if (!ALLOWED_ELEMENTS.contains(qName)) {
            this.fatalError(new SAXParseException("Element type \"" + qName + "\" must be declared.", null));
        }
        if (qName.equals(ELEMENT_ENTRY)) {
            this.validEntry = true;
            this.key = attributes.getValue(ATTR_KEY);
            if (this.key == null) {
                this.fatalError(new SAXParseException("Attribute \"key\" is required and must be specified for element type \"entry\"", null));
            }
        } else if (qName.equals("comment")) {
            if (this.sawComment) {
                this.fatalError(new SAXParseException("Only one comment element may be allowed. The content of element type \"properties\" must match \"(comment?,entry*)\"", null));
            }
            this.sawComment = true;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.validEntry) {
            this.buf.append(ch, start, length);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (!ALLOWED_ELEMENTS.contains(qName)) {
            this.fatalError(new SAXParseException("Element: " + qName + " is invalid, must match  \"(comment?,entry*)\".", null));
        }
        if (this.validEntry) {
            this.properties.setProperty(this.key, this.buf.toString());
            this.buf.delete(0, this.buf.length());
            this.validEntry = false;
        }
    }

    @Override
    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
        this.rootElm = name;
    }

    @Override
    public InputSource resolveEntity(String pubid, String sysid) throws SAXException, IOException {
        if (sysid.equals(PROPS_DTD_URI)) {
            InputSource is = new InputSource(new StringReader(PROPS_DTD));
            is.setSystemId(PROPS_DTD_URI);
            return is;
        }
        throw new SAXException("Invalid system identifier: " + sysid);
    }

    @Override
    public void error(SAXParseException x) throws SAXException {
        throw x;
    }

    @Override
    public void fatalError(SAXParseException x) throws SAXException {
        throw x;
    }

    @Override
    public void warning(SAXParseException x) throws SAXException {
        throw x;
    }
}

