/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;

public class DeflaterOutputStream
extends FilterOutputStream {
    static final int DEFAULT_BUF_SIZE = 512;
    private static final int SYNC_FLUSH_MIN_BUF_SIZE = 7;
    protected Deflater def;
    protected byte[] buf;
    private boolean closed = false;
    private final boolean syncFlush;
    boolean usesDefaultDeflater = false;

    public DeflaterOutputStream(OutputStream out, Deflater def, int size, boolean syncFlush) {
        super(out);
        if (out == null || def == null) {
            throw new NullPointerException();
        }
        if (size <= 0) {
            throw new IllegalArgumentException("buffer size <= 0");
        }
        this.def = def;
        this.buf = new byte[size];
        this.syncFlush = syncFlush;
    }

    public DeflaterOutputStream(OutputStream out, Deflater def, int size) {
        this(out, def, size, false);
    }

    public DeflaterOutputStream(OutputStream out, Deflater def, boolean syncFlush) {
        this(out, def, 512, syncFlush);
    }

    public DeflaterOutputStream(OutputStream out, Deflater def) {
        this(out, def, 512, false);
    }

    public DeflaterOutputStream(OutputStream out, boolean syncFlush) {
        this(out, new Deflater(), 512, syncFlush);
        this.usesDefaultDeflater = true;
    }

    public DeflaterOutputStream(OutputStream out) {
        this(out, false);
        this.usesDefaultDeflater = true;
    }

    @Override
    public void write(int b) throws IOException {
        byte[] buf = new byte[]{(byte)(b & 0xFF)};
        this.write(buf, 0, 1);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.def.finished()) {
            throw new IOException("write beyond end of stream");
        }
        if ((off | len | off + len | b.length - (off + len)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        if (!this.def.finished()) {
            this.def.setInput(b, off, len);
            while (!this.def.needsInput()) {
                this.deflate();
            }
        }
    }

    public void finish() throws IOException {
        if (!this.def.finished()) {
            try {
                this.def.finish();
                while (!this.def.finished()) {
                    this.deflate();
                }
            }
            catch (IOException e) {
                if (this.usesDefaultDeflater) {
                    this.def.end();
                }
                throw e;
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            try {
                this.finish();
            }
            finally {
                if (this.usesDefaultDeflater) {
                    this.def.end();
                }
            }
            this.out.close();
            this.closed = true;
        }
    }

    protected void deflate() throws IOException {
        int len = this.def.deflate(this.buf, 0, this.buf.length);
        if (len > 0) {
            this.out.write(this.buf, 0, len);
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.syncFlush && !this.def.finished()) {
            byte[] flushBuf;
            int len = 0;
            byte[] byArray = flushBuf = this.buf.length < 7 ? new byte[512] : this.buf;
            while ((len = this.def.deflate(flushBuf, 0, flushBuf.length, 2)) > 0) {
                this.out.write(flushBuf, 0, len);
                if (len >= flushBuf.length) continue;
            }
        }
        this.out.flush();
    }
}

