/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.nio.ByteBuffer;
import java.util.zip.Checksum;
import sun.nio.ch.DirectBuffer;

public class Adler32
implements Checksum {
    private int adler = 1;

    @Override
    public void update(int b) {
        this.adler = Adler32.update(this.adler, b);
    }

    @Override
    public void update(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.adler = Adler32.updateBytes(this.adler, b, off, len);
    }

    public void update(byte[] b) {
        this.adler = Adler32.updateBytes(this.adler, b, 0, b.length);
    }

    public void update(ByteBuffer buffer) {
        int pos = buffer.position();
        int limit = buffer.limit();
        assert (pos <= limit);
        int rem = limit - pos;
        if (rem <= 0) {
            return;
        }
        if (buffer instanceof DirectBuffer) {
            this.adler = Adler32.updateByteBuffer(this.adler, ((DirectBuffer)((Object)buffer)).address(), pos, rem);
        } else if (buffer.hasArray()) {
            this.adler = Adler32.updateBytes(this.adler, buffer.array(), pos + buffer.arrayOffset(), rem);
        } else {
            byte[] b = new byte[rem];
            buffer.get(b);
            this.adler = Adler32.updateBytes(this.adler, b, 0, b.length);
        }
        buffer.position(limit);
    }

    @Override
    public void reset() {
        this.adler = 1;
    }

    @Override
    public long getValue() {
        return (long)this.adler & 0xFFFFFFFFL;
    }

    private static native int update(int var0, int var1);

    private static native int updateBytes(int var0, byte[] var1, int var2, int var3);

    private static native int updateByteBuffer(int var0, long var1, int var3, int var4);
}

