/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.MemberName;
import java.lang.invoke.MethodHandleInfo;
import java.lang.invoke.MethodHandleNatives;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;

final class InfoFromMemberName
implements MethodHandleInfo {
    private final MemberName member;
    private final int referenceKind;

    InfoFromMemberName(MethodHandles.Lookup lookup, MemberName member, byte referenceKind) {
        assert (member.isResolved() || member.isMethodHandleInvoke());
        assert (member.referenceKindIsConsistentWith(referenceKind));
        this.member = member;
        this.referenceKind = referenceKind;
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.member.getDeclaringClass();
    }

    @Override
    public String getName() {
        return this.member.getName();
    }

    @Override
    public MethodType getMethodType() {
        return this.member.getMethodOrFieldType();
    }

    @Override
    public int getModifiers() {
        return this.member.getModifiers();
    }

    @Override
    public int getReferenceKind() {
        return this.referenceKind;
    }

    public String toString() {
        return MethodHandleInfo.toString(this.getReferenceKind(), this.getDeclaringClass(), this.getName(), this.getMethodType());
    }

    @Override
    public <T extends Member> T reflectAs(Class<T> expected, MethodHandles.Lookup lookup) {
        if (this.member.isMethodHandleInvoke() && !this.member.isVarargs()) {
            throw new IllegalArgumentException("cannot reflect signature polymorphic method");
        }
        Member mem = AccessController.doPrivileged(new PrivilegedAction<Member>(){

            @Override
            public Member run() {
                try {
                    return InfoFromMemberName.this.reflectUnchecked();
                }
                catch (ReflectiveOperationException ex) {
                    throw new IllegalArgumentException(ex);
                }
            }
        });
        try {
            Class<?> defc = this.getDeclaringClass();
            byte refKind = (byte)this.getReferenceKind();
            lookup.checkAccess(refKind, defc, InfoFromMemberName.convertToMemberName(refKind, mem));
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException(ex);
        }
        return (T)((Member)expected.cast(mem));
    }

    private Member reflectUnchecked() throws ReflectiveOperationException {
        byte refKind = (byte)this.getReferenceKind();
        Class<?> defc = this.getDeclaringClass();
        boolean isPublic = Modifier.isPublic(this.getModifiers());
        if (MethodHandleNatives.refKindIsMethod(refKind)) {
            if (isPublic) {
                return defc.getMethod(this.getName(), this.getMethodType().parameterArray());
            }
            return defc.getDeclaredMethod(this.getName(), this.getMethodType().parameterArray());
        }
        if (MethodHandleNatives.refKindIsConstructor(refKind)) {
            if (isPublic) {
                return defc.getConstructor(this.getMethodType().parameterArray());
            }
            return defc.getDeclaredConstructor(this.getMethodType().parameterArray());
        }
        if (MethodHandleNatives.refKindIsField(refKind)) {
            if (isPublic) {
                return defc.getField(this.getName());
            }
            return defc.getDeclaredField(this.getName());
        }
        throw new IllegalArgumentException("referenceKind=" + refKind);
    }

    private static MemberName convertToMemberName(byte refKind, Member mem) throws IllegalAccessException {
        if (mem instanceof Method) {
            boolean wantSpecial = refKind == 7;
            return new MemberName((Method)mem, wantSpecial);
        }
        if (mem instanceof Constructor) {
            return new MemberName((Constructor)mem);
        }
        if (mem instanceof Field) {
            boolean isSetter = refKind == 3 || refKind == 4;
            return new MemberName((Field)mem, isSetter);
        }
        throw new InternalError(mem.getClass().getName());
    }
}

