/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import sun.misc.Unsafe;

public abstract class ClassValue<T> {
    private static final Entry<?>[] EMPTY_CACHE = new Entry[]{null};
    final int hashCodeForCache = nextHashCode.getAndAdd(1640531527) & 0x3FFFFFFF;
    private static final AtomicInteger nextHashCode = new AtomicInteger();
    private static final int HASH_INCREMENT = 1640531527;
    static final int HASH_MASK = 0x3FFFFFFF;
    final Identity identity = new Identity();
    private volatile Version<T> version = new Version(this);
    private static final Object CRITICAL_SECTION = new Object();
    private static final Unsafe UNSAFE = Unsafe.getUnsafe();

    protected ClassValue() {
    }

    protected abstract T computeValue(Class<?> var1);

    public T get(Class<?> type) {
        Entry<?>[] cache = ClassValue.getCacheCarefully(type);
        Entry e = ClassValueMap.probeHomeLocation(cache, this);
        if (this.match(e)) {
            return e.value();
        }
        return this.getFromBackup(cache, type);
    }

    public void remove(Class<?> type) {
        ClassValueMap map = ClassValue.getMap(type);
        map.removeEntry(this);
    }

    void put(Class<?> type, T value) {
        ClassValueMap map = ClassValue.getMap(type);
        map.changeEntry(this, value);
    }

    private static Entry<?>[] getCacheCarefully(Class<?> type) {
        ClassValueMap map = type.classValueMap;
        if (map == null) {
            return EMPTY_CACHE;
        }
        Entry<?>[] cache = map.getCache();
        return cache;
    }

    private T getFromBackup(Entry<?>[] cache, Class<?> type) {
        Entry e = ClassValueMap.probeBackupLocations(cache, this);
        if (e != null) {
            return e.value();
        }
        return this.getFromHashMap(type);
    }

    Entry<T> castEntry(Entry<?> e) {
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T getFromHashMap(Class<?> type) {
        Entry e;
        ClassValueMap map = ClassValue.getMap(type);
        do {
            if (!(e = map.startEntry(this)).isPromise()) {
                return e.value();
            }
            try {
                e = ClassValue.makeEntry(e.version(), this.computeValue(type));
            }
            finally {
                e = map.finishEntry(this, e);
            }
        } while (e == null);
        return e.value();
    }

    boolean match(Entry<?> e) {
        return e != null && e.get() == this.version;
    }

    Version<T> version() {
        return this.version;
    }

    void bumpVersion() {
        this.version = new Version(this);
    }

    private static ClassValueMap getMap(Class<?> type) {
        ClassValueMap map = type.classValueMap;
        if (map != null) {
            return map;
        }
        return ClassValue.initializeMap(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClassValueMap initializeMap(Class<?> type) {
        ClassValueMap map;
        Object object = CRITICAL_SECTION;
        synchronized (object) {
            map = type.classValueMap;
            if (map == null) {
                map = new ClassValueMap(type);
                UNSAFE.storeFence();
                type.classValueMap = map;
            }
        }
        return map;
    }

    static <T> Entry<T> makeEntry(Version<T> explicitVersion, T value) {
        return new Entry<T>(explicitVersion, value);
    }

    static class ClassValueMap
    extends WeakHashMap<Identity, Entry<?>> {
        private final Class<?> type;
        private Entry<?>[] cacheArray;
        private int cacheLoad;
        private int cacheLoadLimit;
        private static final int INITIAL_ENTRIES = 32;
        private static final int CACHE_LOAD_LIMIT = 67;
        private static final int PROBE_LIMIT = 6;

        ClassValueMap(Class<?> type) {
            this.type = type;
            this.sizeCache(32);
        }

        Entry<?>[] getCache() {
            return this.cacheArray;
        }

        synchronized <T> Entry<T> startEntry(ClassValue<T> classValue) {
            Entry<T> e = (Entry<T>)this.get(classValue.identity);
            Version<T> v = classValue.version();
            if (e == null) {
                e = v.promise();
                this.put(classValue.identity, e);
                return e;
            }
            if (e.isPromise()) {
                if (e.version() != v) {
                    e = v.promise();
                    this.put(classValue.identity, e);
                }
                return e;
            }
            if (e.version() != v) {
                e = e.refreshVersion(v);
                this.put(classValue.identity, e);
            }
            this.checkCacheLoad();
            this.addToCache(classValue, e);
            return e;
        }

        synchronized <T> Entry<T> finishEntry(ClassValue<T> classValue, Entry<T> e) {
            Entry e0 = (Entry)this.get(classValue.identity);
            if (e == e0) {
                assert (e.isPromise());
                this.remove(classValue.identity);
                return null;
            }
            if (e0 != null && e0.isPromise() && e0.version() == e.version()) {
                Version<T> v = classValue.version();
                if (e.version() != v) {
                    e = e.refreshVersion(v);
                }
                this.put(classValue.identity, e);
                this.checkCacheLoad();
                this.addToCache(classValue, e);
                return e;
            }
            return null;
        }

        synchronized void removeEntry(ClassValue<?> classValue) {
            Entry e = (Entry)this.remove(classValue.identity);
            if (e != null) {
                if (e.isPromise()) {
                    this.put(classValue.identity, e);
                } else {
                    classValue.bumpVersion();
                    this.removeStaleEntries(classValue);
                }
            }
        }

        synchronized <T> void changeEntry(ClassValue<T> classValue, T value) {
            Entry e0 = (Entry)this.get(classValue.identity);
            Version<T> version = classValue.version();
            if (e0 != null) {
                if (e0.version() == version && e0.value() == value) {
                    return;
                }
                classValue.bumpVersion();
                this.removeStaleEntries(classValue);
            }
            Entry<T> e = ClassValue.makeEntry(version, value);
            this.put(classValue.identity, e);
            this.checkCacheLoad();
            this.addToCache(classValue, e);
        }

        static Entry<?> loadFromCache(Entry<?>[] cache, int i) {
            return cache[i & cache.length - 1];
        }

        static <T> Entry<T> probeHomeLocation(Entry<?>[] cache, ClassValue<T> classValue) {
            return classValue.castEntry(ClassValueMap.loadFromCache(cache, classValue.hashCodeForCache));
        }

        static <T> Entry<T> probeBackupLocations(Entry<?>[] cache, ClassValue<T> classValue) {
            Entry<?> e;
            int mask = cache.length - 1;
            int home = classValue.hashCodeForCache & mask;
            Entry<?> e2 = cache[home];
            if (e2 == null) {
                return null;
            }
            int pos2 = -1;
            for (int i = home + 1; i < home + 6 && (e = cache[i & mask]) != null; ++i) {
                if (classValue.match(e)) {
                    cache[home] = e;
                    if (pos2 >= 0) {
                        cache[i & mask] = Entry.DEAD_ENTRY;
                    } else {
                        pos2 = i;
                    }
                    cache[pos2 & mask] = ClassValueMap.entryDislocation(cache, pos2, e2) < 6 ? e2 : Entry.DEAD_ENTRY;
                    return classValue.castEntry(e);
                }
                if (e.isLive() || pos2 >= 0) continue;
                pos2 = i;
            }
            return null;
        }

        private static int entryDislocation(Entry<?>[] cache, int pos, Entry<?> e) {
            ClassValue<?> cv = e.classValueOrNull();
            if (cv == null) {
                return 0;
            }
            int mask = cache.length - 1;
            return pos - cv.hashCodeForCache & mask;
        }

        private void sizeCache(int length) {
            assert ((length & length - 1) == 0);
            this.cacheLoad = 0;
            this.cacheLoadLimit = (int)((double)length * 67.0 / 100.0);
            this.cacheArray = new Entry[length];
        }

        private void checkCacheLoad() {
            if (this.cacheLoad >= this.cacheLoadLimit) {
                this.reduceCacheLoad();
            }
        }

        private void reduceCacheLoad() {
            this.removeStaleEntries();
            if (this.cacheLoad < this.cacheLoadLimit) {
                return;
            }
            Entry<?>[] oldCache = this.getCache();
            if (oldCache.length > 0x3FFFFFFF) {
                return;
            }
            this.sizeCache(oldCache.length * 2);
            for (Entry<?> e : oldCache) {
                if (e == null || !e.isLive()) continue;
                this.addToCache(e);
            }
        }

        private void removeStaleEntries(Entry<?>[] cache, int begin, int count) {
            int mask = cache.length - 1;
            int removed = 0;
            for (int i = begin; i < begin + count; ++i) {
                Entry<?> e = cache[i & mask];
                if (e == null || e.isLive()) continue;
                Entry<?> replacement = null;
                replacement = this.findReplacement(cache, i);
                cache[i & mask] = replacement;
                if (replacement != null) continue;
                ++removed;
            }
            this.cacheLoad = Math.max(0, this.cacheLoad - removed);
        }

        private Entry<?> findReplacement(Entry<?>[] cache, int home1) {
            Entry<?> e2;
            Entry<?> replacement = null;
            int haveReplacement = -1;
            int replacementPos = 0;
            int mask = cache.length - 1;
            for (int i2 = home1 + 1; i2 < home1 + 6 && (e2 = cache[i2 & mask]) != null; ++i2) {
                int home2;
                int dis2;
                if (!e2.isLive() || (dis2 = ClassValueMap.entryDislocation(cache, i2, e2)) == 0 || (home2 = i2 - dis2) > home1) continue;
                if (home2 == home1) {
                    haveReplacement = 1;
                    replacementPos = i2;
                    replacement = e2;
                    continue;
                }
                if (haveReplacement > 0) continue;
                haveReplacement = 0;
                replacementPos = i2;
                replacement = e2;
            }
            if (haveReplacement >= 0) {
                if (cache[replacementPos + 1 & mask] != null) {
                    cache[replacementPos & mask] = Entry.DEAD_ENTRY;
                } else {
                    cache[replacementPos & mask] = null;
                    --this.cacheLoad;
                }
            }
            return replacement;
        }

        private void removeStaleEntries(ClassValue<?> classValue) {
            this.removeStaleEntries(this.getCache(), classValue.hashCodeForCache, 6);
        }

        private void removeStaleEntries() {
            Entry<?>[] cache = this.getCache();
            this.removeStaleEntries(cache, 0, cache.length + 6 - 1);
        }

        private <T> void addToCache(Entry<T> e) {
            ClassValue<T> classValue = e.classValueOrNull();
            if (classValue != null) {
                this.addToCache(classValue, e);
            }
        }

        private <T> void addToCache(ClassValue<T> classValue, Entry<T> e) {
            int home2;
            int mask;
            int home;
            Entry<?>[] cache = this.getCache();
            Entry<?> e2 = this.placeInCache(cache, home = classValue.hashCodeForCache & (mask = cache.length - 1), e, false);
            if (e2 == null) {
                return;
            }
            int dis2 = ClassValueMap.entryDislocation(cache, home, e2);
            for (int i2 = home2 = home - dis2; i2 < home2 + 6; ++i2) {
                if (this.placeInCache(cache, i2 & mask, e2, true) != null) continue;
                return;
            }
        }

        private Entry<?> placeInCache(Entry<?>[] cache, int pos, Entry<?> e, boolean gently) {
            Entry<?> e2 = this.overwrittenEntry(cache[pos]);
            if (gently && e2 != null) {
                return e;
            }
            cache[pos] = e;
            return e2;
        }

        private <T> Entry<T> overwrittenEntry(Entry<T> e2) {
            if (e2 == null) {
                ++this.cacheLoad;
            } else if (e2.isLive()) {
                return e2;
            }
            return null;
        }
    }

    static class Entry<T>
    extends WeakReference<Version<T>> {
        final Object value;
        static final Entry<?> DEAD_ENTRY = new Entry<Object>(null, null);

        Entry(Version<T> version, T value) {
            super(version);
            this.value = value;
        }

        private void assertNotPromise() {
            assert (!this.isPromise());
        }

        Entry(Version<T> version) {
            super(version);
            this.value = this;
        }

        T value() {
            this.assertNotPromise();
            return (T)this.value;
        }

        boolean isPromise() {
            return this.value == this;
        }

        Version<T> version() {
            return (Version)this.get();
        }

        ClassValue<T> classValueOrNull() {
            Version<T> v = this.version();
            return v == null ? null : v.classValue();
        }

        boolean isLive() {
            Version<T> v = this.version();
            if (v == null) {
                return false;
            }
            if (v.isLive()) {
                return true;
            }
            this.clear();
            return false;
        }

        Entry<T> refreshVersion(Version<T> v2) {
            this.assertNotPromise();
            Entry<Object> e2 = new Entry<Object>(v2, this.value);
            this.clear();
            return e2;
        }
    }

    static class Version<T> {
        private final ClassValue<T> classValue;
        private final Entry<T> promise = new Entry(this);

        Version(ClassValue<T> classValue) {
            this.classValue = classValue;
        }

        ClassValue<T> classValue() {
            return this.classValue;
        }

        Entry<T> promise() {
            return this.promise;
        }

        boolean isLive() {
            return this.classValue.version() == this;
        }
    }

    static class Identity {
        Identity() {
        }
    }
}

